/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.flink.connector.redis.sink;

import net.wicp.tams.common.flink.connector.redis.connector.RedisRichSinkFunction;
import org.apache.flink.api.common.functions.Partitioner;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.format.EncodingFormat;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.sink.SinkFunctionProvider;
import org.apache.flink.table.data.RowData;
import org.apache.flink.types.RowKind;

public class RedisDynamicTableSink
implements DynamicTableSink,
Partitioner<Object> {
    private static final long serialVersionUID = 1L;
    public static final String IDENTIFIER = "redis";
    private final ResolvedSchema schema;
    private final EncodingFormat<SerializationSchema<RowData>> encodingFormat;
    private final Configuration options;

    public RedisDynamicTableSink(ResolvedSchema schema, EncodingFormat<SerializationSchema<RowData>> encodingFormat, Configuration options) {
        this.schema = schema;
        this.encodingFormat = encodingFormat;
        this.options = options;
    }

    public ChangelogMode getChangelogMode(ChangelogMode requestedMode) {
        return ChangelogMode.newBuilder().addContainedKind(RowKind.INSERT).addContainedKind(RowKind.UPDATE_BEFORE).addContainedKind(RowKind.UPDATE_AFTER).addContainedKind(RowKind.DELETE).build();
    }

    public DynamicTableSink.SinkRuntimeProvider getSinkRuntimeProvider(DynamicTableSink.Context context) {
        SerializationSchema serializationSchema = (SerializationSchema)this.encodingFormat.createRuntimeEncoder(context, this.schema.toSinkRowDataType());
        RedisRichSinkFunction redisRichSinkFunction = new RedisRichSinkFunction(this.schema, (SerializationSchema<RowData>)serializationSchema, this.options);
        return SinkFunctionProvider.of((SinkFunction)redisRichSinkFunction);
    }

    public DynamicTableSink copy() {
        return new RedisDynamicTableSink(this.schema, this.encodingFormat, this.options);
    }

    public String asSummaryString() {
        return IDENTIFIER;
    }

    public int partition(Object key, int numPartitions) {
        return 0;
    }
}

