/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.flink.connector.redis.options;

import java.io.Serializable;

public class RedisLookupOptions
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_MAX_RETRY_TIMES = 3;
    protected final String hostname;
    protected final int port;
    private final long cacheMaxSize;
    private final long cacheExpireMs;
    private final int maxRetryTimes;
    private final boolean lookupAsync;
    private final boolean isBatchMode;
    private final int batchSize;
    private final int batchMinTriggerDelayMs;
    private final String groupid;
    private final String searchkeyprefix;

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public String getGroupid() {
        return this.groupid;
    }

    public String getSearchkeyprefix() {
        return this.searchkeyprefix;
    }

    public RedisLookupOptions(long cacheMaxSize, long cacheExpireMs, int maxRetryTimes, boolean lookupAsync, String hostname, int port, boolean isBatchMode, int batchSize, int batchMinTriggerDelayMs, String groupid, String searchkeyprefix) {
        this.cacheMaxSize = cacheMaxSize;
        this.cacheExpireMs = cacheExpireMs;
        this.maxRetryTimes = maxRetryTimes;
        this.lookupAsync = lookupAsync;
        this.hostname = hostname;
        this.port = port;
        this.isBatchMode = isBatchMode;
        this.batchSize = batchSize;
        this.batchMinTriggerDelayMs = batchMinTriggerDelayMs;
        this.searchkeyprefix = searchkeyprefix;
        this.groupid = groupid;
    }

    public long getCacheMaxSize() {
        return this.cacheMaxSize;
    }

    public long getCacheExpireMs() {
        return this.cacheExpireMs;
    }

    public int getMaxRetryTimes() {
        return this.maxRetryTimes;
    }

    public boolean getLookupAsync() {
        return this.lookupAsync;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean isBatchMode() {
        return this.isBatchMode;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public int getBatchMinTriggerDelayMs() {
        return this.batchMinTriggerDelayMs;
    }

    public String toString() {
        return "RedisLookupOptions{hostname='" + this.hostname + '\'' + ", port=" + this.port + ", cacheMaxSize=" + this.cacheMaxSize + ", cacheExpireMs=" + this.cacheExpireMs + ", maxRetryTimes=" + this.maxRetryTimes + ", lookupAsync=" + this.lookupAsync + ", isBatchMode=" + this.isBatchMode + ", batchSize=" + this.batchSize + ", batchMinTriggerDelayMs=" + this.batchMinTriggerDelayMs + ", groupid='" + this.groupid + '\'' + ", searchkeyprefix='" + this.searchkeyprefix + '\'' + '}';
    }

    public static class Builder {
        private long cacheMaxSize = -1L;
        private long cacheExpireMs = 0L;
        private int maxRetryTimes = 3;
        private boolean lookupAsync = false;
        private boolean isBatchMode = false;
        private String searchkeyprefix;
        private String groupid;
        private int batchSize = 30;
        private int batchMinTriggerDelayMs = 1000;
        protected String hostname = "localhost";
        protected int port = 6379;

        public Builder setSearchkeyprefix(String searchkeyprefix) {
            this.searchkeyprefix = searchkeyprefix;
            return this;
        }

        public Builder setGroupid(String groupid) {
            this.groupid = groupid;
            return this;
        }

        public Builder setIsBatchMode(boolean isBatchMode) {
            this.isBatchMode = isBatchMode;
            return this;
        }

        public Builder setBatchSize(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public Builder setBatchMinTriggerDelayMs(int batchMinTriggerDelayMs) {
            this.batchMinTriggerDelayMs = batchMinTriggerDelayMs;
            return this;
        }

        public Builder setCacheMaxSize(long cacheMaxSize) {
            this.cacheMaxSize = cacheMaxSize;
            return this;
        }

        public Builder setCacheExpireMs(long cacheExpireMs) {
            this.cacheExpireMs = cacheExpireMs;
            return this;
        }

        public Builder setMaxRetryTimes(int maxRetryTimes) {
            this.maxRetryTimes = maxRetryTimes;
            return this;
        }

        public Builder setLookupAsync(boolean lookupAsync) {
            this.lookupAsync = lookupAsync;
            return this;
        }

        public Builder setHostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public Builder setPort(int port) {
            this.port = port;
            return this;
        }

        public RedisLookupOptions build() {
            return new RedisLookupOptions(this.cacheMaxSize, this.cacheExpireMs, this.maxRetryTimes, this.lookupAsync, this.hostname, this.port, this.isBatchMode, this.batchSize, this.batchMinTriggerDelayMs, this.groupid, this.searchkeyprefix);
        }
    }
}

