/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.flink.connector.redis.container;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import net.wicp.tams.common.flink.connector.redis.container.RedisCommandsContainer;
import net.wicp.tams.common.redis.pool.AbsPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisSentinelPool;
import redis.clients.jedis.Pipeline;

public class RedisContainer
implements RedisCommandsContainer,
Closeable {
    private static final long serialVersionUID = 1L;
    private transient JedisPool jedisPool;
    private transient JedisSentinelPool jedisSentinelPool;
    private transient AbsPool standalone;
    private static final Logger LOG = LoggerFactory.getLogger(RedisContainer.class);

    public RedisContainer(JedisPool jedisPool) {
        this.jedisPool = jedisPool;
        this.jedisSentinelPool = null;
    }

    public RedisContainer(JedisSentinelPool sentinelPool) {
        this.jedisPool = null;
        this.jedisSentinelPool = sentinelPool;
    }

    public RedisContainer(AbsPool standalone) {
        this.standalone = standalone;
    }

    private Jedis getInstance() {
        if (this.standalone != null) {
            return this.standalone.getResource();
        }
        if (this.jedisSentinelPool != null) {
            return this.jedisSentinelPool.getResource();
        }
        return this.jedisPool.getResource();
    }

    private void releaseInstance(Jedis jedis) {
        if (jedis == null) {
            return;
        }
        try {
            jedis.close();
        }
        catch (Exception e) {
            LOG.error("Failed to close (return) instance to pool", (Throwable)e);
        }
    }

    @Override
    public void open() throws Exception {
        Jedis jedis = this.getInstance();
        String reply = jedis.echo("test");
        System.out.println("testreply==>" + reply);
        System.out.println("jedis\u662f\u5426\u5df2\u8fde\u63a5==>" + jedis.isConnected());
        System.out.println("jedis\u8fde\u63a5\u4fe1\u606f==>" + jedis.getConnection().toString());
    }

    @Override
    public List<Object> multiGet(List<byte[]> key) {
        Jedis jedis = null;
        try {
            jedis = this.getInstance();
            Pipeline pipeline = jedis.pipelined();
            key.forEach(arg_0 -> ((Pipeline)pipeline).get(arg_0));
            List list = pipeline.syncAndReturnAll();
            return list;
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Cannot send Redis message with command GET to key {} error message {}", key, (Object)e.getMessage());
            }
            throw e;
        }
        finally {
            this.releaseInstance(jedis);
        }
    }

    @Override
    public byte[] get(byte[] key) {
        Jedis jedis = null;
        try {
            jedis = this.getInstance();
            byte[] byArray = jedis.get(key);
            return byArray;
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Cannot send Redis message with command GET to key {} error message {}", (Object)key, (Object)e.getMessage());
            }
            throw e;
        }
        finally {
            this.releaseInstance(jedis);
        }
    }

    @Override
    public byte[] hget(byte[] key, byte[] hashField) {
        Jedis jedis = null;
        try {
            jedis = this.getInstance();
            byte[] byArray = jedis.hget(key, hashField);
            return byArray;
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Cannot send Redis message with command HGET to key {} hashField {} error message {}", new Object[]{key, hashField, e.getMessage()});
            }
            throw e;
        }
        finally {
            this.releaseInstance(jedis);
        }
    }

    @Override
    public Map<String, String> hgetAll(String key) {
        Jedis jedis = null;
        try {
            jedis = this.getInstance();
            Map map = jedis.hgetAll(key);
            return map;
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Cannot send Redis message with command HGET to key {} hashField {} error message {}", (Object)key, (Object)e.getMessage());
            }
            throw e;
        }
        finally {
            this.releaseInstance(jedis);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.jedisPool != null) {
            this.jedisPool.close();
        }
        if (this.jedisSentinelPool != null) {
            this.jedisSentinelPool.close();
        }
        if (this.standalone != null || this.standalone.isInit()) {
            this.standalone.destroy();
        }
    }
}

