/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common
 * 项目描述：公共的工具集
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.flink.connector.redis.container;

import net.wicp.tams.common.flink.connector.redis.config.FlinkJedisConfigBase;
import net.wicp.tams.common.flink.connector.redis.config.FlinkJedisPoolConfig;
import net.wicp.tams.common.flink.connector.redis.options.RedisLookupOptions;
import net.wicp.tams.common.redis.RedisAssit;
import net.wicp.tams.common.redis.pool.AbsPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.JedisPool;

import java.util.Objects;


public class RedisCommandsContainerBuilder {
    private static AbsPool standalone;
    private static RedisLookupOptions redisLookupOptions;
    public static RedisCommandsContainer build(FlinkJedisConfigBase flinkJedisConfigBase) {
        if (flinkJedisConfigBase instanceof FlinkJedisPoolConfig) {
            FlinkJedisPoolConfig flinkJedisPoolConfig = (FlinkJedisPoolConfig) flinkJedisConfigBase;
            return RedisCommandsContainerBuilder.build(flinkJedisPoolConfig);
        }

//        else if (flinkJedisConfigBase instanceof FlinkJedisClusterConfig) {
//            FlinkJedisClusterConfig flinkJedisClusterConfig = (FlinkJedisClusterConfig) flinkJedisConfigBase;
//            return RedisCommandsContainerBuilder.build(flinkJedisClusterConfig);
//        } else if (flinkJedisConfigBase instanceof FlinkJedisSentinelConfig) {
//            FlinkJedisSentinelConfig flinkJedisSentinelConfig = (FlinkJedisSentinelConfig) flinkJedisConfigBase;
//            return RedisCommandsContainerBuilder.build(flinkJedisSentinelConfig);
//        }

        else {
            throw new IllegalArgumentException("Jedis configuration not found");
        }
    }

    public static RedisCommandsContainer build(RedisLookupOptions redisLookupOptions) {
        String serverName = redisLookupOptions.getGroupid();
        if (standalone == null || !standalone.isInit()) {
            standalone = RedisAssit.standalone(serverName);
        }
        return new RedisContainer(standalone);
    }

    public static RedisCommandsContainer build(FlinkJedisPoolConfig jedisPoolConfig) {
        Objects.requireNonNull(jedisPoolConfig, "Redis pool config should not be Null");
        GenericObjectPoolConfig genericObjectPoolConfig = new GenericObjectPoolConfig();
        genericObjectPoolConfig.setMaxIdle(jedisPoolConfig.getMaxIdle());
        genericObjectPoolConfig.setMaxTotal(jedisPoolConfig.getMaxTotal());
        genericObjectPoolConfig.setMinIdle(jedisPoolConfig.getMinIdle());

        JedisPool jedisPool = new JedisPool(genericObjectPoolConfig, jedisPoolConfig.getHost(),
                jedisPoolConfig.getPort(), jedisPoolConfig.getConnectionTimeout(), jedisPoolConfig.getPassword(),
                jedisPoolConfig.getDatabase());
        return new RedisContainer(jedisPool);
    }


}
