/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common
 * 项目描述：公共的工具集
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.flink.connector.kafka.connector;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;

import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.state.FunctionInitializationContext;
import org.apache.flink.runtime.state.FunctionSnapshotContext;
import org.apache.flink.streaming.api.checkpoint.CheckpointedFunction;
import org.apache.flink.streaming.api.functions.source.RichSourceFunction;
import org.apache.flink.table.catalog.UniqueConstraint;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.RowType.RowField;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.util.Preconditions;

import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.constant.FieldFormart;
import net.wicp.tams.common.constant.ods.AddColName;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;
import net.wicp.tams.common.flink.common.constant.EnvName;
import net.wicp.tams.common.flink.common.constant.FlinkTypeEnum;
import net.wicp.tams.common.flink.connector.kafka.KafkaOptions;
import net.wicp.tams.common.kafka.KafkaAdmin;

/***
 * 不需要CheckpointedFunction,不设置并行度，就是Source默认并行度为cpu core数
 * 
 * 此Source不需要设置并行度，在工具类中会跟据patition个数自动启多线程。
 * 
 * @author Andy.zhou
 *
 */
public class KafkaScanFunction extends RichSourceFunction<RowData>
		implements ResultTypeQueryable<RowData>, CheckpointedFunction {
	private static final long serialVersionUID = 1L;

	private final Configuration optionsWith;

	@SuppressWarnings("unused")
	private final List<RowField> rowTypeFields;

	@SuppressWarnings("unused")
	private final List<String> keys;

	private final String groupId;

	private final List<String> addColNames = new ArrayList<String>();// 附加字段

	// net.wicp.tams.common.constant.FieldFormart$1@350f18a6 is not serializable.
	// The object probably contains or references non serializable fields.
	private transient FieldFormart fieldFormart;// 列格式

	private final DeserializationSchema<RowData> deserializationSchema;

	// private transient RecordCollector collector;

	/***
	 * 需要在配置文件中存在相关的配置
	 * 
	 * @param optionsWith
	 * @param rowTypeFields
	 */
	public KafkaScanFunction(Configuration optionsWith, List<RowField> rowTypeFields, UniqueConstraint primaryKey,
			String tableName, DeserializationSchema<RowData> deserializationSchema) {
		this.optionsWith = optionsWith;
		this.rowTypeFields = rowTypeFields;
		this.deserializationSchema = deserializationSchema;
		this.keys = primaryKey == null ? null : primaryKey.getColumns();
		this.fieldFormart = FieldFormart.ori;
		String groupid = EnvName.tamskafkagroupid.getValue();
		this.groupId = StringUtil.hasNull(groupid, tableName);// tableName为默认的groupid

		// 检查类型
		List<String> allColList = AddColName.getAllColNameTrue(this.fieldFormart);
		for (RowField rowField : rowTypeFields) {
			if (allColList.contains(rowField.getName())) {
				this.addColNames.add(rowField.getName());
			}
			FlinkTypeEnum flinkTypeEnum = FlinkTypeEnum.findByFlinkRowType(rowField.getType().getTypeRoot().toString());
			if (flinkTypeEnum == null) {
				throw new ProjectExceptionRuntime(ExceptAll.param_notfit,
						"列：【" + rowField.getName() + "】不支持的类型【" + rowField.getType().getTypeRoot().toString() + "】");
			}
		}

	}

	@Override
	public void run(SourceContext<RowData> ctx) throws Exception {
		KafkaConsumerListerWrap lister = new KafkaConsumerListerWrap(this.groupId,
				optionsWith.getString(KafkaOptions.topic), deserializationSchema, ctx);
		lister.start();
	}

	public static int[] createValueFormatProjection(DataType physicalDataType) {
		final LogicalType physicalType = physicalDataType.getLogicalType();
		Preconditions.checkArgument(physicalType.getTypeRoot() == LogicalTypeRoot.ROW, "Row data type expected.");
		final int physicalFieldCount = LogicalTypeChecks.getFieldCount(physicalType);
		final IntStream physicalFields = IntStream.range(0, physicalFieldCount);

		return physicalFields.toArray();
	}

	@Override
	public void cancel() {

	}

	@Override
	public TypeInformation<RowData> getProducedType() {
		return this.deserializationSchema.getProducedType();
	}

	@Override
	public void setRuntimeContext(RuntimeContext t) {
		super.setRuntimeContext(t);
	}

	@Override
	public void open(Configuration parameters) throws Exception {
		super.open(parameters);
		KafkaOptions.packageOptionsSource(this.optionsWith);
		KafkaAdmin admin = new KafkaAdmin(optionsWith.getString(KafkaOptions.kafkaservice));
		admin.initGroupId(optionsWith.getString(KafkaOptions.topic), this.groupId);// 初始化groupid
	}

	@Override
	public void snapshotState(FunctionSnapshotContext context) throws Exception {
		// TODO 暂时不做
	}

	@Override
	public void initializeState(FunctionInitializationContext context) throws Exception {
		// TODO 暂时不做
	}

}
