package net.wicp.tams.common.flink.connector.kafka.connector;

import java.util.ArrayList;
import java.util.List;

import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.streaming.api.functions.source.SourceFunction.SourceContext;
import org.apache.flink.table.data.RowData;
import org.apache.flink.util.Collector;
import org.apache.kafka.clients.consumer.ConsumerRecord;

import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.LoggerUtil;
import net.wicp.tams.common.apiext.TimeAssist;
import net.wicp.tams.common.binlog.alone.binlog.listener.IConsumerListener;
import net.wicp.tams.common.constant.JvmStatus;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;
import net.wicp.tams.common.kafka.IConsumer;
import net.wicp.tams.common.kafka.KafkaConsumerGroupB;

@Slf4j
public class KafkaConsumerListerWrap {

	private final KafkaConsumerGroupB kafkaConsumerGroupB;

	public KafkaConsumerListerWrap(String groupid, String topicName, DeserializationSchema<RowData> deserializationSchema,
			SourceContext<RowData> ctx) {
		this.kafkaConsumerGroupB = new KafkaConsumerGroupB(false, groupid, topicName, new IConsumer<byte[]>() {
			@Override
			public Result doWithRecords(List<ConsumerRecord<String, byte[]>> consumerRecords) {
				RecordCollector out = new RecordCollector();
				for (ConsumerRecord<String, byte[]> consumerRecord : consumerRecords) {
					try {
						deserializationSchema.deserialize(consumerRecord.value(), out);
					} catch (Exception e) {
						throw new ProjectExceptionRuntime(ExceptAll.flink_source_deserialize,
								"kafka数据deserialize为rowData失败");
					}
					log.info("offset:" + consumerRecord.offset());
				}
				for (RowData rowData : out.getRecords()) {
					ctx.collect(rowData);
				}
				return Result.getSuc();// TODO 后续要与checkpoint 两阶段提交关联起来
			}

			@Override
			public void doInit(IConsumerListener plugin) {

			}
		}, 1);

	}

	public void start() {
		this.kafkaConsumerGroupB.start();
		// 不能让它跑了。否则报：The Source Context has been closed already.
		while (true) {
			try {
				System.in.read();
				TimeAssist.reDoWaitInit("need-init");// 重新等待
			} catch (Throwable e) {// 防止网络闪动，断网重试
				boolean reDoWait = TimeAssist.reDoWait("need-init", 8);
				log.error("readdo error", e);
				if (reDoWait) {// 256秒即4分种*2=8分钟，8分钟就不是网络抖动问题了
					log.error("已重试8次，退出系统");
					LoggerUtil.exit(JvmStatus.s15);
				}
			}
		}
	}

	private class RecordCollector implements Collector<RowData> {
//      private final Queue<RowData> records = new ArrayDeque<>();
		private final List<RowData> records = new ArrayList<RowData>();

		public List<RowData> getRecords() {
			return records;
		}

		@Override
		public void collect(RowData record) {
			records.add(record);
		}

		@Override
		public void close() {
		}
	}

}
