package net.wicp.tams.common.flink.connector.kafka;

import java.util.Properties;

import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.ReadableConfig;

import net.wicp.tams.common.Conf;

/***
 * format 来自FactoryUtil.FORMAT，是可选项。默认为duckula的formate
 * 
 * @author Andy
 *
 */
public abstract class KafkaOptions {
	public static final String ENVNAME = "tamskafkaGroupId";// 放到环境变量里的kafkagroupid
	
	
	public static final ConfigOption<String> kafkaservice = ConfigOptions.key("properties.bootstrap.servers")
			.stringType().noDefaultValue().withDescription("主机");// 为了与开源kafka
																	// connector兼容，采用properties.bootstrap.servers值

//	public static final ConfigOption<Integer> port = ConfigOptions.key("port").intType().defaultValue(9092)
//			.withDescription("端口");
	public static final ConfigOption<String> topic = ConfigOptions.key("topic").stringType().noDefaultValue()
			.withDescription("数据的topic");

	// earliest/latest/none:topic各分区都存在已提交的offset时，从offset后开始消费；只要有一个分区不存在已提交的offset，则抛出异常
	public static final ConfigOption<String> offset = ConfigOptions.key("offset").stringType().defaultValue("earliest")
			.withDescription("消费的offset");// consumer专用，与原始的kafka保持一致
	
	
	//是否逻辑对冲,sink用。"logic":逻辑删除 "physics":物理删除   "no"：不做对冲
	public static final ConfigOption<String> hedge = ConfigOptions.key("hedge").stringType().defaultValue("no")
			.withDescription("对冲模式");
	

	

	public static void packageOptionsSink(ReadableConfig options) {
		Properties props = new Properties();
		props.put("common.kafka.common.bootstrap.servers", options.get(KafkaOptions.kafkaservice));
		props.put("common.kafka.consumer.auto.offset.reset", options.get(KafkaOptions.offset));
		Conf.overProp(props);
	}
	
	
	public static void packageOptionsSource(ReadableConfig options) {
		packageOptionsSink(options);
		Properties props = new Properties();
		props.put("common.kafka.consumer.auto.offset.reset", options.get(KafkaOptions.offset));
		Conf.overProp(props);
	}

}
