/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.flink.connector.kafka.source;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.wicp.tams.common.constant.Middleware;
import net.wicp.tams.common.flink.connector.kafka.connector.KafkaScanFunction;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.UniqueConstraint;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.format.DecodingFormat;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.ScanTableSource;
import org.apache.flink.table.connector.source.SourceFunctionProvider;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.utils.DataTypeUtils;
import org.apache.flink.util.Preconditions;

public class KafkaDynamicTableSource
implements ScanTableSource {
    protected final ResolvedSchema schema;
    private List<RowType.RowField> fields;
    private final String tableName;
    @Nullable
    protected final DecodingFormat<DeserializationSchema<RowData>> decodingFormat;
    private Configuration optionsWith;

    public KafkaDynamicTableSource(ResolvedSchema schema, DecodingFormat<DeserializationSchema<RowData>> decodingFormat, Configuration c, String tableName) {
        this.schema = schema;
        this.tableName = tableName;
        Preconditions.checkNotNull((Object)schema.toPhysicalRowDataType(), (String)"Physical data type must not be null.");
        this.decodingFormat = decodingFormat;
        this.optionsWith = c;
    }

    @Nullable
    private DeserializationSchema<RowData> createDeserialization(DynamicTableSource.Context context, @Nullable DecodingFormat<DeserializationSchema<RowData>> format, int[] projection) {
        if (format == null) {
            return null;
        }
        DataType physicalFormatDataType = DataTypeUtils.projectRow((DataType)this.schema.toPhysicalRowDataType(), (int[])projection);
        return (DeserializationSchema)format.createRuntimeDecoder(context, physicalFormatDataType);
    }

    public DynamicTableSource copy() {
        return new KafkaDynamicTableSource(this.schema, this.decodingFormat, this.optionsWith, this.tableName);
    }

    public String asSummaryString() {
        return Middleware.tamskafka.getDesc();
    }

    public ChangelogMode getChangelogMode() {
        return ChangelogMode.insertOnly();
    }

    public ScanTableSource.ScanRuntimeProvider getScanRuntimeProvider(ScanTableSource.ScanContext runtimeProviderContext) {
        RowType rowType = (RowType)this.schema.toPhysicalRowDataType().getLogicalType();
        this.fields = rowType.getFields();
        Optional primaryKeyopt = this.schema.getPrimaryKey();
        UniqueConstraint primaryKey = primaryKeyopt.isPresent() ? (UniqueConstraint)primaryKeyopt.get() : null;
        DeserializationSchema deserializationSchema = (DeserializationSchema)this.decodingFormat.createRuntimeDecoder((DynamicTableSource.Context)runtimeProviderContext, this.schema.toSinkRowDataType());
        KafkaScanFunction sourceFunction = new KafkaScanFunction(this.optionsWith, this.fields, primaryKey, this.tableName, (DeserializationSchema<RowData>)deserializationSchema);
        return SourceFunctionProvider.of((SourceFunction)sourceFunction, (boolean)false);
    }
}

