/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.flink.connector.kafka.partitioner;

import net.wicp.tams.common.binlog.alone.DuckulaAssit;
import net.wicp.tams.common.binlog.alone.ListenerConf;
import org.apache.flink.streaming.connectors.kafka.partitioner.FlinkKafkaPartitioner;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaTamsPartitioner<T>
extends FlinkKafkaPartitioner<T> {
    private static final Logger log = LoggerFactory.getLogger(KafkaTamsPartitioner.class);
    private static final long serialVersionUID = 1L;

    public void open(int parallelInstanceId, int parallelInstances) {
        Preconditions.checkArgument((parallelInstanceId >= 0 ? 1 : 0) != 0, (Object)"Id of this subtask cannot be negative.");
        Preconditions.checkArgument((parallelInstances > 0 ? 1 : 0) != 0, (Object)"Number of subtasks must be larger than 0.");
    }

    public int partition(T record, byte[] key, byte[] value, String targetTopic, int[] partitions) {
        Preconditions.checkArgument((partitions != null && partitions.length > 0 ? 1 : 0) != 0, (Object)"Partitions of the target topic is empty.");
        if (partitions.length == 1) {
            return 0;
        }
        try {
            ListenerConf.DuckulaEvent duckulaEvent = DuckulaAssit.parse((byte[])value);
            String keyJoin = DuckulaAssit.getKeyJoin((ListenerConf.DuckulaEvent.Builder)duckulaEvent.toBuilder(), (int)0, (String)"`");
            return keyJoin.hashCode() % partitions.length;
        }
        catch (Exception e) {
            log.error("\u5206\u533a\u5668\u53ea\u652f\u6301duckula\u7c7b\u578b\u7684\u6570\u636e,\u8bf7\u786e\u8ba4value\u7c7b\u578b", (Throwable)e);
            return 0;
        }
    }
}

