package net.wicp.tams.common.flink.connector.kafka.partitioner;

import org.apache.flink.streaming.connectors.kafka.partitioner.FlinkKafkaPartitioner;
import org.apache.flink.util.Preconditions;

import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.binlog.alone.DuckulaAssit;
import net.wicp.tams.common.binlog.alone.ListenerConf.DuckulaEvent;

/***
 * kafka connector的分区器
 * 
 * @author Andy.zhou
 *
 * @param <T>
 */
@Slf4j
public class KafkaTamsPartitioner<T> extends FlinkKafkaPartitioner<T> {
	private static final long serialVersionUID = 1L;
	// private int parallelInstanceId;

	public KafkaTamsPartitioner() {
	}

	public void open(int parallelInstanceId, int parallelInstances) {
		Preconditions.checkArgument(parallelInstanceId >= 0, "Id of this subtask cannot be negative.");
		Preconditions.checkArgument(parallelInstances > 0, "Number of subtasks must be larger than 0.");
		// this.parallelInstanceId = parallelInstanceId;
	}

	public int partition(T record, byte[] key, byte[] value, String targetTopic, int[] partitions) {
		Preconditions.checkArgument(partitions != null && partitions.length > 0,
				"Partitions of the target topic is empty.");
		if (partitions.length == 1) {// 只有一个分区
			return 0;
		}
		try {
			DuckulaEvent duckulaEvent = DuckulaAssit.parse(value);
			String keyJoin = DuckulaAssit.getKeyJoin(duckulaEvent.toBuilder(), 0, "`");// 只要key
			return keyJoin.hashCode() % partitions.length;
		} catch (Exception e) {
			log.error("分区器只支持duckula类型的数据,请确认value类型", e);
			return 0;
		}
	}
}
