/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common
 * 项目描述：公共的工具集
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.flink.connector.kafka;

import static net.wicp.tams.common.flink.connector.kafka.KafkaOptions.kafkaservice;
import static net.wicp.tams.common.flink.connector.kafka.KafkaOptions.offset;
import static net.wicp.tams.common.flink.connector.kafka.KafkaOptions.topic;

import java.util.HashSet;
import java.util.Set;

import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.connector.format.DecodingFormat;
import org.apache.flink.table.connector.format.EncodingFormat;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.factories.DecodingFormatFactory;
import org.apache.flink.table.factories.DeserializationFormatFactory;
import org.apache.flink.table.factories.DynamicTableSinkFactory;
import org.apache.flink.table.factories.DynamicTableSourceFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.factories.SerializationFormatFactory;

import net.wicp.tams.common.constant.Middleware;
import net.wicp.tams.common.flink.common.CommonOptions;
import net.wicp.tams.common.flink.common.DuckulaFormatFactory;
import net.wicp.tams.common.flink.connector.kafka.sink.KafkaDynamicTableSink;
import net.wicp.tams.common.flink.connector.kafka.source.KafkaDynamicTableSource;

public class KafkaDynamicTableFactory implements DynamicTableSourceFactory, DynamicTableSinkFactory {

	@Override
	public String factoryIdentifier() {
		return Middleware.tamskafka.getDesc();
	}

	@Override
	public Set<ConfigOption<?>> requiredOptions() {
		final Set<ConfigOption<?>> options = new HashSet<>();
		options.add(kafkaservice);
		return options;
	}

	@Override
	public Set<ConfigOption<?>> optionalOptions() {
		final Set<ConfigOption<?>> options = new HashSet<>();
		options.add(topic);
		// sink需要
		options.add(FactoryUtil.FORMAT); // 需要formate参数，用于sink时消息。
		options.add(CommonOptions.rowKindColName);
		// source需要
		options.add(offset);
		return options;
	}

	@Override
	public DynamicTableSink createDynamicTableSink(Context context) {
		final FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper(this, context);
		helper.validate();
		final ResolvedSchema schema = context.getCatalogTable().getResolvedSchema();
		// get the validated options
		final Configuration options = (Configuration) helper.getOptions();
		KafkaOptions.packageOptionsSink(options);

		if (!options.getOptional(FactoryUtil.FORMAT).isPresent()) {// 不存在时需要配置一个默认的。否则discoverEncodingFormat会出错。
			options.set(FactoryUtil.FORMAT, DuckulaFormatFactory.IDENTIFIER);
		}
		EncodingFormat<SerializationSchema<RowData>> encodingFormat = helper
				.discoverEncodingFormat(SerializationFormatFactory.class, FactoryUtil.FORMAT);
		return new KafkaDynamicTableSink(schema, encodingFormat, options, context.getCatalogTable().getPartitionKeys());
	}

	@Override
	public DynamicTableSource createDynamicTableSource(Context context) {
		// either implement your custom validation logic here ...
		// or use the provided helper utility
		final FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper(this, context);

		// discover a suitable decoding format
//        final DecodingFormat<DeserializationSchema<RowData>> decodingFormat = helper.discoverDecodingFormat(
//                DeserializationFormatFactory.class,
//                FactoryUtil.FORMAT);
//        final DecodingFormat<DeserializationSchema<RowData>> decodingFormat =
		// validate all options
		helper.validate();

		// get the validated options
		final Configuration options = (Configuration) helper.getOptions();
		KafkaOptions.packageOptionsSource(options);
//        TableSchema schema = context.getCatalogTable().getSchema();
		final ResolvedSchema schema = context.getCatalogTable().getResolvedSchema();
		String tableName = context.getObjectIdentifier().getObjectName();
		DecodingFormat<DeserializationSchema<RowData>> discoverDecodingFormat = helper
				.discoverDecodingFormat(DeserializationFormatFactory.class, FactoryUtil.FORMAT);
		return new KafkaDynamicTableSource(schema, discoverDecodingFormat, options, tableName);
	}

}