/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.flink.connector.jdbc.source;

import java.util.Arrays;
import java.util.List;
import net.wicp.tams.common.flink.connector.jdbc.function.JdbcRowDataLookupFunction;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.LookupTableSource;
import org.apache.flink.table.connector.source.ScanTableSource;
import org.apache.flink.table.connector.source.TableFunctionProvider;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.util.Preconditions;

public class JdbcDynamicTableSource
implements LookupTableSource,
ScanTableSource {
    ReadableConfig config;
    DataType dataType;
    List<String> tableprimarykeys;

    public JdbcDynamicTableSource(ReadableConfig config, DataType physicalRowDataType, List<String> tableprimarykeys) {
        this.config = config;
        this.dataType = physicalRowDataType;
        this.tableprimarykeys = tableprimarykeys;
    }

    public DynamicTableSource copy() {
        return new JdbcDynamicTableSource(this.config, this.dataType, this.tableprimarykeys);
    }

    public String asSummaryString() {
        return "tams-jdbc:";
    }

    public ChangelogMode getChangelogMode() {
        return ChangelogMode.insertOnly();
    }

    public ScanTableSource.ScanRuntimeProvider getScanRuntimeProvider(ScanTableSource.ScanContext runtimeProviderContext) {
        return null;
    }

    public LookupTableSource.LookupRuntimeProvider getLookupRuntimeProvider(LookupTableSource.LookupContext context) {
        String[] keyNames = new String[context.getKeys().length];
        for (int i = 0; i < keyNames.length; ++i) {
            int[] innerKeyArr = context.getKeys()[i];
            Preconditions.checkArgument((innerKeyArr.length == 1 ? 1 : 0) != 0, (Object)"JDBC only support non-nested look up keys");
            keyNames[i] = (String)DataType.getFieldNames((DataType)this.dataType).get(innerKeyArr[0]);
        }
        List<String> joinkeylist = Arrays.asList(keyNames);
        if (!this.tableprimarykeys.containsAll(joinkeylist)) {
            System.out.println("joinkeylist=============================================");
            joinkeylist.forEach(e -> System.out.println((String)e));
            System.out.println("tableprimarykeys=============================================");
            this.tableprimarykeys.forEach(e -> System.out.println((String)e));
            throw new RuntimeException("\u5173\u8054\u952e\u5fc5\u987b\u5305\u542b\u8868\u7684\u6240\u6709\u4e3b\u952e");
        }
        return TableFunctionProvider.of((TableFunction)new JdbcRowDataLookupFunction(this.config, this.dataType, keyNames, this.tableprimarykeys));
    }
}

