/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.flink.connector.jdbc.function;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.flink.connector.jdbc.JdbcSourceOptions;
import net.wicp.tams.common.flink.connector.jdbc.bean.RouteInfo;
import net.wicp.tams.common.flink.connector.jdbc.converter.AbstractJdbcRowConverter;
import net.wicp.tams.common.jdbc.DruidAssit;
import net.wicp.tams.common.redis.RedisAssit;
import net.wicp.tams.common.redis.pool.AbsPool;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.shaded.guava30.com.google.common.cache.Cache;
import org.apache.flink.shaded.guava30.com.google.common.cache.CacheBuilder;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.functions.FunctionContext;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import redis.clients.jedis.Jedis;

public class JdbcRowDataLookupFunction
extends TableFunction<RowData> {
    ReadableConfig config;
    DataType dataType;
    String[] keyNames;
    AbsPool absPool;
    RowType rowType;
    int routecolumnposition;
    private final AbstractJdbcRowConverter.JdbcDeserializationConverter[] toInternalConverters;
    String redisprefix;
    List<String> tableprimarykeys;
    List<LogicalType> logicalTypeswithoutroutecol = new ArrayList<LogicalType>();
    final String preparedsqlprefix = "select * from %s.%s where ";
    final String preparedsqlitem = " =? ";
    final String preparedsqljoiner = "and";
    final String space = " ";
    final Map<Integer, Integer> relationmap = new HashMap<Integer, Integer>();
    private transient Cache<RowData, List<RowData>> cache;

    public JdbcRowDataLookupFunction(ReadableConfig config, DataType dataType, String[] keyNames, List<String> tableprimarykeys) {
        this.config = config;
        this.dataType = dataType;
        this.rowType = (RowType)dataType.getLogicalType();
        this.keyNames = keyNames;
        this.redisprefix = (String)config.get(JdbcSourceOptions.searchkeyprefix);
        this.tableprimarykeys = tableprimarykeys;
        this.toInternalConverters = new AbstractJdbcRowConverter.JdbcDeserializationConverter[this.rowType.getFieldCount()];
        for (int i = 0; i < this.rowType.getFieldCount(); ++i) {
            this.toInternalConverters[i] = AbstractJdbcRowConverter.createNullableInternalConverter(this.rowType.getTypeAt(i));
        }
    }

    public void open(FunctionContext context) throws Exception {
        for (int i = 0; i < this.keyNames.length; ++i) {
            if (!this.keyNames[i].equals(this.config.get(JdbcSourceOptions.routecolumn))) continue;
            this.routecolumnposition = i;
            break;
        }
        Properties properties = new Properties();
        properties.setProperty("common.redis.redisserver.default.host", (String)this.config.get(JdbcSourceOptions.redisurl));
        properties.setProperty("common.redis.redisserver.default.port", (String)this.config.get(JdbcSourceOptions.redisport));
        properties.setProperty("common.redis.redisserver.default.defaultDb", (String)this.config.get(JdbcSourceOptions.redisdb));
        properties.setProperty("common.redis.redisserver.default.password", (String)this.config.get(JdbcSourceOptions.redispassword));
        Conf.overProp((Properties)properties);
        this.absPool = RedisAssit.getPool((String)"tamsjdbc-redisdatasource");
        this.cache = (Long)this.config.get(JdbcSourceOptions.cacheMaxSize) == -1L || (Long)this.config.get(JdbcSourceOptions.cacheExpireMs) == -1L ? null : CacheBuilder.newBuilder().expireAfterWrite(((Long)this.config.get(JdbcSourceOptions.cacheExpireMs)).longValue(), TimeUnit.MILLISECONDS).maximumSize(((Long)this.config.get(JdbcSourceOptions.cacheMaxSize)).longValue()).build();
        int logicalTypeswithoutroutecolindex = 0;
        for (int j = 0; j < this.keyNames.length; ++j) {
            if (j == this.routecolumnposition) continue;
            this.logicalTypeswithoutroutecol.add(this.rowType.getTypeAt(this.rowType.getFieldIndex(this.keyNames[j])));
            this.relationmap.put(logicalTypeswithoutroutecolindex, j);
            ++logicalTypeswithoutroutecolindex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eval(Object ... keys) throws SQLException {
        List cachedRows;
        GenericRowData keyRow = GenericRowData.of((Object[])keys);
        if (this.cache != null && (cachedRows = (List)this.cache.getIfPresent((Object)keyRow)) != null) {
            for (RowData cachedRow : cachedRows) {
                this.collect(cachedRow);
            }
            return;
        }
        Jedis jedis = null;
        RouteInfo routeInfo = null;
        try {
            jedis = this.absPool.getResource();
            routeInfo = (RouteInfo)AbsPool.getObjByMapValue(RouteInfo.class, (Jedis)jedis, (String)this.redisprefix.concat(":").concat(String.valueOf(keys[this.routecolumnposition])));
        }
        finally {
            this.absPool.returnResource(jedis);
        }
        Connection connection = null;
        try {
            if (routeInfo == null || StringUtils.isEmpty((CharSequence)routeInfo.getSlave_username()) || StringUtils.isEmpty((CharSequence)routeInfo.getSlave_password()) || StringUtils.isEmpty((CharSequence)routeInfo.getSlave_url()) || StringUtils.isEmpty((CharSequence)routeInfo.getSlave_port()) || "null".equals(routeInfo.getSlave_username()) || "null".equals(routeInfo.getSlave_password()) || "null".equals(routeInfo.getSlave_url()) || "null".equals(routeInfo.getSlave_port())) {
                this.collect(new GenericRowData(this.rowType.getFieldCount()));
                return;
            }
            DataSource dataSource = null;
            if (!DruidAssit.getDataSourceMap().containsKey(routeInfo.getSlave_url())) {
                Properties properties = new Properties();
                properties.setProperty("username", routeInfo.getSlave_username());
                properties.setProperty("password", routeInfo.getSlave_password());
                properties.setProperty("host", routeInfo.getSlave_url());
                if (!"3306".equals(routeInfo.getSlave_port())) {
                    properties.setProperty("port", routeInfo.getSlave_port());
                }
                Conf.overProp((Properties)properties);
                dataSource = DruidAssit.getDataSourceNoConf((String)routeInfo.getSlave_url(), (Properties)properties);
            } else {
                dataSource = DruidAssit.getDataSource((String)routeInfo.getSlave_url());
            }
            connection = dataSource.getConnection();
            String sqlprefix = String.format("select * from %s.%s where ", routeInfo.getDb(), this.config.get(JdbcSourceOptions.tablename));
            StringBuilder sqlformat = new StringBuilder();
            sqlformat.append(sqlprefix);
            for (int j = 0; j < this.keyNames.length; ++j) {
                if (j == this.routecolumnposition) continue;
                if (j != this.keyNames.length - 1) {
                    sqlformat.append(" ");
                    sqlformat.append(this.keyNames[j]);
                    sqlformat.append(" =? ");
                    sqlformat.append("and");
                    continue;
                }
                sqlformat.append(" ");
                sqlformat.append(this.keyNames[j]);
                sqlformat.append(" =? ");
            }
            String preparedsql = sqlformat.toString();
            if (preparedsql.lastIndexOf("and") + "and".length() == preparedsql.length()) {
                preparedsql = preparedsql.substring(0, preparedsql.lastIndexOf("and"));
            }
            System.out.println("preparedsql==>" + preparedsql);
            PreparedStatement ps = connection.prepareStatement(preparedsql);
            this.setPreparedsql(this.logicalTypeswithoutroutecol, ps, keys);
            ArrayList<RowData> rows = new ArrayList<RowData>();
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                RowData rowData = this.toInternal(rs);
                rows.add(rowData);
                this.collect(rowData);
            }
            if (!rows.isEmpty() && this.cache != null) {
                this.cache.put((Object)keyRow, rows);
            }
            rs.close();
            ps.close();
            DruidAssit.close((Connection)connection);
        }
        catch (Exception e) {
            System.out.println("\u51fa\u73b0\u5f02\u5e38\uff0c\u5f53\u524d\u8def\u7531\u4fe1\u606f=======>" + routeInfo);
            this.collect(new GenericRowData(this.rowType.getFieldCount()));
            return;
        }
        finally {
            DruidAssit.close(connection);
        }
    }

    private void setPreparedsql(List<LogicalType> logicalTypeswithoutroutecol, PreparedStatement ps, Object[] keys) throws SQLException {
        block4: for (int i = 0; i < logicalTypeswithoutroutecol.size(); ++i) {
            switch (logicalTypeswithoutroutecol.get(i).getTypeRoot()) {
                case TINYINT: 
                case SMALLINT: 
                case INTEGER: 
                case BIGINT: {
                    ps.setLong(i + 1, Long.valueOf(String.valueOf(keys[this.relationmap.get(i)])));
                    continue block4;
                }
                case VARCHAR: {
                    ps.setString(i + 1, String.valueOf(keys[this.relationmap.get(i)]));
                    continue block4;
                }
                default: {
                    throw new RuntimeException("\u5f53\u524d\u5173\u8054\u7ef4\u8868\u7684\u7d22\u5f15\u7c7b\u578b\u4ec5\u652f\u6301\u6574\u5f62\u6216\u5b57\u7b26\u4e32\uff0c\u5176\u4ed6\u6682\u4e0d\u652f\u6301\uff01");
                }
            }
        }
    }

    public RowData toInternal(ResultSet resultSet) throws SQLException {
        GenericRowData genericRowData = new GenericRowData(this.rowType.getFieldCount());
        for (int pos = 0; pos < this.rowType.getFieldCount(); ++pos) {
            Object field = resultSet.getObject(pos + 1);
            genericRowData.setField(pos, this.toInternalConverters[pos].deserialize(field));
        }
        return genericRowData;
    }

    public void close() throws IOException {
        this.absPool.destroy();
        DruidAssit.shutdown();
    }
}

