/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.flink.connector.jdbc.converter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import net.wicp.tams.common.flink.connector.jdbc.converter.JdbcRowConverter;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;

public abstract class AbstractJdbcRowConverter
implements JdbcRowConverter {
    protected final RowType rowType;
    protected final JdbcDeserializationConverter[] toInternalConverters;
    protected final LogicalType[] fieldTypes;

    public abstract String converterName();

    public AbstractJdbcRowConverter(RowType rowType) {
        this.rowType = (RowType)Preconditions.checkNotNull((Object)rowType);
        this.fieldTypes = (LogicalType[])rowType.getFields().stream().map(RowType.RowField::getType).toArray(LogicalType[]::new);
        this.toInternalConverters = new JdbcDeserializationConverter[rowType.getFieldCount()];
        for (int i = 0; i < rowType.getFieldCount(); ++i) {
            this.toInternalConverters[i] = AbstractJdbcRowConverter.createNullableInternalConverter(rowType.getTypeAt(i));
        }
    }

    public static JdbcDeserializationConverter createNullableInternalConverter(LogicalType type) {
        return AbstractJdbcRowConverter.wrapIntoNullableInternalConverter(AbstractJdbcRowConverter.createInternalConverter(type));
    }

    public static JdbcDeserializationConverter wrapIntoNullableInternalConverter(JdbcDeserializationConverter jdbcDeserializationConverter) {
        return val -> {
            if (val == null) {
                return null;
            }
            return jdbcDeserializationConverter.deserialize(val);
        };
    }

    public static JdbcDeserializationConverter createInternalConverter(LogicalType type) {
        switch (type.getTypeRoot()) {
            case NULL: {
                return val -> null;
            }
            case BOOLEAN: 
            case FLOAT: 
            case DOUBLE: 
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_DAY_TIME: {
                return val -> val;
            }
            case TINYINT: {
                return val -> ((Integer)val).byteValue();
            }
            case SMALLINT: {
                return val -> val instanceof Integer ? Short.valueOf(((Integer)val).shortValue()) : val;
            }
            case INTEGER: {
                return val -> val;
            }
            case BIGINT: {
                return val -> val;
            }
            case DECIMAL: {
                int precision = ((DecimalType)type).getPrecision();
                int scale = ((DecimalType)type).getScale();
                return val -> val instanceof BigInteger ? DecimalData.fromBigDecimal((BigDecimal)new BigDecimal((BigInteger)val, 0), (int)precision, (int)scale) : DecimalData.fromBigDecimal((BigDecimal)((BigDecimal)val), (int)precision, (int)scale);
            }
            case DATE: {
                return val -> (int)((Date)val).toLocalDate().toEpochDay();
            }
            case TIME_WITHOUT_TIME_ZONE: {
                return val -> (int)(((Time)val).toLocalTime().toNanoOfDay() / 1000000L);
            }
            case TIMESTAMP_WITH_TIME_ZONE: 
            case TIMESTAMP_WITHOUT_TIME_ZONE: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return val -> val instanceof LocalDateTime ? TimestampData.fromLocalDateTime((LocalDateTime)((LocalDateTime)val)) : TimestampData.fromTimestamp((Timestamp)((Timestamp)val));
            }
            case CHAR: 
            case VARCHAR: {
                return val -> StringData.fromString((String)((String)val));
            }
            case BINARY: 
            case VARBINARY: {
                return val -> val;
            }
        }
        throw new UnsupportedOperationException("Unsupported type:" + type);
    }

    @FunctionalInterface
    public static interface JdbcDeserializationConverter
    extends Serializable {
        public Object deserialize(Object var1) throws SQLException;
    }
}

