/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.flink.connector.jdbc;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.wicp.tams.common.flink.connector.jdbc.JdbcSourceOptions;
import net.wicp.tams.common.flink.connector.jdbc.source.JdbcDynamicTableSource;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.catalog.UniqueConstraint;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.DynamicTableSourceFactory;
import org.apache.flink.table.factories.FactoryUtil;

public class JdbcDynamicTableFactory
implements DynamicTableSourceFactory {
    public static final String IDENTIFIER = "tams-jdbc";

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        HashSet options = new HashSet();
        options.add(JdbcSourceOptions.tablename);
        options.add(JdbcSourceOptions.routecolumn);
        options.add(JdbcSourceOptions.redisurl);
        options.add(JdbcSourceOptions.redisdb);
        options.add(JdbcSourceOptions.searchkeyprefix);
        return options;
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet options = new HashSet();
        options.add(JdbcSourceOptions.redisport);
        options.add(JdbcSourceOptions.redispassword);
        options.add(JdbcSourceOptions.cacheMaxSize);
        options.add(JdbcSourceOptions.cacheExpireMs);
        return options;
    }

    public DynamicTableSource createDynamicTableSource(DynamicTableFactory.Context context) {
        List tableprimarykeys = ((UniqueConstraint)context.getCatalogTable().getResolvedSchema().getPrimaryKey().get()).getColumns();
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
        ReadableConfig config = helper.getOptions();
        return new JdbcDynamicTableSource(config, context.getPhysicalRowDataType(), tableprimarykeys);
    }
}

