package net.wicp.tams.common.flink.connector.jdbc.source;

import net.wicp.tams.common.flink.connector.jdbc.JdbcDynamicTableFactory;
import net.wicp.tams.common.flink.connector.jdbc.JdbcSourceOptions;
import net.wicp.tams.common.flink.connector.jdbc.function.JdbcRowDataLookupFunction;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.LookupTableSource;
import org.apache.flink.table.connector.source.ScanTableSource;
import org.apache.flink.table.connector.source.TableFunctionProvider;
import org.apache.flink.table.types.DataType;
import org.apache.flink.util.Preconditions;

import java.util.Arrays;
import java.util.List;

public class JdbcDynamicTableSource implements LookupTableSource, ScanTableSource {

	ReadableConfig config;
	DataType dataType;
	List<String> tableprimarykeys;

	public JdbcDynamicTableSource(ReadableConfig config, DataType physicalRowDataType, List<String> tableprimarykeys){
		this.config = config;
		this.dataType = physicalRowDataType;
		this.tableprimarykeys = tableprimarykeys;
	}

	@Override
	public DynamicTableSource copy() {
		return new JdbcDynamicTableSource(config, dataType, tableprimarykeys);
	}

	@Override
	public String asSummaryString() {
		return JdbcDynamicTableFactory.IDENTIFIER + ":";
	}

	@Override
	public ChangelogMode getChangelogMode() {
		return ChangelogMode.insertOnly();
	}

	@Override
	public ScanRuntimeProvider getScanRuntimeProvider(ScanContext runtimeProviderContext) {
		// TODO Auto-generated method stub
		return null;
	}

	/***
	 * 用于支持专用的
	 */
	@Override
	public LookupRuntimeProvider getLookupRuntimeProvider(LookupContext context) {
		String[] keyNames = new String[context.getKeys().length];
		//System.out.println("keyNames==>"+keyNames);
		for (int i = 0; i < keyNames.length; i++) {
			int[] innerKeyArr = context.getKeys()[i];
			Preconditions.checkArgument(
					innerKeyArr.length == 1, "JDBC only support non-nested look up keys");
			keyNames[i] = DataType.getFieldNames(dataType).get(innerKeyArr[0]);
		}
		List<String> joinkeylist = Arrays.asList(keyNames);
		if(!tableprimarykeys.containsAll(joinkeylist)){
			System.out.println("joinkeylist=============================================");
			joinkeylist.forEach(e-> System.out.println(e));
			System.out.println("tableprimarykeys=============================================");
			tableprimarykeys.forEach(e-> System.out.println(e));
			throw new RuntimeException("关联键必须包含表的所有主键");
		}

		return TableFunctionProvider.of(
				new JdbcRowDataLookupFunction(
						config,
						dataType,
						keyNames,
						tableprimarykeys
						));
	}

}
