package net.wicp.tams.common.flink.connector.jdbc.function;

import net.wicp.tams.common.Conf;
import net.wicp.tams.common.flink.connector.jdbc.JdbcSourceOptions;
import net.wicp.tams.common.flink.connector.jdbc.bean.RouteInfo;
import net.wicp.tams.common.flink.connector.jdbc.converter.AbstractJdbcRowConverter;
import net.wicp.tams.common.jdbc.DruidAssit;
import net.wicp.tams.common.redis.RedisAssit;
import net.wicp.tams.common.redis.pool.AbsPool;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.shaded.guava30.com.google.common.cache.Cache;
import org.apache.flink.shaded.guava30.com.google.common.cache.CacheBuilder;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.functions.FunctionContext;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.*;
import redis.clients.jedis.Jedis;

import javax.sql.DataSource;
import java.io.IOException;
import java.sql.*;
import java.util.*;
import java.util.concurrent.TimeUnit;

public class JdbcRowDataLookupFunction extends TableFunction<RowData> {
    ReadableConfig config;
    DataType dataType;
    String[] keyNames;
    AbsPool absPool;
    RowType rowType;
    //路由字段在key中的位置
    int routecolumnposition;
    //源表主键在key中的位置
    private final AbstractJdbcRowConverter.JdbcDeserializationConverter[] toInternalConverters;
    String redisprefix;
    List<String> tableprimarykeys;
    List<LogicalType> logicalTypeswithoutroutecol = new ArrayList<>();
    final String preparedsqlprefix = "select * from %s.%s where ";
    final String preparedsqlitem = " =? ";
    final String preparedsqljoiner = "and";
    final String space = " ";
    final Map<Integer,Integer> relationmap = new HashMap<>();
    private transient Cache<RowData, List<RowData>> cache;


    public JdbcRowDataLookupFunction(ReadableConfig config, DataType dataType, String[] keyNames, List<String> tableprimarykeys) {
        this.config = config;
        this.dataType = dataType;
        this.rowType = (RowType) dataType.getLogicalType();
        this.keyNames = keyNames;
        this.redisprefix = config.get(JdbcSourceOptions.searchkeyprefix);
        this.tableprimarykeys = tableprimarykeys;
        this.toInternalConverters = new AbstractJdbcRowConverter.JdbcDeserializationConverter[rowType.getFieldCount()];
        for (int i = 0; i < rowType.getFieldCount(); i++) {
            toInternalConverters[i] = AbstractJdbcRowConverter.createNullableInternalConverter(rowType.getTypeAt(i));
        }
    }


    @Override
    public void open(FunctionContext context) throws Exception {

        for(int i=0;i<keyNames.length;i++){
            if(keyNames[i].equals(config.get(JdbcSourceOptions.routecolumn))){
                routecolumnposition =i ;
                break;
            }
        }

        Properties properties = new Properties();
        properties.setProperty("common.redis.redisserver.default.host",config.get(JdbcSourceOptions.redisurl));
        properties.setProperty("common.redis.redisserver.default.port",config.get(JdbcSourceOptions.redisport));
        properties.setProperty("common.redis.redisserver.default.defaultDb",config.get(JdbcSourceOptions.redisdb));
        properties.setProperty("common.redis.redisserver.default.password",config.get(JdbcSourceOptions.redispassword));
        Conf.overProp(properties);
        absPool = RedisAssit.getPool("tamsjdbc-redisdatasource");
        //Jedis jedis = absPool.getResource();
        this.cache =
                config.get(JdbcSourceOptions.cacheMaxSize) == -1 || config.get(JdbcSourceOptions.cacheExpireMs) == -1
                        ? null
                        : CacheBuilder.newBuilder()
                        .expireAfterWrite(config.get(JdbcSourceOptions.cacheExpireMs), TimeUnit.MILLISECONDS)
                        .maximumSize(config.get(JdbcSourceOptions.cacheMaxSize))
                        .build();

        int logicalTypeswithoutroutecolindex =0;
        for(int j = 0;j<keyNames.length;j++){
            if(j == routecolumnposition){
                continue;
            }
            this.logicalTypeswithoutroutecol.add(rowType.getTypeAt(rowType.getFieldIndex(keyNames[j])));
            this.relationmap.put(logicalTypeswithoutroutecolindex,j);
            logicalTypeswithoutroutecolindex++;
        }

    }


    public void eval(Object... keys) throws SQLException {
        RowData keyRow = GenericRowData.of(keys);
        //如果缓存未失效，使用缓存
        if(cache!=null){
            //System.out.println("说明缓存配置有效");
            List<RowData> cachedRows = cache.getIfPresent(keyRow);
            if (cachedRows != null) {
                //System.out.println("说明缓存命中");
                for (RowData cachedRow : cachedRows) {
                    collect(cachedRow);
                }
                return;
            }
        }
        //System.out.println("说明缓存没有命中");
        Jedis jedis=null;
        RouteInfo routeInfo=null;
        try{
            jedis = absPool.getResource();
            routeInfo =AbsPool.getObjByMapValue(RouteInfo.class,jedis,redisprefix.concat(":").concat(String.valueOf(keys[routecolumnposition])));
        }finally {
            absPool.returnResource(jedis);
        }
        Connection connection = null;
        try {
        if(routeInfo==null
                || StringUtils.isEmpty(routeInfo.getSlave_username())
                || StringUtils.isEmpty(routeInfo.getSlave_password())
                || StringUtils.isEmpty(routeInfo.getSlave_url())
                || StringUtils.isEmpty(routeInfo.getSlave_port())
                || "null".equals(routeInfo.getSlave_username())
                || "null".equals(routeInfo.getSlave_password())
                || "null".equals(routeInfo.getSlave_url())
                || "null".equals(routeInfo.getSlave_port())
        ){
            collect(new GenericRowData(rowType.getFieldCount()));
            return;
        }
        DataSource dataSource =null;
        if(!DruidAssit.getDataSourceMap().containsKey(routeInfo.getSlave_url())) {
        	Properties properties = new Properties();
            properties.setProperty("username",routeInfo.getSlave_username());
            properties.setProperty("password",routeInfo.getSlave_password());
            properties.setProperty("host",routeInfo.getSlave_url());
            if(!"3306".equals(routeInfo.getSlave_port())){
                properties.setProperty("port",routeInfo.getSlave_port());
            }
            Conf.overProp(properties);
            dataSource =DruidAssit.getDataSourceNoConf(routeInfo.getSlave_url(),properties);
        }else {
        	dataSource =DruidAssit.getDataSource(routeInfo.getSlave_url());
        }
        	connection = dataSource.getConnection();
            String sqlprefix = String.format(preparedsqlprefix,routeInfo.getDb(),config.get(JdbcSourceOptions.tablename));
            StringBuilder sqlformat = new StringBuilder();
            sqlformat.append(sqlprefix);

            for(int j = 0;j<keyNames.length;j++){
                if(j == routecolumnposition){
                    continue;
                }
                if(j != keyNames.length-1){
                    sqlformat.append(space);
                    sqlformat.append(keyNames[j]);
                    sqlformat.append(preparedsqlitem);
                    sqlformat.append(preparedsqljoiner);
                }else{
                    sqlformat.append(space);
                    sqlformat.append(keyNames[j]);
                    sqlformat.append(preparedsqlitem);
                }
            }
            String preparedsql = sqlformat.toString();
            if(preparedsql.lastIndexOf(preparedsqljoiner)+preparedsqljoiner.length()==preparedsql.length()){
                preparedsql = preparedsql.substring(0,preparedsql.lastIndexOf("and"));
            }
            System.out.println("preparedsql==>"+ preparedsql);
            PreparedStatement ps = connection.prepareStatement(preparedsql);
            setPreparedsql(logicalTypeswithoutroutecol,ps,keys);
            List<RowData> rows = new ArrayList<>();
            ResultSet rs = ps.executeQuery();
             while(rs.next()){
                 RowData rowData = toInternal(rs);
                 rows.add(rowData);
                 collect(rowData);
             }
            if (!rows.isEmpty() && cache != null) {
                cache.put(keyRow, rows);
            }
             rs.close();
             ps.close();
		}catch(Exception e){
            System.out.println("出现异常，当前路由信息=======>"+routeInfo);
            //throw new RuntimeException(e);
            collect(new GenericRowData(rowType.getFieldCount()));
            return;
        }finally {
			DruidAssit.close(connection);
		}        
    }

    private void setPreparedsql(List<LogicalType> logicalTypeswithoutroutecol, PreparedStatement ps, Object[] keys) throws SQLException {
        for(int i=0;i<logicalTypeswithoutroutecol.size();i++){
            switch (logicalTypeswithoutroutecol.get(i).getTypeRoot()){
                case TINYINT:
                case SMALLINT:
                case INTEGER:
                case BIGINT: ps.setLong(i+1,Long.valueOf(String.valueOf(keys[relationmap.get(i)]))); break;
                case VARCHAR:ps.setString(i+1,String.valueOf(keys[relationmap.get(i)])); break;
                default: throw new RuntimeException("当前关联维表的索引类型仅支持整形或字符串，其他暂不支持！");
            }
        }
    }

    public RowData toInternal(ResultSet resultSet) throws SQLException {
        GenericRowData genericRowData = new GenericRowData(rowType.getFieldCount());
        for (int pos = 0; pos < rowType.getFieldCount(); pos++) {
            Object field = resultSet.getObject(pos + 1);
            genericRowData.setField(pos, toInternalConverters[pos].deserialize(field));
        }
        return genericRowData;
    }

    @Override
    public void close() throws IOException {
        absPool.destroy();
        DruidAssit.shutdown();
    }

}