/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common
 * 项目描述：公共的工具集
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.flink.connector.jdbc;

import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;

/***
 *
 * @author Andy
 *
 */
public abstract class JdbcSourceOptions {
	//redis连接串，用于访问路由信息
	public static final ConfigOption<String> redisurl = ConfigOptions.key("host").stringType().noDefaultValue()
			.withDescription("redis连接串");

	public static final ConfigOption<String> redisdb = ConfigOptions.key("db").stringType().noDefaultValue()
			.withDescription("redis数据库");

	public static final ConfigOption<String> redisport = ConfigOptions.key("port").stringType().defaultValue("6379")
			.withDescription("redis端口");

	public static final ConfigOption<String> redispassword = ConfigOptions.key("password").stringType().noDefaultValue()
			.withDescription("redis密码");



	public static final ConfigOption<String> tablename = ConfigOptions.key("table-name").stringType().noDefaultValue()
			.withDescription("表名");

	//当前只支持一个路由字段
	public static final ConfigOption<String> routecolumn = ConfigOptions.key("tenantColName").stringType().noDefaultValue()
			.withDescription("路由字段");



	public static final ConfigOption<Long> cacheExpireMs = ConfigOptions.key("lookup.cache.ttl").longType().defaultValue(-1L)
			.withDescription("缓存超期失效时间，单位毫秒，-1表示不开启缓存");

	public static final ConfigOption<Long> cacheMaxSize = ConfigOptions.key("lookup.cache.max-rows").longType().defaultValue(-1L)
			.withDescription("最大缓存数，-1表示不开启缓存");

	public static final ConfigOption<String> searchkeyprefix = ConfigOptions.key("searchkeyprefix").stringType().noDefaultValue()
			.withDescription("redis键前缀");


}
