package net.wicp.tams.common.flink.connector.jdbc;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.factories.DynamicTableSourceFactory;
import static net.wicp.tams.common.flink.connector.jdbc.JdbcSourceOptions.*;

import net.wicp.tams.common.flink.connector.jdbc.source.JdbcDynamicTableSource;
import org.apache.flink.table.factories.FactoryUtil;

public class JdbcDynamicTableFactory implements DynamicTableSourceFactory {
	public static final String IDENTIFIER = "tams-jdbc";
	@Override
	public String factoryIdentifier() {
		return IDENTIFIER;
	}

	@Override
	public Set<ConfigOption<?>> requiredOptions() {
		final Set<ConfigOption<?>> options = new HashSet<>();
		options.add(tablename);
		options.add(routecolumn);
		options.add(redisurl);
		options.add(redisdb);
		options.add(searchkeyprefix);
		return options;
	}

	@Override
	public Set<ConfigOption<?>> optionalOptions() {
		final Set<ConfigOption<?>> options = new HashSet<>();
		options.add(redisport);
		options.add(redispassword);
		options.add(cacheMaxSize);
		options.add(cacheExpireMs);
		return options;
	}

	@Override
	public DynamicTableSource createDynamicTableSource(Context context) {
		List<String> tableprimarykeys = context.getCatalogTable().getResolvedSchema().getPrimaryKey().get().getColumns();
		final FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper(this, context);
		ReadableConfig config = helper.getOptions();
		return new JdbcDynamicTableSource(config,context.getPhysicalRowDataType(),tableprimarykeys);
	}

}
