/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.flink.connector.binlog;

import java.util.Properties;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.constant.DrdsPattern;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.ReadableConfig;

public abstract class DuckulaOptions {
    public static final ConfigOption<String> host = ConfigOptions.key((String)"host").stringType().noDefaultValue().withDescription("\u4e3b\u673a");
    public static final ConfigOption<String> username = ConfigOptions.key((String)"username").stringType().noDefaultValue().withDescription("\u7528\u6237\u540d");
    public static final ConfigOption<String> password = ConfigOptions.key((String)"password").stringType().noDefaultValue().withDescription("\u5bc6\u7801");
    public static final ConfigOption<String> db = ConfigOptions.key((String)"db").stringType().noDefaultValue().withDescription("\u76d1\u542c\u5e93\u540d");
    public static final ConfigOption<String> tb = ConfigOptions.key((String)"tb").stringType().noDefaultValue().withDescription("\u76d1\u542c\u8868\u540d");
    public static final ConfigOption<Integer> port = ConfigOptions.key((String)"port").intType().defaultValue((Object)3306).withDescription("\u7aef\u53e3");
    public static final ConfigOption<Integer> groupId = ConfigOptions.key((String)"groupId").intType().noDefaultValue().withDescription("\u7528\u4e8e\u76d1\u542c\u4efb\u52a1\u7684\u5206\u6b65\u5f0f\u9501");
    public static final ConfigOption<Integer> clientId = ConfigOptions.key((String)"clientId").intType().noDefaultValue().withDescription("\u8fde\u63a5mysql\u7684clientId");
    public static final ConfigOption<Boolean> rds = ConfigOptions.key((String)"rds").booleanType().defaultValue((Object)false).withDescription("\u662f\u5426rds");
    public static final ConfigOption<String> haType = ConfigOptions.key((String)"haType").stringType().defaultValue((Object)"last").withDescription("\u7528\u4e8e\u76d1\u542c\u4efb\u52a1\u7684\u5206\u6b65\u5f0f\u9501");
    public static final ConfigOption<Boolean> cdc = ConfigOptions.key((String)"cdc").booleanType().defaultValue((Object)true).withDescription("\u662f\u5426\u542f\u7528cdc");
    public static final ConfigOption<String> format = ConfigOptions.key((String)"format").stringType().defaultValue((Object)"duckula").withDescription("format\u683c\u5f0f");
    public static final ConfigOption<String> updateColName = ConfigOptions.key((String)"updateColName").stringType().defaultValue((Object)"update_time").withDescription("\u7528\u4e8e\u5206\u9694\u5168\u91cf\u548c\u589e\u91cf\u7684\u65f6\u95f4\u5b57\u6bb5");
    public static final ConfigOption<Boolean> append = ConfigOptions.key((String)"append").booleanType().defaultValue((Object)false).withDescription("\u662f\u5426\u4e3aappend\u6a21\u5f0f");
    public static final ConfigOption<String> fieldFormart = ConfigOptions.key((String)"fieldFormart").stringType().defaultValue((Object)"ori").withDescription("\u6240\u6709\u5b57\u6bb5\u7684\u683c\u5f0f");
    public static final ConfigOption<String> addColNameType = ConfigOptions.key((String)"addColNameType").stringType().defaultValue((Object)"no").withDescription("\u65b0\u589e\u5b57\u6bb5\u7684\u6a21\u5f0f");
    public static final ConfigOption<String> name = ConfigOptions.key((String)"name").stringType().noDefaultValue().withDescription("\u7528\u4e8e\u60df\u4e00\u6807\u8bc6\u76d1\u542c\u4efb\u52a1id");

    public static void packageParams(ReadableConfig options) {
        DuckulaOptions.packageOptions(options);
        if (((Boolean)options.get(cdc)).booleanValue()) {
            DuckulaOptions.packageDumpOpts(options);
        }
    }

    private static void packageOptions(ReadableConfig options) {
        Properties props = new Properties();
        String rule = String.format("%s`%s`%s`{}`", options.get(db), options.get(tb), DrdsPattern.no.name());
        String configname = (String)options.get(name);
        props.put(String.format("common.binlog.alone.binlog.conf.%s.rule", configname), rule);
        props.put(String.format("common.binlog.alone.binlog.conf.%s.clientId", configname), options.get(clientId));
        props.put(String.format("common.binlog.alone.binlog.conf.%s.groupId", configname), options.get(clientId));
        props.put(String.format("common.binlog.alone.binlog.conf.%s.haType", configname), options.get(haType));
        props.put(String.format("common.binlog.alone.binlog.conf.%s.host", configname), options.get(host));
        props.put(String.format("common.binlog.alone.binlog.conf.%s.password", configname), options.get(password));
        props.put(String.format("common.binlog.alone.binlog.conf.%s.port", configname), options.get(port));
        props.put(String.format("common.binlog.alone.binlog.conf.%s.rds", configname), options.get(rds));
        props.put(String.format("common.binlog.alone.binlog.conf.%s.username", configname), options.get(username));
        props.put(String.format("common.jdbc.datasource.%s.host", configname), options.get(host));
        props.put(String.format("common.jdbc.datasource.%s.port", configname), options.get(port));
        props.put(String.format("common.jdbc.datasource.%s.username", configname), options.get(username));
        props.put(String.format("common.jdbc.datasource.%s.password", configname), options.get(password));
        DuckulaOptions.packageOptionsCommon(props, options, fieldFormart, addColNameType);
        Conf.overProp((Properties)props);
    }

    private static void packageDumpOpts(ReadableConfig options) {
        Properties props = new Properties();
        props.put("common.binlog.alone.dump.global.enable", "true");
        props.put("common.binlog.alone.dump.global.overExit", "false");
        String rule = String.format("%s`%s`%s`{}`", options.get(db), options.get(tb), DrdsPattern.no.name());
        String configname = (String)options.get(name);
        props.put(String.format("common.binlog.alone.dump.%s.ori.%s.rule", configname, "default"), rule);
        props.put(String.format("common.binlog.alone.dump.%s.ori.busiSender", configname), "net.wicp.tams.common.flink.connector.binlog.cdc.FlinkDumpListener");
        props.put(String.format("common.binlog.alone.plugin.jdbc.%s.host", configname), options.get(host));
        props.put(String.format("common.binlog.alone.plugin.jdbc.%s.password", configname), options.get(password));
        props.put(String.format("common.binlog.alone.plugin.jdbc.%s.port", configname), options.get(port));
        props.put(String.format("common.binlog.alone.plugin.jdbc.%s.username", configname), options.get(username));
        DuckulaOptions.packageOptionsCommon(props, options, fieldFormart, addColNameType);
        Conf.overProp((Properties)props);
    }

    private static void packageOptionsCommon(Properties props, ReadableConfig options, ConfigOption ... duckulaOptions) {
        for (ConfigOption duckulaOption : duckulaOptions) {
            props.put("common.binlog.alone.global." + duckulaOption.key(), options.get(duckulaOption));
        }
    }
}

