/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common
 * 项目描述：公共的工具集
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.flink.connector.binlog.connector;

import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.format.DecodingFormat;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.ScanTableSource;
import org.apache.flink.table.connector.source.SourceFunctionProvider;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.DataType;

import net.wicp.tams.common.flink.common.schema.DuckulaDeserializationSchema;

public class BinlogTableSource implements ScanTableSource {

	public static final String IDENTIFIER = "duckula-source";

	private final DecodingFormat<DeserializationSchema<RowData>> decodingFormat;
	private final DataType producedDataType;
	private final boolean cdc;
	private final Configuration optionsWith;

	public BinlogTableSource(DecodingFormat<DeserializationSchema<RowData>> decodingFormat, DataType producedDataType,
			boolean cdc,Configuration optionsWith) {
		this.decodingFormat = decodingFormat;
		this.producedDataType = producedDataType;
		this.cdc = cdc;
		this.optionsWith=optionsWith;
	}

	@Override
	public ChangelogMode getChangelogMode() {
		// in our example the format decides about the changelog mode
		// but it could also be the source itself
		return decodingFormat.getChangelogMode();
	}

	@Override
	public ScanRuntimeProvider getScanRuntimeProvider(ScanContext runtimeProviderContext) {
		// create runtime classes that are shipped to the cluster
		final DuckulaDeserializationSchema deserializer = (DuckulaDeserializationSchema) decodingFormat
				.createRuntimeDecoder(runtimeProviderContext, producedDataType);
		final SourceFunction<RowData> sourceFunction = new BinlogSourceFunction(deserializer,cdc,optionsWith);
		return SourceFunctionProvider.of(sourceFunction, false);
	}

	@Override
	public DynamicTableSource copy() {
		return new BinlogTableSource(decodingFormat, producedDataType,cdc,optionsWith);
	}

	@Override
	public String asSummaryString() {
		return IDENTIFIER;
	}
}
