/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common
 * 项目描述：公共的工具集
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.flink.connector.binlog;

import java.util.Properties;

import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.ReadableConfig;

import net.wicp.tams.common.Conf;
import net.wicp.tams.common.constant.DrdsPattern;

public abstract class DuckulaOptions {
	public static final ConfigOption<String> host = ConfigOptions.key("host").stringType().noDefaultValue()
			.withDescription("主机");
	public static final ConfigOption<String> username = ConfigOptions.key("username").stringType().noDefaultValue()
			.withDescription("用户名");
	public static final ConfigOption<String> password = ConfigOptions.key("password").stringType().noDefaultValue()
			.withDescription("密码");
	public static final ConfigOption<String> db = ConfigOptions.key("db").stringType().noDefaultValue()
			.withDescription("监听库名");
	public static final ConfigOption<String> tb = ConfigOptions.key("tb").stringType().noDefaultValue()
			.withDescription("监听表名");

	/////////////////////////////////////////////////// 下面参数可选//////////////////////////////////////////////////////////////////////////
	public static final ConfigOption<Integer> port = ConfigOptions.key("port").intType().defaultValue(3306)
			.withDescription("端口");
	// 暂不启用
	public static final ConfigOption<Integer> groupId = ConfigOptions.key("groupId").intType().noDefaultValue()
			.withDescription("用于监听任务的分步式锁");
	// 默认40322
	public static final ConfigOption<Integer> clientId = ConfigOptions.key("clientId").intType().noDefaultValue()
			.withDescription("连接mysql的clientId");

	public static final ConfigOption<Boolean> rds = ConfigOptions.key("rds").booleanType().defaultValue(false)
			.withDescription("是否rds");

	public static final ConfigOption<String> haType = ConfigOptions.key("haType").stringType().defaultValue("last")
			.withDescription("用于监听任务的分步式锁");

	// 默认启用CDC，如果是刚建的表可以不启用它
	public static final ConfigOption<Boolean> cdc = ConfigOptions.key("cdc").booleanType().defaultValue(true)
			.withDescription("是否启用cdc");

	// 只用用duckula的formate,后面不排除有其它的formate.
	public static final ConfigOption<String> format = ConfigOptions.key("format").stringType().defaultValue("duckula")
			.withDescription("format格式");
	
	//
	public static final ConfigOption<String> updateColName = ConfigOptions.key("updateColName").stringType().defaultValue("update_time")
			.withDescription("用于分隔全量和增量的时间字段");
	
	
	//是否为append模式
	public static final ConfigOption<Boolean> append = ConfigOptions.key("append").booleanType().defaultValue(false)
			.withDescription("是否为append模式");
	

	///////////////////////////////////////////////////// 后面增加的逻辑控制参数////////////////////////////////////////////////////////////////////////
	public static final ConfigOption<String> fieldFormart = ConfigOptions.key("fieldFormart").stringType()
			.defaultValue("ori").withDescription("所有字段的格式");// 默认是原始字段，不做处理

	public static final ConfigOption<String> addColNameType = ConfigOptions.key("addColNameType").stringType()
			.defaultValue("no").withDescription("新增字段的模式");// 默认不新增字段
	
	
	
	public static final ConfigOption<String> name = ConfigOptions.key("name").stringType().noDefaultValue()
			.withDescription("用于惟一标识监听任务id");
	
	
	
	public static void packageParams(ReadableConfig options) {
		packageOptions(options);
		if (options.get(DuckulaOptions.cdc)) {
			packageDumpOpts(options);
		}
	}
	
	
	
	private static void packageOptions(ReadableConfig options) {
		Properties props = new Properties();
		String rule = String.format("%s`%s`%s`{}`", options.get(DuckulaOptions.db), options.get(DuckulaOptions.tb),
				DrdsPattern.no.name());
		String configname = options.get(DuckulaOptions.name);
		props.put(String.format("common.binlog.alone.binlog.conf.%s.rule", configname), rule);		
		props.put(String.format("common.binlog.alone.binlog.conf.%s.clientId", configname), options.get(DuckulaOptions.clientId));
		props.put(String.format("common.binlog.alone.binlog.conf.%s.groupId", configname), options.get(DuckulaOptions.clientId));// group与client相同
		props.put(String.format("common.binlog.alone.binlog.conf.%s.haType", configname), options.get(DuckulaOptions.haType));
		props.put(String.format("common.binlog.alone.binlog.conf.%s.host", configname), options.get(DuckulaOptions.host));
		props.put(String.format("common.binlog.alone.binlog.conf.%s.password", configname), options.get(DuckulaOptions.password));
		props.put(String.format("common.binlog.alone.binlog.conf.%s.port", configname), options.get(DuckulaOptions.port));
		props.put(String.format("common.binlog.alone.binlog.conf.%s.rds", configname), options.get(DuckulaOptions.rds));
		props.put(String.format("common.binlog.alone.binlog.conf.%s.username", configname), options.get(DuckulaOptions.username));
		// 设置增量、全量公共的配置，框架是分离的。
		props.put(String.format("common.jdbc.datasource.%s.host", configname)  , options.get(DuckulaOptions.host));
		props.put(String.format("common.jdbc.datasource.%s.port", configname), options.get(DuckulaOptions.port));
		props.put(String.format("common.jdbc.datasource.%s.username", configname), options.get(DuckulaOptions.username));
		props.put(String.format("common.jdbc.datasource.%s.password", configname), options.get(DuckulaOptions.password));
		packageOptionsCommon(props, options, DuckulaOptions.fieldFormart, DuckulaOptions.addColNameType);
		Conf.overProp(props);
	}

	private static void packageDumpOpts(ReadableConfig options) {
		Properties props = new Properties();
		props.put("common.binlog.alone.dump.global.enable", "true");
		props.put("common.binlog.alone.dump.global.overExit", "false");// 做完不退出
//		props.put("common.binlog.alone.dump.global.run.buffersize", "8");//默认为8，设置为4调小内存
		String rule = String.format("%s`%s`%s`{}`", options.get(DuckulaOptions.db), options.get(DuckulaOptions.tb),
				DrdsPattern.no.name());		
		String configname = options.get(DuckulaOptions.name);
		props.put(String.format("common.binlog.alone.dump.%s.ori.%s.rule", configname,"default"), rule);
		props.put(String.format("common.binlog.alone.dump.%s.ori.busiSender", configname),
				"net.wicp.tams.common.flink.connector.binlog.cdc.FlinkDumpListener");		
		props.put(String.format("common.binlog.alone.plugin.jdbc.%s.host", configname), options.get(DuckulaOptions.host));
		props.put(String.format("common.binlog.alone.plugin.jdbc.%s.password", configname), options.get(DuckulaOptions.password));
		props.put(String.format("common.binlog.alone.plugin.jdbc.%s.port", configname), options.get(DuckulaOptions.port));
		props.put(String.format("common.binlog.alone.plugin.jdbc.%s.username", configname), options.get(DuckulaOptions.username));		
		packageOptionsCommon(props, options, DuckulaOptions.fieldFormart, DuckulaOptions.addColNameType);
		Conf.overProp(props);
	}
	
	@SuppressWarnings({ "rawtypes", "unchecked" })
	private static void packageOptionsCommon(Properties props, ReadableConfig options, ConfigOption... duckulaOptions) {
		for (ConfigOption duckulaOption : duckulaOptions) {
			props.put("common.binlog.alone.global." + duckulaOption.key(), options.get(duckulaOption));
		}
	}

}
