/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.flink.connector.binlog;

import java.util.HashSet;
import java.util.Set;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.flink.common.constant.EnvName;
import net.wicp.tams.common.flink.connector.binlog.DuckulaOptions;
import net.wicp.tams.common.flink.connector.binlog.connector.BinlogTableSource;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.connector.format.DecodingFormat;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.factories.DeserializationFormatFactory;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.DynamicTableSourceFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.types.DataType;

public class DuckulaTableSourceFactory
implements DynamicTableSourceFactory {
    public DynamicTableSource createDynamicTableSource(DynamicTableFactory.Context context) {
        ResolvedCatalogTable catalogTable = context.getCatalogTable();
        Configuration optionsWith = new Configuration();
        catalogTable.getOptions().forEach((arg_0, arg_1) -> ((Configuration)optionsWith).setString(arg_0, arg_1));
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
        ReadableConfig options = helper.getOptions();
        DecodingFormat discoverDecodingFormat = helper.discoverDecodingFormat(DeserializationFormatFactory.class, DuckulaOptions.format);
        helper.validate();
        String db = (String)options.get(DuckulaOptions.db);
        db = db.replaceAll("\\*", "");
        String tb = (String)options.get(DuckulaOptions.tb);
        tb = tb.replaceAll("\\*", "");
        String taskname = String.format("%s-%s-%s", StringUtil.hasNull((String[])new String[]{EnvName.taskId.getValue(), "tams"}), db, tb);
        if (!optionsWith.contains(DuckulaOptions.name)) {
            optionsWith.set(DuckulaOptions.name, (Object)taskname);
            taskname = optionsWith.getString(DuckulaOptions.name);
        }
        if (!optionsWith.contains(DuckulaOptions.clientId)) {
            Integer clientId = StringUtil.buildPort((String)taskname);
            optionsWith.set(DuckulaOptions.clientId, (Object)clientId);
        }
        DuckulaOptions.packageParams((ReadableConfig)optionsWith);
        DataType producedDataType = context.getCatalogTable().getResolvedSchema().toPhysicalRowDataType();
        return new BinlogTableSource((DecodingFormat<DeserializationSchema<RowData>>)discoverDecodingFormat, producedDataType, (Boolean)options.get(DuckulaOptions.cdc), optionsWith);
    }

    public String factoryIdentifier() {
        return "duckula-source";
    }

    public Set<ConfigOption<?>> requiredOptions() {
        HashSet options = new HashSet();
        options.add(DuckulaOptions.host);
        options.add(DuckulaOptions.username);
        options.add(DuckulaOptions.password);
        options.add(DuckulaOptions.db);
        options.add(DuckulaOptions.tb);
        return options;
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet options = new HashSet();
        options.add(DuckulaOptions.clientId);
        options.add(DuckulaOptions.groupId);
        options.add(DuckulaOptions.port);
        options.add(DuckulaOptions.rds);
        options.add(DuckulaOptions.haType);
        options.add(DuckulaOptions.cdc);
        options.add(DuckulaOptions.fieldFormart);
        options.add(DuckulaOptions.addColNameType);
        options.add(DuckulaOptions.updateColName);
        options.add(DuckulaOptions.name);
        options.add(DuckulaOptions.append);
        return options;
    }
}

