/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common
 * 项目描述：公共的工具集
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.flink.connector.binlog.cdc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.flink.streaming.api.functions.source.SourceFunction.SourceContext;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryStringData;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.RowType.RowField;
import org.apache.flink.types.RowKind;

import com.alibaba.fastjson.JSONObject;

import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.binlog.alone.dump.bean.Dump;
import net.wicp.tams.common.binlog.alone.dump.bean.DumpEvent;
import net.wicp.tams.common.binlog.alone.dump.listener.IBusiSender;
import net.wicp.tams.common.constant.FieldFormart;
import net.wicp.tams.common.constant.ods.AddColName;
import net.wicp.tams.common.flink.common.constant.FlinkTypeEnum;
import net.wicp.tams.common.flink.common.schema.DuckulaDeserializationSchema;
import net.wicp.tams.common.thread.threadlocal.PerthreadManager;

public class FlinkDumpListener implements IBusiSender<DumpEvent> {
	private SourceContext<RowData> ctx;
	private List<RowField> rowTypeFields;

	@SuppressWarnings("unchecked")
	@Override
	public void init(Dump dump) {
		ctx = (SourceContext<RowData>) PerthreadManager.getInstance().createValue("_source_ctx", SourceContext.class)
				.get();
		DuckulaDeserializationSchema duckulaDeserializationSchema = PerthreadManager.getInstance()
				.createValue("_source_deserialization", DuckulaDeserializationSchema.class).get();
		rowTypeFields = duckulaDeserializationSchema.getRowTypeFields();

	}


	@Override
	public void doSend(DumpEvent dumpEvent, Map<AddColName, Serializable> addValues, String newDb, String newTb,boolean isSplit) {
		if (CollectionUtils.isEmpty(dumpEvent.getDatas())) {
			return;
		}
		for (Map<String, String> data : dumpEvent.getDatas()) {
			GenericRowData rowData = new GenericRowData(rowTypeFields.size());
			rowData.setRowKind(RowKind.INSERT);
			JSONObject others = new JSONObject();
			List<String> existField = new ArrayList<>();
			int duckula_other_index = -1;// 是否存在“duckula_other”这个字段
			for (int j = 0; j < rowTypeFields.size(); j++) {
				final RowType.RowField rowField = rowTypeFields.get(j);
				if (DuckulaDeserializationSchema.otherColName.equals(rowField.getName())) {
					duckula_other_index = j;
				} else {
					if (ArrayUtils.contains(dumpEvent.getDump().getNeedCols(), rowField.getName())) {
						existField.add(rowField.getName());
						FlinkTypeEnum flinkTypeEnum = FlinkTypeEnum
								.findByFlinkRowType(rowField.getType().getTypeRoot().toString());
						Object retojb = null;
						String datastr = data.get(rowField.getName());
						if (StringUtil.isNotNull(datastr)) {
							if (flinkTypeEnum == null
									|| "java.lang.String".equals(flinkTypeEnum.getJavaType().getTypeName())) {

								retojb = new BinaryStringData(data.get(rowField.getName()));
							} else {
								retojb = FlinkTypeEnum.getValue(flinkTypeEnum,data.get(rowField.getName()),rowField.getType());
							}
							rowData.setField(j, retojb);
						} else {// 空值处理
							rowData.setField(j, null);
						}
					} else {
						rowData.setField(j, null);
					}
				}
			}

			if (MapUtils.isNotEmpty(addValues)) {// 附加字段的类型
				List<String> rowFields = this.rowTypeFields.stream().map(rowField -> rowField.getName())
						.collect(Collectors.toList());
				FieldFormart fieldFormart = Conf.getEnum(FieldFormart.class, "common.binlog.alone.global.fieldFormart");
				for (AddColName addColName : addValues.keySet()) {
					GenericRowData row = (GenericRowData) rowData;
					int indexOfRowType = rowFields.indexOf(addColName.getColNameTrue(fieldFormart));
					if (indexOfRowType < 0) {
						continue;
					}
					final RowType.RowField rowField = this.rowTypeFields.get(indexOfRowType);
					FlinkTypeEnum flinkTypeEnum = FlinkTypeEnum
							.findByFlinkRowType(rowField.getType().getTypeRoot().toString());
					Object retojb = null;
					String valueStr = String.valueOf(addValues.get(addColName));
					if (flinkTypeEnum == null
							|| "java.lang.String".equals(flinkTypeEnum.getJavaType().getTypeName())) {
						retojb = new BinaryStringData(valueStr);
					} else {
						retojb = FlinkTypeEnum.getValue(flinkTypeEnum,valueStr,rowField.getType());
					}
					row.setField(indexOfRowType, retojb);
				}
			}
			if (duckula_other_index >= 0) {
				for (String colName : dumpEvent.getDump().getNeedCols()) {
					if (!existField.contains(colName)) {
						others.put(colName, data.get(colName));
					}
				}
				rowData.setField(duckula_other_index, new BinaryStringData(others.toJSONString()));
			}
			ctx.collect(rowData);
		}

	}

}
