/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.flink.connector.binlog.connector;

import net.wicp.tams.common.flink.common.schema.DuckulaDeserializationSchema;
import net.wicp.tams.common.flink.connector.binlog.connector.BinlogSourceFunction;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.format.DecodingFormat;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.ScanTableSource;
import org.apache.flink.table.connector.source.SourceFunctionProvider;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.DataType;

public class BinlogTableSource
implements ScanTableSource {
    public static final String IDENTIFIER = "duckula-source";
    private final DecodingFormat<DeserializationSchema<RowData>> decodingFormat;
    private final DataType producedDataType;
    private final boolean cdc;
    private final Configuration optionsWith;

    public BinlogTableSource(DecodingFormat<DeserializationSchema<RowData>> decodingFormat, DataType producedDataType, boolean cdc, Configuration optionsWith) {
        this.decodingFormat = decodingFormat;
        this.producedDataType = producedDataType;
        this.cdc = cdc;
        this.optionsWith = optionsWith;
    }

    public ChangelogMode getChangelogMode() {
        return this.decodingFormat.getChangelogMode();
    }

    public ScanTableSource.ScanRuntimeProvider getScanRuntimeProvider(ScanTableSource.ScanContext runtimeProviderContext) {
        DuckulaDeserializationSchema deserializer = (DuckulaDeserializationSchema)this.decodingFormat.createRuntimeDecoder((DynamicTableSource.Context)runtimeProviderContext, this.producedDataType);
        BinlogSourceFunction sourceFunction = new BinlogSourceFunction(deserializer, this.cdc, this.optionsWith);
        return SourceFunctionProvider.of((SourceFunction)sourceFunction, (boolean)false);
    }

    public DynamicTableSource copy() {
        return new BinlogTableSource(this.decodingFormat, this.producedDataType, this.cdc, this.optionsWith);
    }

    public String asSummaryString() {
        return IDENTIFIER;
    }
}

