/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common
 * 项目描述：公共的工具集
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.flink.connector.binlog.connector;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.flink.streaming.api.functions.source.SourceFunction.SourceContext;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryStringData;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.RowType.RowField;

import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.binlog.alone.ListenerConf.ColHis;
import net.wicp.tams.common.binlog.alone.ListenerConf.DuckulaEvent;
import net.wicp.tams.common.binlog.alone.binlog.bean.Rule;
import net.wicp.tams.common.binlog.alone.binlog.listener.AbsBinlogListener;
import net.wicp.tams.common.constant.FieldFormart;
import net.wicp.tams.common.constant.ods.AddColName;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;
import net.wicp.tams.common.flink.common.constant.FlinkTypeEnum;
import net.wicp.tams.common.flink.common.schema.DuckulaDeserializationSchema;

@Slf4j
public class FlinkBinlogTableListener extends AbsBinlogListener {

	private SourceContext<RowData> ctx;
	private DuckulaDeserializationSchema duckulaDeserializationSchema;

	public void setDuckulaDeserializationSchema(DuckulaDeserializationSchema duckulaDeserializationSchema) {
		this.duckulaDeserializationSchema = duckulaDeserializationSchema;
	}

	public void setCtx(SourceContext<RowData> ctx) {
		this.ctx = ctx;
	}

	@Override
	public Result doAlterTableCallBack(Rule rule, ColHis colHis, String sql, String[] addColNames, String updateColName,
			String[] deleteColNames, FieldFormart fieldFormart, String newDb, String newTb) {
		return null;
	}

	@Override
	public void doInit(Rule rule, int index) {
	}

	private void doBusiTrue(Rule rule, DuckulaEvent duckulaEvent, Map<AddColName, Serializable> addValues,
			boolean isSplit, boolean logicDel) {
		if (ctx == null) {// 用于测试用
			log.info("the listener is [{}]", duckulaEvent.getGtid());
		} else {
			try {
				RowData[] rowDatas = duckulaDeserializationSchema.deserializeTrue(duckulaEvent.toByteArray());
				if (ArrayUtils.isNotEmpty(rowDatas)) {
					for (RowData rowData : rowDatas) {
						if (MapUtils.isNotEmpty(addValues)) {// 附加字段的类型
							List<RowField> rowTypeFields = this.duckulaDeserializationSchema.getRowTypeFields();
							List<String> rowFields = rowTypeFields.stream().map(rowField -> rowField.getName())
									.collect(Collectors.toList());
							FieldFormart fieldFormart = Conf.getEnum(FieldFormart.class,
									"common.binlog.alone.global.fieldFormart");
							for (AddColName addColName : addValues.keySet()) {
								GenericRowData row = (GenericRowData) rowData;
								int indexOfRowType = rowFields.indexOf(addColName.getColNameTrue(fieldFormart));
								if (indexOfRowType < 0) {
									continue;
								}
								final RowType.RowField rowField = rowTypeFields.get(indexOfRowType);
								FlinkTypeEnum flinkTypeEnum = FlinkTypeEnum
										.findByFlinkRowType(rowField.getType().getTypeRoot().toString());
								Object retojb = null;
								String datastr = String.valueOf(addValues.get(addColName));
								if (StringUtil.isNotNull(datastr)) {
									if (flinkTypeEnum == null
											|| "java.lang.String".equals(flinkTypeEnum.getJavaType().getTypeName())) {

										retojb = new BinaryStringData(datastr);
									} else {
										retojb = FlinkTypeEnum.getValue(flinkTypeEnum,datastr, rowField.getType());
									}
									row.setField(indexOfRowType, retojb);
								} else {// 空值处理
									row.setField(indexOfRowType, null);
								}
							}
						}
						ctx.collect(rowData);
					}
				}
			} catch (Throwable e) {
				throw new ProjectExceptionRuntime(ExceptAll.duckula_datanofit, "db:[" + duckulaEvent.getDb() + "] tb:["
						+ duckulaEvent.getTb() + "] gtid:[" + duckulaEvent.getGtid() + "] 转换为rowdata失败");
			}
		}
	}

	@Override
	public void doBusiAsyncTrue(boolean isSplit, boolean logicDel,
			Map<Rule, List<Pair<DuckulaEvent, Map<AddColName, Serializable>>>> sendDataCase) {
		for (Rule rule : sendDataCase.keySet()) {
			for (Pair<DuckulaEvent, Map<AddColName, Serializable>> data : sendDataCase.get(rule)) {
				doBusiTrue(rule, data.getLeft(), data.getRight(), isSplit, logicDel);
			}
		}
	}

}
