/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common
 * 项目描述：公共的工具集
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.flink.connector.binlog.connector;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.tuple.Pair;
import org.apache.flink.streaming.api.functions.source.SourceFunction.SourceContext;

import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.binlog.alone.ListenerConf.ColHis;
import net.wicp.tams.common.binlog.alone.ListenerConf.DuckulaEvent;
import net.wicp.tams.common.binlog.alone.binlog.bean.Rule;
import net.wicp.tams.common.binlog.alone.binlog.listener.AbsBinlogListener;
import net.wicp.tams.common.constant.FieldFormart;
import net.wicp.tams.common.constant.ods.AddColName;

@Slf4j
public class FlinkBinlogListener extends AbsBinlogListener {

	private SourceContext<DuckulaEvent> ctx;

	public void setCtx(SourceContext<DuckulaEvent> ctx) {
		this.ctx = ctx;
	}

	@Override
	public Result doAlterTableCallBack(Rule rule, ColHis colHis, String sql, String[] addColNames, String updateColName,
			String[] deleteColNames, FieldFormart fieldFormart, String newDb, String newTb) {
		return null;
	}

	@Override
	public void doInit(Rule rule, int index) {
	}

	private void doBusiTrue(Rule rule, DuckulaEvent duckulaEvent, Map<AddColName, Serializable> addValues,
			boolean isSplit, boolean logicDel) {
		if (ctx == null) {// 用于测试用
			log.info("the listener is [{}]", duckulaEvent.getGtid());
		} else {
			ctx.collect(duckulaEvent);
		}
	}

	@Override
	public void doBusiAsyncTrue(boolean isSplit, boolean logicDel,
			Map<Rule, List<Pair<DuckulaEvent, Map<AddColName, Serializable>>>> sendDataCase) {
		for (Rule rule : sendDataCase.keySet()) {
			for (Pair<DuckulaEvent, Map<AddColName, Serializable>> data : sendDataCase.get(rule)) {
				doBusiTrue(rule, data.getLeft(), data.getRight(), isSplit, logicDel);
			}
		}
	}

}
