/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common
 * 项目描述：公共的工具集
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.flink.connector.binlog.connector;

import java.sql.Connection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeHint;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.state.FunctionInitializationContext;
import org.apache.flink.runtime.state.FunctionSnapshotContext;
import org.apache.flink.streaming.api.checkpoint.CheckpointedFunction;
import org.apache.flink.streaming.api.functions.source.RichSourceFunction;
import org.apache.flink.table.data.RowData;

import com.twitter.chill.protobuf.ProtobufSerializer;

import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.binlog.alone.BusiAssit;
import net.wicp.tams.common.binlog.alone.DuckulaAssit;
import net.wicp.tams.common.binlog.alone.ListenerConf.CheckPoint;
import net.wicp.tams.common.binlog.alone.ListenerConf.ColHis;
import net.wicp.tams.common.binlog.alone.ListenerConf.ConnConf;
import net.wicp.tams.common.binlog.alone.ListenerConf.ConnConf.Builder;
import net.wicp.tams.common.binlog.alone.ListenerConf.Position;
import net.wicp.tams.common.binlog.alone.binlog.bean.Rule;
import net.wicp.tams.common.binlog.alone.binlog.bean.RuleItem;
import net.wicp.tams.common.binlog.alone.binlog.bean.RuleManager;
import net.wicp.tams.common.binlog.alone.parser.ParseLogOnline;
import net.wicp.tams.common.binlog.dump.MainDump;
import net.wicp.tams.common.flink.common.schema.DuckulaDeserializationSchema;
import net.wicp.tams.common.flink.connector.binlog.DuckulaOptions;
import net.wicp.tams.common.jdbc.DruidAssit;
import net.wicp.tams.common.jdbc.MySqlAssitExt;
import net.wicp.tams.common.thread.threadlocal.PerthreadManager;

@Slf4j
public class BinlogSourceFunction extends RichSourceFunction<RowData>
		implements ResultTypeQueryable<RowData>, CheckpointedFunction {
	private static final long serialVersionUID = 1L;
	private final boolean cdc;
	private static final String listener = "net.wicp.tams.common.flink.connector.binlog.connector.FlinkBinlogTableListener";
	private static final String chk = "net.wicp.tams.common.binlog.alone.checkpoint.CheckPointMemory";

	private final DuckulaDeserializationSchema duckulaDeserializationSchema;
	// 不能用ConnConf.Builder，否则会报错，因为所有的对象都要可序列化
	private ConnConf connConf;

	private ParseLogOnline logFetcher;

	private Configuration optionsWith;

	/***
	 * 需要在配置文件中存在相关的配置
	 * 
	 * @param configKey 监听配置key
	 */
	public BinlogSourceFunction(String configKey, DuckulaDeserializationSchema duckulaDeserializationSchema,
			boolean cdc, Configuration optionsWith) {
		this.duckulaDeserializationSchema = duckulaDeserializationSchema;
		ConnConf.Builder connConfBuilder = BusiAssit.configMap(configKey);
		connConfBuilder.setListener(listener);
		connConfBuilder.setChk(chk);
		log.info("====设置chk:{}", chk);
		this.connConf = connConfBuilder.build();
		this.cdc = cdc;
		this.optionsWith = optionsWith;
	}

	// 传入全局的config,
	public BinlogSourceFunction(DuckulaDeserializationSchema duckulaDeserializationSchema, boolean cdc,
			Configuration optionsWith) {
		this(optionsWith.getString(DuckulaOptions.name), duckulaDeserializationSchema, cdc, optionsWith);
	}

	@Override
	public void run(SourceContext<RowData> ctx) throws Exception {
		// 20220104 初始化连接属性，否则会出现DruidAssit.getConnection空指针错误
		DuckulaOptions.packageParams(optionsWith);
		// end 20220104 初始化连接属性，否则会出现DruidAssit.getConnection空指针错误
		if (cdc) {
			// 初始化数据：
			// 20220104 初始化连接属性，否则会出现DruidAssit.getConnection空指针错误

//			Properties props = new Properties();
//			props.put(String.format("common.jdbc.datasource.%s.host", this.connConf.getConfName()),
//					this.connConf.getHost());
//			props.put(String.format("common.jdbc.datasource.%s.port", this.connConf.getConfName()),
//					this.connConf.getPort());
//			props.put(String.format("common.jdbc.datasource.%s.username", this.connConf.getConfName()),
//					this.connConf.getUsername());
//			props.put(String.format("common.jdbc.datasource.%s.password", this.connConf.getConfName()),
//					this.connConf.getPassword());
//			// 设置其它一些配置
//			props.put("common.binlog.alone.dump.global.enable", "true");
//			props.put("common.binlog.alone.dump.global.overExit", "false");// 做完不退出
//			Conf.overProp(props);
			// end 20220104 初始化连接属性，否则会出现DruidAssit.getConnection空指针错误
			// 1 、锁表 （TODO）
			// 2、拿gtid和时间
			log.info("config========================" + connConf);
			Connection conn = DruidAssit.getConnection(this.connConf.getConfName());
			Position position = DuckulaAssit.getMastStatus(conn).build();
			// 3、全量开始只查小于上面查的时间
			Builder builder = this.connConf.toBuilder();
			builder.setPos(position);
			this.connConf = builder.build();
			packgeDumpWhereSql(position);
			// 4、解锁（TODO）
			// 5、起增量
			// 丑陋的设计：在listener里拿到这个参数
			PerthreadManager.getInstance().createValue("_source_ctx", SourceContext.class).set(ctx);
			PerthreadManager.getInstance().createValue("_source_deserialization", DuckulaDeserializationSchema.class)
					.set(this.duckulaDeserializationSchema);
			// 先做全量再做增量
			MainDump main = new MainDump(this.connConf.getConfName());
			main.dump(null);
			PerthreadManager.getInstance().cleanValue("_source_ctx");
			PerthreadManager.getInstance().cleanValue("_source_deserialization");
			while (true) {
				if (Conf.getBoolean("common.binlog.alone.dump.global.isOver")) {
					break;
				} else {
					log.info("========The dump is not complete =======");
					Thread.sleep(6 * 1000);// 休息6秒再检查
				}
			}
		}
		this.logFetcher = new ParseLogOnline(connConf.toBuilder());
		FlinkBinlogTableListener binlogListener = (FlinkBinlogTableListener) this.logFetcher.getBuffType()
				.getBinlogListenerProxy().getIBinlogListener(this.connConf.getHost());
		binlogListener.setCtx(ctx);
		binlogListener.setDuckulaDeserializationSchema(this.duckulaDeserializationSchema);
		this.logFetcher.setColHis(this.colsList);
		this.logFetcher.read();
	}

	// 如果南要用 aa='val' 可以写成：aa=|val|，否则会有json不能解析的问题
	private void packgeDumpWhereSql(Position position) {
		Map<String, Map<String, String>> dumpConfs = Conf
				.getPreGroup(String.format("common.binlog.alone.dump.%s.ori", this.connConf.getConfName()));
		String updateColName = optionsWith.get(DuckulaOptions.updateColName);
		Properties props = new Properties();
		for (String dumpId : dumpConfs.keySet()) {
			Map<String, String> dumpconf = dumpConfs.get(dumpId);
			if (StringUtil.isNull(dumpconf.get("rule"))) {
				continue;
			}
			RuleManager ruleManager = new RuleManager(dumpconf.get("rule"));
			List<Rule> rules = ruleManager.getRules();
			for (Rule rule : rules) {
				if (!rule.containsItem(RuleItem.wheresql)) {
					rule.putRuleItem(RuleItem.wheresql,
							String.format("where %s<=|%s|", updateColName, position.getTimeStr()));
				} else {// 没有where语句需要
					String sqlstr = rule.getRuleItem(RuleItem.wheresql).toLowerCase();
					boolean index = sqlstr.contains(updateColName);
					if (!index) {
						sqlstr += String.format(" and %s<=|%s|", updateColName, position.getTimeStr());
					} else {// 判断并取最小值
						sqlstr = MySqlAssitExt.minSelectSql(sqlstr.replace("|", "'"),
								String.format(" and %s<='%s'", updateColName, position.getTimeStr()));
					}
					rule.putRuleItem(RuleItem.wheresql, sqlstr.replace("'", "|"));
				}
			}
			String ruleStrTrue = ruleManager.toString();
			props.put(String.format("common.binlog.alone.dump.%s.ori.%s.rule", this.connConf.getConfName(), dumpId),
					ruleStrTrue);
		}
		Conf.overProp(props);
	}

	@Override
	public void cancel() {
		if (this.logFetcher != null) {
			log.info("============cancel the logFetcher");
			this.logFetcher.close();
		}
	}

	@Override
	public TypeInformation<RowData> getProducedType() {
		return this.duckulaDeserializationSchema.getProducedType();
	}

	@Override
	public void setRuntimeContext(RuntimeContext t) {
		super.setRuntimeContext(t);
		t.getExecutionConfig().registerTypeWithKryoSerializer(CheckPoint.class, ProtobufSerializer.class);
		// t.getExecutionConfig().registerTypeWithKryoSerializer(DuckulaEvent.class,
		// ProtobufSerializer.class);
	}

	@Override
	public void open(Configuration parameters) throws Exception {
		super.open(parameters);
		if (parameters != null) {// 为了测试用
			getRuntimeContext().getUserCodeClassLoader().loadClass(listener);
			getRuntimeContext().getUserCodeClassLoader().loadClass(chk);
		}

//		final ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
//		GlobalJobParameters globalJobParameters = env.getConfig().getGlobalJobParameters();
//		globalJobParameters.toMap()

//		ExecutionConfig.GlobalJobParameters globalParams = getRuntimeContext().getExecutionConfig()
//				.getGlobalJobParameters();
//		ParameterTool globConf=(ParameterTool)globalParams;
//		Configuration globConf = (Configuration) globalParams;
//
//		DuckulaOptions.packageParams(globConf);
		/*
		 * getRuntimeContext().getUserCodeClassLoader().loadClass("org.h2.Driver");
		 * getRuntimeContext().getUserCodeClassLoader().loadClass(
		 * "org.h2.mvstore.db.TransactionStore");
		 * getRuntimeContext().getUserCodeClassLoader().loadClass(
		 * "org.h2.mvstore.db.TransactionStore$1");
		 */

	}

	private transient ListState<CheckPoint> checkpointedState;

	private List<ColHis> colsList = null;

	@Override
	public void snapshotState(FunctionSnapshotContext context) throws Exception {
		if (logFetcher != null) {// 有可能dump时间过长，导致触发checkpoint的时候还没有实例化增量
			checkpointedState.clear();
			CheckPoint checkPoint = logFetcher.getCheckPointCur();// .getCheckPoint(timestamp);
			checkpointedState.add(checkPoint);
		}
	}

	@Override
	public void initializeState(FunctionInitializationContext context) throws Exception {
		ListStateDescriptor<CheckPoint> descriptor = new ListStateDescriptor<>("duckula-checkPoint",
				TypeInformation.of(new TypeHint<CheckPoint>() {
				}));
		checkpointedState = context.getOperatorStateStore().getListState(descriptor);
		if (context.isRestored()) {
			Iterator<CheckPoint> iterator = checkpointedState.get().iterator();
			if (iterator.hasNext()) {
				ConnConf.Builder newBuilder = connConf.toBuilder();
				CheckPoint checkPoint = iterator.next();
				Position pos = checkPoint.getPos();
				log.info("the binlog begin from:{}", pos.getGtids());
				newBuilder.setPos(pos);
				this.connConf = newBuilder.build();
				this.colsList = checkPoint.getColsList();
			}
		}
	}

}
