/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common
 * 项目描述：公共的工具集
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.flink.connector.binlog;

import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.flink.common.constant.EnvName;
import net.wicp.tams.common.flink.connector.binlog.connector.BinlogTableSource;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.connector.format.DecodingFormat;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.factories.DeserializationFormatFactory;
import org.apache.flink.table.factories.DynamicTableSourceFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.types.DataType;

import java.util.HashSet;
import java.util.Set;

public class DuckulaTableSourceFactory implements DynamicTableSourceFactory {

	@Override
	public DynamicTableSource createDynamicTableSource(Context context) {
		CatalogTable catalogTable = context.getCatalogTable();
		// 20220104 获取with配置,设置全局变量
		Configuration optionsWith = new Configuration();
		catalogTable.getOptions().forEach(optionsWith::setString);
//		final ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
//		env.getConfig().setGlobalJobParameters(optionsWith);

		// end 20220104 获取with配置,设置全局变量
		// 实现自定义验证逻辑 或 使用提供的帮助工具类 FactoryUtil.TableFactoryHelper
		final FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper(this, context);

		// 发现合适的 DecodingFormat
		// discover a suitable decoding format
		final ReadableConfig options = helper.getOptions();
		// 写死formate duckula
		// FactoryUtil.FORMAT.
		final DecodingFormat<DeserializationSchema<RowData>> discoverDecodingFormat = helper
				.discoverDecodingFormat(DeserializationFormatFactory.class, DuckulaOptions.format);
		// 验证 options
		helper.validate();
		//////////////////////////////////////////////// 处理默认值///////////////////////////////////////////////////////////////////////////////////////
		String db = options.get(DuckulaOptions.db);
		db = db.replaceAll("\\*", "");
		String tb = options.get(DuckulaOptions.tb);
		tb = tb.replaceAll("\\*", "");
		String taskname = String.format("%s-%s-%s", StringUtil.hasNull(EnvName.taskId.getValue(), "tams"), db, tb);
		if (!optionsWith.contains(DuckulaOptions.name)) {// 处理name,支持多流join，需要有name分隔
			optionsWith.set(DuckulaOptions.name, taskname);
			taskname = optionsWith.getString(DuckulaOptions.name);
		}
		// clientId不能重复
		if (!optionsWith.contains(DuckulaOptions.clientId)) {
			Integer clientId = StringUtil.buildPort(taskname);
			optionsWith.set(DuckulaOptions.clientId, clientId);
		}
		//////////////////////////////////////////////// end处理默认值///////////////////////////////////////////////////////////////////////////////////////
		DuckulaOptions.packageParams(optionsWith);

		// derive the produced data type (excluding computed columns) from the catalog
		// table
		final DataType producedDataType = context.getCatalogTable().getResolvedSchema().toPhysicalRowDataType();
		return new BinlogTableSource(discoverDecodingFormat, producedDataType, options.get(DuckulaOptions.cdc),
				optionsWith);
	}

	/**
	 * @return connector的标识
	 */
	@Override
	public String factoryIdentifier() {
		return BinlogTableSource.IDENTIFIER;
	}

	/**
	 * 必须配置的参数，默认返回空集合
	 * 
	 * @return
	 */
	@Override
	public Set<ConfigOption<?>> requiredOptions() {
		Set<ConfigOption<?>> options = new HashSet<>();
		options.add(DuckulaOptions.host);
		options.add(DuckulaOptions.username);
		options.add(DuckulaOptions.password);
		options.add(DuckulaOptions.db);
		options.add(DuckulaOptions.tb);
		return options;// Collections.emptySet();
	}

	/**
	 * 可额外配置的参数，默认返回空集合
	 * 
	 * @return
	 */
	@Override
	public Set<ConfigOption<?>> optionalOptions() {
		Set<ConfigOption<?>> options = new HashSet<>();
		options.add(DuckulaOptions.clientId);
		options.add(DuckulaOptions.groupId);
		options.add(DuckulaOptions.port);
		options.add(DuckulaOptions.rds);
		options.add(DuckulaOptions.haType);
		options.add(DuckulaOptions.cdc);
		options.add(DuckulaOptions.fieldFormart);
		options.add(DuckulaOptions.addColNameType);
		options.add(DuckulaOptions.updateColName);
		options.add(DuckulaOptions.name);
		options.add(DuckulaOptions.append);
		return options;
	}

}
