/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.flink.catalog;

import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.flink.catalog.MysqlCatalog;
import net.wicp.tams.common.flink.catalog.MysqlCatalogFactoryOptions;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.factories.CatalogFactory;
import org.apache.flink.table.factories.FactoryUtil;

public class MysqlCatalogFactory
implements CatalogFactory {
    public String factoryIdentifier() {
        return "tams";
    }

    public Set<ConfigOption<?>> requiredOptions() {
        HashSet options = new HashSet();
        options.add(MysqlCatalogFactoryOptions.host);
        options.add(MysqlCatalogFactoryOptions.username);
        options.add(MysqlCatalogFactoryOptions.password);
        options.add(MysqlCatalogFactoryOptions.defaultdb);
        options.add(MysqlCatalogFactoryOptions.tenantId);
        options.add(MysqlCatalogFactoryOptions.operate);
        return options;
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet options = new HashSet();
        options.add(MysqlCatalogFactoryOptions.port);
        options.add(MysqlCatalogFactoryOptions.url);
        options.add(MysqlCatalogFactoryOptions.urlparam);
        return options;
    }

    public Catalog createCatalog(CatalogFactory.Context context) {
        FactoryUtil.CatalogFactoryHelper helper = FactoryUtil.createCatalogFactoryHelper((CatalogFactory)this, (CatalogFactory.Context)context);
        helper.validate();
        ReadableConfig options = helper.getOptions();
        this.packageOptions(options);
        return new MysqlCatalog(context.getName(), (String)options.get(MysqlCatalogFactoryOptions.defaultdb), (Long)options.get(MysqlCatalogFactoryOptions.tenantId), (Long)options.get(MysqlCatalogFactoryOptions.operate));
    }

    private void packageOptions(ReadableConfig options) {
        Properties props = new Properties();
        String propPre = String.format("common.jdbc.datasource.%s.", "tams");
        props.put(propPre + MysqlCatalogFactoryOptions.host.key(), options.get(MysqlCatalogFactoryOptions.host));
        props.put(propPre + MysqlCatalogFactoryOptions.username.key(), options.get(MysqlCatalogFactoryOptions.username));
        props.put(propPre + MysqlCatalogFactoryOptions.password.key(), options.get(MysqlCatalogFactoryOptions.password));
        props.put(propPre + MysqlCatalogFactoryOptions.port.key(), options.get(MysqlCatalogFactoryOptions.port));
        props.put(propPre + MysqlCatalogFactoryOptions.defaultdb.key(), options.get(MysqlCatalogFactoryOptions.defaultdb));
        if (StringUtil.isNotNull((Object)options.get(MysqlCatalogFactoryOptions.url))) {
            props.put(propPre + MysqlCatalogFactoryOptions.url.key(), options.get(MysqlCatalogFactoryOptions.url));
        }
        if (StringUtil.isNotNull((Object)options.get(MysqlCatalogFactoryOptions.urlparam))) {
            props.put(propPre + MysqlCatalogFactoryOptions.urlparam.key(), options.get(MysqlCatalogFactoryOptions.urlparam));
        }
        Conf.overProp((Properties)props);
    }
}

