/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.flink.catalog;

import com.alibaba.fastjson.JSONObject;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.CollectionUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.apiext.jdbc.MySqlColBean;
import net.wicp.tams.common.apiext.jdbc.MySqlTbBean;
import net.wicp.tams.common.apiext.json.JSONUtil;
import net.wicp.tams.common.constant.Middleware;
import net.wicp.tams.common.constant.MiddlewareOption;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.IExcept;
import net.wicp.tams.common.exception.ProjectException;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;
import net.wicp.tams.common.flink.catalog.InitSql;
import net.wicp.tams.common.flink.common.CatalogAssit;
import net.wicp.tams.common.flink.common.constant.DelLevel;
import net.wicp.tams.common.flink.common.constant.FlinkTypeEnum;
import net.wicp.tams.common.flink.common.constant.db.ColsMetaCol;
import net.wicp.tams.common.flink.common.constant.db.ColsMetaDb;
import net.wicp.tams.common.flink.common.constant.db.ColsMetaFun;
import net.wicp.tams.common.flink.common.constant.db.ColsMetaTb;
import net.wicp.tams.common.flink.common.constant.db.ColsMetaTbLogic;
import net.wicp.tams.common.flink.common.constant.db.ColsMetaView;
import net.wicp.tams.common.flink.common.module.IPackageEnum;
import net.wicp.tams.common.flink.common.module.IUdfEnum;
import net.wicp.tams.common.jdbc.DruidAssit;
import net.wicp.tams.common.jdbc.MySqlAssitExt;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.TableNotExistException;
import org.apache.flink.table.catalog.AbstractCatalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogDatabase;
import org.apache.flink.table.catalog.CatalogDatabaseImpl;
import org.apache.flink.table.catalog.CatalogFunction;
import org.apache.flink.table.catalog.CatalogFunctionImpl;
import org.apache.flink.table.catalog.CatalogPartition;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.CatalogView;
import org.apache.flink.table.catalog.FunctionLanguage;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.catalog.exceptions.DatabaseAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.DatabaseNotEmptyException;
import org.apache.flink.table.catalog.exceptions.DatabaseNotExistException;
import org.apache.flink.table.catalog.exceptions.FunctionAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.FunctionNotExistException;
import org.apache.flink.table.catalog.exceptions.PartitionAlreadyExistsException;
import org.apache.flink.table.catalog.exceptions.PartitionNotExistException;
import org.apache.flink.table.catalog.exceptions.PartitionSpecInvalidException;
import org.apache.flink.table.catalog.exceptions.TableAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.TableNotPartitionedException;
import org.apache.flink.table.catalog.exceptions.TablePartitionedException;
import org.apache.flink.table.catalog.stats.CatalogColumnStatistics;
import org.apache.flink.table.catalog.stats.CatalogTableStatistics;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.factories.Factory;
import org.apache.flink.table.functions.FunctionKind;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.AtomicDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;

public class MysqlCatalog
extends AbstractCatalog {
    private final String tbPre = "t_";
    private final String viewPre = "v_";
    private final String errorMsg = "\u8868\u4ee5t_\u5f00\u5934\uff0c\u89c6\u56fe\u4ee5v_\u5f00\u5934\uff0c\u4e0d\u5b58\u5728\u6b64\u7c7b\u578b\u7684\u5bf9\u8c61[%s]";
    private final long tenantId;
    private final long operate;
    private Connection connection;

    public MysqlCatalog(String catalogName, String defaultDatabase, long tenantId, long operate) {
        super(catalogName, defaultDatabase);
        this.tenantId = tenantId;
        this.operate = operate;
    }

    public void open() throws CatalogException {
        this.connection = DruidAssit.getConnection((String)"tams");
        try {
            MySqlAssitExt.execSql((Connection)this.connection, (String)InitSql.metaColSql);
            MySqlAssitExt.execSql((Connection)this.connection, (String)InitSql.metaDbSql);
            MySqlAssitExt.execSql((Connection)this.connection, (String)InitSql.metaFunSql);
            MySqlAssitExt.execSql((Connection)this.connection, (String)InitSql.metaTbSql);
        }
        catch (Exception e1) {
            throw new ProjectExceptionRuntime((IExcept)ExceptAll.jdbc_exec_fail, "\u521d\u59cb\u5316\u76f8\u5173\u5143\u6570\u636e\u8868\u5931\u8d25", (Throwable)e1);
        }
        try {
            this.createDatabase(this.getDefaultDatabase(), null, true);
        }
        catch (CatalogException | DatabaseAlreadyExistException e1) {
            throw new ProjectExceptionRuntime((IExcept)ExceptAll.jdbc_exec_fail, "\u521d\u59cb\u5316default\u5e93\u5931\u8d25", e1);
        }
        List listFunctions = CatalogAssit.listFunctions((Connection)this.connection, (long)this.tenantId);
        ServiceLoader<IPackageEnum> udffats = ServiceLoader.load(IPackageEnum.class);
        for (IPackageEnum udffat : udffats) {
            try {
                IUdfEnum[] udfs;
                for (IUdfEnum udf : udfs = udffat.queryAll()) {
                    if (listFunctions.contains(udf.getFullName())) continue;
                    CatalogAssit.createFunByMoudle((Connection)this.connection, (String)super.getDefaultDatabase(), (long)-1L, (String)udf.getDbName(), (IUdfEnum)udf, (long)this.tenantId, (long)this.operate);
                }
            }
            catch (Exception e) {
                throw new ProjectExceptionRuntime((IExcept)ExceptAll.flink_udf_errorformate, "\u9700\u8981\u5b9a\u4e49\u5b9e\u73b0IUdfEnum\u63a5\u53e3\u7684\u679a\u4e3e\u7c7b", (Throwable)e);
            }
        }
    }

    public void close() throws CatalogException {
        DruidAssit.close((Connection)this.connection);
    }

    public List<String> listDatabases() throws CatalogException {
        List querySqlMap = MySqlAssitExt.querySqlMapPre((Connection)this.connection, (String)"select name from meta_db where tenant_id=?", (boolean)false, (Object[])new Object[]{this.tenantId});
        List dbs = CollectionUtil.getColFromObj((List)querySqlMap, (String)"name");
        return dbs;
    }

    public CatalogDatabase getDatabase(String databaseName) throws DatabaseNotExistException, CatalogException {
        ResultSet rs = MySqlAssitExt.querySql((Connection)this.connection, (String)String.format("select * from %s where %s='%s' and  %s='%s'", "meta_db", ColsMetaDb.tenantId.getOriColName(), this.tenantId, ColsMetaDb.name.getOriColName(), databaseName));
        try {
            if (rs.next()) {
                Map properties = new HashMap();
                String propertiesStr = rs.getString(ColsMetaDb.properties.getOriColName());
                if (StringUtil.isNull((Object)rs)) {
                    properties = JSONUtil.jsonToMapStr((JSONObject)JSONObject.parseObject((String)propertiesStr));
                }
                CatalogDatabaseImpl retobj = new CatalogDatabaseImpl(properties, rs.getString(ColsMetaDb.comment.getOriColName()));
                return retobj;
            }
        }
        catch (SQLException e) {
            throw new ProjectExceptionRuntime((IExcept)ExceptAll.duckula_nodata, "\u67e5\u6570\u636e\u5e93" + databaseName + "\u5931\u8d25", (Throwable)e);
        }
        throw new DatabaseNotExistException(this.getName(), databaseName);
    }

    public List<String> listTables(String databaseName) throws DatabaseNotExistException, CatalogException {
        List colFromObj = CatalogAssit.listTableOrViewByDb((Connection)this.connection, (String)databaseName, (CatalogBaseTable.TableKind)CatalogBaseTable.TableKind.TABLE, (long)this.tenantId);
        return colFromObj;
    }

    public List<String> listViews(String databaseName) throws DatabaseNotExistException, CatalogException {
        List colFromObj = CatalogAssit.listTableOrViewByDb((Connection)this.connection, (String)databaseName, (CatalogBaseTable.TableKind)CatalogBaseTable.TableKind.VIEW, (long)this.tenantId);
        return colFromObj;
    }

    public CatalogBaseTable getTable(ObjectPath tablePath) throws TableNotExistException, CatalogException {
        Map<String, String> tbinfo = null;
        try {
            tbinfo = this.queryTable(tablePath);
        }
        catch (Exception e) {
            throw new CatalogException("\u67e5\u8be2table\u5931\u8d25", (Throwable)e);
        }
        if (tbinfo == null) {
            throw new TableNotExistException(this.getName(), tablePath.getObjectName());
        }
        String objectName = tablePath.getObjectName();
        if (objectName.startsWith("t_")) {
            Map<String, String> tbLogicInfo = this.getTableInfoLogic(Long.parseLong(tbinfo.get(ColsMetaTb.tbLogicId.getOriColName())), tablePath);
            Schema.Builder builder = Schema.newBuilder();
            String comment = tbLogicInfo.get(ColsMetaTbLogic.comment.getOriColName());
            String partitionkeysStr = tbLogicInfo.get(ColsMetaTbLogic.partitionkeys.getOriColName());
            List<Object> partitionKeys = StringUtil.isNull((Object)partitionkeysStr) ? new ArrayList() : Arrays.asList(partitionkeysStr.split(","));
            String optionsStr = tbinfo.get(ColsMetaTb.withOptions.getOriColName());
            Map options = null;
            if (StringUtil.isNotNull((Object)optionsStr)) {
                JSONObject jsonObject = JSONObject.parseObject((String)optionsStr);
                options = JSONUtil.jsonToMapStr((JSONObject)jsonObject);
            } else {
                options = new HashMap();
            }
            Object[] keys = tbLogicInfo.get(ColsMetaTbLogic.keyCol.getOriColName()).split(",");
            if (ArrayUtils.isEmpty((Object[])keys)) {
                throw new CatalogException(tablePath.getFullName() + "\u6ca1\u6709\u914d\u7f6e\u4e3b\u952e\uff0c\u8bf7\u786e\u8ba4\u8868\u7684\u914d\u7f6e\u662f\u6b63\u786e\u7684\u3002");
            }
            builder.primaryKey((String[])keys);
            List<Object> queryCols = new ArrayList();
            try {
                queryCols = this.queryCols(Long.parseLong(tbLogicInfo.get(ColsMetaTbLogic.id.getOriColName())));
            }
            catch (Exception e) {
                throw new CatalogException("\u67e5\u8be2cols\u5931\u8d25");
            }
            if (CollectionUtils.isEmpty(queryCols)) {
                throw new CatalogException(tablePath.getFullName() + "\u6ca1\u6709\u914d\u7f6e\u5b57\u6bb5\uff0c\u8bf7\u786e\u8ba4\u8868\u7684\u914d\u7f6e\u662f\u6b63\u786e\u7684\u3002");
            }
            for (Map map : queryCols) {
                String sqlexpression;
                String colName = (String)map.get(ColsMetaCol.name.getOriColName());
                String watermarkExpression = (String)map.get(ColsMetaCol.watermarkExpression.getOriColName());
                if (StringUtil.isNotNull((Object)watermarkExpression)) {
                    builder.watermark(colName, watermarkExpression);
                }
                if (StringUtil.isNotNull((Object)(sqlexpression = (String)map.get(ColsMetaCol.sqlexpression.getOriColName())))) {
                    builder.columnByExpression(colName, sqlexpression);
                    continue;
                }
                FlinkTypeEnum flinkTypeEnum = FlinkTypeEnum.findByFlinkRowType((String)((String)map.get(ColsMetaCol.type.getOriColName())));
                if (flinkTypeEnum == null || flinkTypeEnum.getConvert().getObj() == null) {
                    throw new CatalogException("\u6b64\u7c7b\u578b[" + (String)map.get(ColsMetaCol.type.getOriColName()) + "]\u8fd8\u4e0d\u652f\u6301\uff0c\u9700\u8981\u8fde\u63a5\u76f8\u5173\u4eba\u5458\u3002");
                }
                DataType dataType = null;
                switch (flinkTypeEnum) {
                    default: 
                }
                dataType = (DataType)flinkTypeEnum.getConvert().getObj();
                String notNullStr = (String)map.get(ColsMetaCol.notNull.getOriColName());
                dataType = "yes".equals(StringUtil.hasNull((String[])new String[]{notNullStr, "no"})) ? (DataType)dataType.notNull() : (DataType)dataType.nullable();
                builder.column(colName, (AbstractDataType)dataType);
            }
            builder.columnByExpression("proc_time", "PROCTIME()");
            CatalogTable retobj = CatalogTable.of((Schema)builder.build(), (String)comment, partitionKeys, options);
            return retobj;
        }
        if (objectName.startsWith("v_")) {
            Schema.Builder builder = Schema.newBuilder();
            String comment = tbinfo.get(ColsMetaView.remark.getOriColName());
            String originalQuery = tbinfo.get(ColsMetaView.originalQuery.getOriColName());
            String expandedQuery = tbinfo.get(ColsMetaView.expandedQuery.getOriColName());
            String optionsStr = tbinfo.get(ColsMetaView.withOptions.getOriColName());
            Map options = null;
            if (StringUtil.isNotNull((Object)optionsStr)) {
                JSONObject jsonObject = JSONObject.parseObject((String)optionsStr);
                options = JSONUtil.jsonToMapStr((JSONObject)jsonObject);
            } else {
                options = new HashMap();
            }
            CatalogView retobj = CatalogView.of((Schema)builder.build(), (String)comment, (String)originalQuery, (String)expandedQuery, options);
            return retobj;
        }
        throw new CatalogException(String.format("\u8868\u4ee5t_\u5f00\u5934\uff0c\u89c6\u56fe\u4ee5v_\u5f00\u5934\uff0c\u4e0d\u5b58\u5728\u6b64\u7c7b\u578b\u7684\u5bf9\u8c61[%s]", tablePath));
    }

    private Map<String, String> getTableInfoLogic(long logicTbId, ObjectPath tablePath) {
        List querySqlMap = MySqlAssitExt.querySqlMapPre((Connection)this.connection, (String)String.format("select * from  %s where %s=? and  %s=?", "meta_tb_logic", ColsMetaTb.id.getOriColName(), ColsMetaTb.tenantId.getOriColName()), (boolean)false, (Object[])new Object[]{logicTbId, this.tenantId});
        if (CollectionUtils.isNotEmpty((Collection)querySqlMap)) {
            return (Map)querySqlMap.get(0);
        }
        throw new TableNotExistException(this.getName(), tablePath.getObjectName());
    }

    public boolean tableExists(ObjectPath tablePath) throws CatalogException {
        try {
            CatalogBaseTable baseTable = this.getTable(tablePath);
            return baseTable != null;
        }
        catch (TableNotExistException e) {
            return false;
        }
    }

    public void dropTable(ObjectPath tablePath, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException {
        try {
            Result dropTable = CatalogAssit.dropTable((Connection)this.connection, (String)super.getDefaultDatabase(), (String)tablePath.getDatabaseName(), (String)tablePath.getObjectName(), (DelLevel)DelLevel.delLogicNotTb, (long)this.tenantId);
            if (!dropTable.isSuc()) {
                if (ignoreIfNotExists && ExceptAll.flink_catalog_tablenotexit == dropTable.getExcept()) {
                    throw new TableNotExistException(this.getName(), tablePath.getObjectName());
                }
                throw new CatalogException(dropTable.getMessage());
            }
        }
        catch (ProjectException e) {
            throw new CatalogException(e.getMessage());
        }
    }

    public void renameTable(ObjectPath tablePath, String newTableName, boolean ignoreIfNotExists) throws TableNotExistException, TableAlreadyExistException, CatalogException {
    }

    public void createTable(ObjectPath tablePath, CatalogBaseTable table, boolean ignoreIfExists) throws TableAlreadyExistException, DatabaseNotExistException, CatalogException {
        CatalogBaseTable baseTable;
        this.validDb(tablePath);
        try {
            baseTable = this.getTable(tablePath);
        }
        catch (TableNotExistException e) {
            baseTable = null;
        }
        if (!ignoreIfExists && baseTable != null) {
            throw new TableAlreadyExistException(this.getName(), tablePath);
        }
        if (baseTable == null) {
            String objectName = tablePath.getObjectName();
            if (objectName.startsWith("t_") && table.getTableKind() == CatalogBaseTable.TableKind.TABLE) {
                try {
                    CatalogTable tableTrue;
                    Optional primaryKey = table.getUnresolvedSchema().getPrimaryKey();
                    List primaryKeys = primaryKey.isPresent() ? ((Schema.UnresolvedPrimaryKey)primaryKey.get()).getColumnNames() : new ArrayList();
                    ArrayList<Object> mysqlColList = new ArrayList<Object>();
                    List columns = table.getUnresolvedSchema().getColumns();
                    for (Schema.UnresolvedColumn column : columns) {
                        String type = "";
                        if (column instanceof Schema.UnresolvedPhysicalColumn) {
                            Schema.UnresolvedPhysicalColumn temp = (Schema.UnresolvedPhysicalColumn)column;
                            try {
                                LogicalTypeRoot typeRoot = ((AtomicDataType)temp.getDataType()).getLogicalType().getTypeRoot();
                                FlinkTypeEnum flinkTypeEnum = FlinkTypeEnum.valueOf((String)typeRoot.name());
                                type = flinkTypeEnum.name();
                            }
                            catch (Exception e) {
                                throw new CatalogException("\u521b\u5efa\u8868[" + objectName + "]\u65f6\u7c7b\u578b\u68c0\u67e5\u5f02\u5e38\uff0c\u539f\u56e0\uff1a\u8fd8\u4e0d\u652f\u6301\u6b64\u7c7b\u578b[" + temp.getName() + "]" + e.getMessage(), (Throwable)e);
                            }
                        }
                        MySqlColBean tempbean = new MySqlColBean(column.getName(), type);
                        tempbean.setPri(primaryKeys.contains(column.getName()));
                        tempbean.setDataType(type);
                        mysqlColList.add(tempbean);
                    }
                    String partitionkeys = "";
                    if (table.getTableKind() == CatalogBaseTable.TableKind.TABLE && CollectionUtils.isNotEmpty((Collection)(tableTrue = (CatalogTable)table).getPartitionKeys())) {
                        partitionkeys = CollectionUtil.listJoin((Collection)tableTrue.getPartitionKeys(), (String)",");
                    }
                    HashMap allOptmap = new HashMap();
                    Map options = table.getOptions();
                    if (MapUtils.isNotEmpty((Map)options)) {
                        for (String optionstr : options.keySet()) {
                            MiddlewareOption findByNameUse = MiddlewareOption.findByNameUse((String)optionstr);
                            if (findByNameUse != null) {
                                allOptmap.put(findByNameUse, options.get(optionstr));
                                continue;
                            }
                            throw new CatalogException("\u521b\u5efa\u8868[" + objectName + "]\u65f6\u68c0\u67e5\u5f02\u5e38\uff0c\u539f\u56e0\u8fd8\u6ca1\u652f\u6301\u6b64option[" + optionstr + "].");
                        }
                    }
                    Pair proOptStr = Middleware.proOptStr(allOptmap, (MiddlewareOption[])allOptmap.keySet().toArray(new MiddlewareOption[allOptmap.size()]));
                    MySqlTbBean catalogTbInfo = MySqlTbBean.builder().db(tablePath.getDatabaseName()).tb(objectName).tbComment("\u901a\u8fc7sql\u521b\u5efa").middleware(Middleware.no).partitionkeys(partitionkeys).opt((String)proOptStr.getRight()).withOptions((String)proOptStr.getLeft()).build();
                    CatalogAssit.createTable((Connection)this.connection, (String)this.getDefaultDatabase(), mysqlColList, (MySqlTbBean)catalogTbInfo, (long)this.tenantId, (long)this.operate);
                }
                catch (ProjectException e) {
                    throw new CatalogException("\u521b\u5efa\u8868[" + objectName + "]\u65f6SQL\u5f02\u5e38\uff0c\u539f\u56e0\uff1a" + e.getMessage(), (Throwable)e);
                }
            }
            if (objectName.startsWith("v_") && table.getTableKind() == CatalogBaseTable.TableKind.VIEW) {
                try {
                    Timestamp currentTime = new Timestamp(System.currentTimeMillis());
                    CatalogView catalogView = (CatalogView)table;
                    PreparedStatement insertColPre = this.connection.prepareStatement(String.format("insert %s(%s,%s,%s,%s,%s,%s,%s,%s,%s,%s) value(?,?,?,?,?,?,?,?,?,?)", "meta_view", ColsMetaView.dbName.getOriColName(), ColsMetaView.kind.getOriColName(), ColsMetaView.name.getOriColName(), ColsMetaView.originalQuery.getOriColName(), ColsMetaView.expandedQuery.getOriColName(), ColsMetaView.createBy.getOriColName(), ColsMetaView.updateBy.getOriColName(), ColsMetaView.createTime.getOriColName(), ColsMetaView.updateTime.getOriColName(), ColsMetaView.tenantId.getOriColName()));
                    MySqlAssitExt.setPreParam((PreparedStatement)insertColPre, (boolean)false, (Object[])new Object[]{tablePath.getDatabaseName(), catalogView.getTableKind().name(), objectName, catalogView.getOriginalQuery(), catalogView.getExpandedQuery(), this.operate, this.operate, currentTime, currentTime, this.tenantId});
                    insertColPre.execute();
                }
                catch (Exception e) {
                    throw new CatalogException("\u521b\u5efa\u89c6\u56fe[" + objectName + "]\u65f6SQL\u5f02\u5e38", (Throwable)e);
                }
            } else {
                throw new CatalogException(String.format("\u8868\u4ee5t_\u5f00\u5934\uff0c\u89c6\u56fe\u4ee5v_\u5f00\u5934\uff0c\u4e0d\u5b58\u5728\u6b64\u7c7b\u578b\u7684\u5bf9\u8c61[%s]", tablePath));
            }
        }
    }

    private void validDb(ObjectPath tablePath) throws DatabaseNotExistException {
        CatalogDatabase database;
        try {
            database = this.getDatabase(tablePath.getDatabaseName());
        }
        catch (DatabaseNotExistException e) {
            database = null;
        }
        if (database == null) {
            throw new DatabaseNotExistException(this.getName(), tablePath.getDatabaseName());
        }
    }

    private Map<String, String> queryTable(ObjectPath tablePath) throws SQLException {
        String objectName = tablePath.getObjectName();
        if (objectName.startsWith("t_")) {
            Map queryTable = CatalogAssit.queryTable((Connection)this.connection, (String)super.getDefaultDatabase(), (String)tablePath.getDatabaseName(), (String)tablePath.getObjectName(), (long)this.tenantId);
            return queryTable;
        }
        if (objectName.startsWith("v_")) {
            Map queryView = CatalogAssit.queryView((Connection)this.connection, (String)super.getDefaultDatabase(), (String)tablePath.getDatabaseName(), (String)tablePath.getObjectName(), (long)this.tenantId);
            return queryView;
        }
        throw new CatalogException(String.format("\u8868\u4ee5t_\u5f00\u5934\uff0c\u89c6\u56fe\u4ee5v_\u5f00\u5934\uff0c\u4e0d\u5b58\u5728\u6b64\u7c7b\u578b\u7684\u5bf9\u8c61[%s]", tablePath));
    }

    private Map<String, String> queryFun(ObjectPath functionPath) throws SQLException {
        List querySqlMap = MySqlAssitExt.querySqlMapPre((Connection)this.connection, (String)String.format("select * from %s where %s=? and  %s=? and  %s=?", "meta_fun", ColsMetaFun.tenantId.getOriColName(), ColsMetaFun.dbName.getOriColName(), ColsMetaFun.name.getOriColName()), (boolean)false, (Object[])new Object[]{this.tenantId, functionPath.getDatabaseName(), functionPath.getObjectName()});
        if (CollectionUtils.isNotEmpty((Collection)querySqlMap)) {
            return (Map)querySqlMap.get(0);
        }
        return null;
    }

    private List<Map<String, String>> queryCols(Long logicTableId) throws SQLException {
        List querySqlMap = MySqlAssitExt.querySqlMapPre((Connection)this.connection, (String)String.format("select * from  %s where %s=? and  %s=? order by id", "meta_col", ColsMetaCol.tenantId.getOriColName(), ColsMetaCol.tbLogicId.getOriColName()), (boolean)false, (Object[])new Object[]{this.tenantId, logicTableId});
        return querySqlMap;
    }

    public void alterTable(ObjectPath tablePath, CatalogBaseTable newTable, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException {
        this.dropTable(tablePath, true);
        try {
            this.createTable(tablePath, newTable, false);
        }
        catch (DatabaseNotExistException | TableAlreadyExistException e) {
            throw new CatalogException(e);
        }
    }

    public List<CatalogPartitionSpec> listPartitions(ObjectPath tablePath) throws TableNotExistException, TableNotPartitionedException, CatalogException {
        return null;
    }

    public List<CatalogPartitionSpec> listPartitions(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws TableNotExistException, TableNotPartitionedException, CatalogException {
        return null;
    }

    public List<CatalogPartitionSpec> listPartitionsByFilter(ObjectPath tablePath, List<Expression> filters) throws TableNotExistException, TableNotPartitionedException, CatalogException {
        return null;
    }

    public CatalogPartition getPartition(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws PartitionNotExistException, CatalogException {
        return null;
    }

    public boolean partitionExists(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws CatalogException {
        return false;
    }

    public void createPartition(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, CatalogPartition partition, boolean ignoreIfExists) throws TableNotExistException, TableNotPartitionedException, PartitionSpecInvalidException, PartitionAlreadyExistsException, CatalogException {
    }

    public void dropPartition(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, boolean ignoreIfNotExists) throws PartitionNotExistException, CatalogException {
    }

    public void alterPartition(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, CatalogPartition newPartition, boolean ignoreIfNotExists) throws PartitionNotExistException, CatalogException {
    }

    public List<String> listFunctions(String dbName) throws DatabaseNotExistException, CatalogException {
        List listFunctions = CatalogAssit.listFunctions((Connection)this.connection, (String)dbName, (long)this.tenantId);
        return listFunctions;
    }

    public CatalogFunction getFunction(ObjectPath functionPath) throws FunctionNotExistException, CatalogException {
        Map<String, String> funinfo = null;
        try {
            funinfo = this.queryFun(functionPath);
        }
        catch (Exception e) {
            throw new CatalogException("\u67e5\u8be2fun\u5931\u8d25");
        }
        if (funinfo == null) {
            throw new FunctionNotExistException(this.getName(), functionPath);
        }
        CatalogFunctionImpl retFun = new CatalogFunctionImpl(funinfo.get(ColsMetaFun.identifier.getOriColName()), FunctionLanguage.valueOf((String)funinfo.get(ColsMetaFun.language.getOriColName())));
        return retFun;
    }

    public boolean functionExists(ObjectPath functionPath) throws CatalogException {
        try {
            CatalogFunction function = this.getFunction(functionPath);
            return function != null;
        }
        catch (FunctionNotExistException e) {
            return false;
        }
    }

    public void createFunction(final ObjectPath functionPath, final CatalogFunction function, boolean ignoreIfExists) throws FunctionAlreadyExistException, DatabaseNotExistException, CatalogException {
        CatalogFunction baseFun;
        this.validDb(functionPath);
        try {
            baseFun = this.getFunction(functionPath);
        }
        catch (FunctionNotExistException e) {
            baseFun = null;
        }
        if (!ignoreIfExists && baseFun != null) {
            throw new FunctionAlreadyExistException(this.getName(), functionPath);
        }
        if (baseFun == null) {
            try {
                CatalogAssit.createFunByMoudle((Connection)this.connection, (String)super.getDefaultDatabase(), (long)-1L, (String)functionPath.getDatabaseName(), (IUdfEnum)new IUdfEnum(){

                    public String getName() {
                        return functionPath.getObjectName();
                    }

                    public FunctionKind getKind() {
                        return FunctionKind.SCALAR;
                    }

                    public String getClassFullName() {
                        return function.getClassName();
                    }

                    public String getDbName() {
                        return functionPath.getDatabaseName();
                    }
                }, (long)this.tenantId, (long)this.operate);
            }
            catch (SQLException e1) {
                throw new CatalogException("\u521b\u5efa\u51fd\u6570\u65f6\u5931\u8d25", (Throwable)e1);
            }
        }
    }

    public void alterFunction(ObjectPath functionPath, CatalogFunction newFunction, boolean ignoreIfNotExists) throws FunctionNotExistException, CatalogException {
        this.dropFunction(functionPath, ignoreIfNotExists);
        try {
            this.createFunction(functionPath, newFunction, ignoreIfNotExists);
        }
        catch (FunctionAlreadyExistException e) {
            throw new CatalogException((Throwable)e);
        }
        catch (DatabaseNotExistException e) {
            throw new CatalogException((Throwable)e);
        }
    }

    public void dropFunction(ObjectPath functionPath, boolean ignoreIfNotExists) throws FunctionNotExistException, CatalogException {
        Map<String, String> funinfo = null;
        try {
            funinfo = this.queryFun(functionPath);
        }
        catch (Exception e) {
            throw new CatalogException("\u67e5\u8be2fun\u5931\u8d25");
        }
        if (!ignoreIfNotExists && funinfo == null) {
            throw new FunctionNotExistException(this.getName(), functionPath);
        }
        if (funinfo != null) {
            try {
                MySqlAssitExt.execSqlPre((Connection)this.connection, (String)String.format("delete from %s where %s=? ", "meta_fun", ColsMetaFun.id.getOriColName()), (Object[])new Object[]{Long.parseLong(funinfo.get(ColsMetaFun.id.getOriColName()))});
            }
            catch (Exception e) {
                throw new CatalogException("\u5220\u9664\u51fd\u6570\u65f6\u5931\u8d25", (Throwable)e);
            }
        }
    }

    public CatalogTableStatistics getTableStatistics(ObjectPath tablePath) throws TableNotExistException, CatalogException {
        return null;
    }

    public CatalogColumnStatistics getTableColumnStatistics(ObjectPath tablePath) throws TableNotExistException, CatalogException {
        return null;
    }

    public CatalogTableStatistics getPartitionStatistics(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws PartitionNotExistException, CatalogException {
        return null;
    }

    public CatalogColumnStatistics getPartitionColumnStatistics(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws PartitionNotExistException, CatalogException {
        return null;
    }

    public void alterTableStatistics(ObjectPath tablePath, CatalogTableStatistics tableStatistics, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException {
    }

    public void alterTableColumnStatistics(ObjectPath tablePath, CatalogColumnStatistics columnStatistics, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException, TablePartitionedException {
    }

    public void alterPartitionStatistics(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, CatalogTableStatistics partitionStatistics, boolean ignoreIfNotExists) throws PartitionNotExistException, CatalogException {
    }

    public void alterPartitionColumnStatistics(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, CatalogColumnStatistics columnStatistics, boolean ignoreIfNotExists) throws PartitionNotExistException, CatalogException {
    }

    public boolean databaseExists(String databaseName) throws CatalogException {
        String sql = "select count(1) from meta_db where " + ColsMetaDb.tenantId.getOriColName() + "=? and " + ColsMetaDb.name.getOriColName() + "=?";
        try {
            PreparedStatement ps = this.connection.prepareStatement(sql);
            ps.setLong(1, this.tenantId);
            ps.setString(2, databaseName);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                int count = rs.getInt(1);
                return count != 0;
            }
        }
        catch (SQLException e) {
            throw new CatalogException("\u67e5\u8be2\u8868" + databaseName + "\u5f02\u5e38");
        }
        return false;
    }

    public void createDatabase(String name, CatalogDatabase database, boolean ignoreIfExists) throws DatabaseAlreadyExistException, CatalogException {
        int count = MySqlAssitExt.querySqlCount((Connection)this.connection, (String)String.format("select count(1) from %s where %s='%s' and %s='%s'", "meta_db", ColsMetaDb.tenantId.getOriColName(), this.tenantId, ColsMetaDb.name.getOriColName(), name));
        if (!ignoreIfExists && count > 0) {
            throw new DatabaseAlreadyExistException(this.getName(), name);
        }
        if (count == 0) {
            String desc = database != null && database.getDescription().isPresent() ? (String)database.getDescription().get() : "";
            CatalogAssit.createDb((Connection)this.connection, (String)name, (String)(database == null ? "" : StringUtil.hasNull((String[])new String[]{database.getComment()})), (String)desc, (long)this.tenantId, (long)this.operate);
        }
    }

    public void dropDatabase(String name, boolean ignoreIfNotExists, boolean cascade) throws DatabaseNotExistException, DatabaseNotEmptyException, CatalogException {
    }

    public void alterDatabase(String name, CatalogDatabase newDatabase, boolean ignoreIfNotExists) throws DatabaseNotExistException, CatalogException {
    }

    public Optional<Factory> getFactory() {
        return Optional.empty();
    }
}

