package net.wicp.tams.common.flink.catalog;

import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.StringUtil;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.factories.CatalogFactory;
import org.apache.flink.table.factories.FactoryUtil;

import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

public class MysqlCatalogFactory implements CatalogFactory {

	@Override
	public String factoryIdentifier() {
		return MysqlCatalogFactoryOptions.IDENTIFIER;
	}

	@Override
	public Set<ConfigOption<?>> requiredOptions() {
		final Set<ConfigOption<?>> options = new HashSet<>();
		options.add(MysqlCatalogFactoryOptions.host);
		options.add(MysqlCatalogFactoryOptions.username);
		options.add(MysqlCatalogFactoryOptions.password);
		options.add(MysqlCatalogFactoryOptions.defaultdb);
		options.add(MysqlCatalogFactoryOptions.tenantId);
		options.add(MysqlCatalogFactoryOptions.operate);
		return options;
	}

	@Override
	public Set<ConfigOption<?>> optionalOptions() {
		final Set<ConfigOption<?>> options = new HashSet<>();
		options.add(MysqlCatalogFactoryOptions.port);
		options.add(MysqlCatalogFactoryOptions.url);
		options.add(MysqlCatalogFactoryOptions.urlparam);
		return options;
	}

	@Override
	public Catalog createCatalog(Context context) {
		final FactoryUtil.CatalogFactoryHelper helper = FactoryUtil.createCatalogFactoryHelper(this, context);
		helper.validate();
		final ReadableConfig options = helper.getOptions();
		packageOptions(options);
		return new MysqlCatalog(context.getName(), options.get(MysqlCatalogFactoryOptions.defaultdb), options.get(MysqlCatalogFactoryOptions.tenantId), options.get(MysqlCatalogFactoryOptions.operate));
	}

	private void packageOptions(ReadableConfig options) {
		Properties props = new Properties();
		String propPre = String.format("common.jdbc.datasource.%s.", MysqlCatalogFactoryOptions.IDENTIFIER);
		props.put(propPre + MysqlCatalogFactoryOptions.host.key(), options.get(MysqlCatalogFactoryOptions.host));
		props.put(propPre + MysqlCatalogFactoryOptions.username.key(), options.get(MysqlCatalogFactoryOptions.username));
		props.put(propPre + MysqlCatalogFactoryOptions.password.key(), options.get(MysqlCatalogFactoryOptions.password));
		props.put(propPre + MysqlCatalogFactoryOptions.port.key(), options.get(MysqlCatalogFactoryOptions.port));
		props.put(propPre + MysqlCatalogFactoryOptions.defaultdb.key(), options.get(MysqlCatalogFactoryOptions.defaultdb));
		if(StringUtil.isNotNull(options.get(MysqlCatalogFactoryOptions.url))) {
			props.put(propPre + MysqlCatalogFactoryOptions.url.key(), options.get(MysqlCatalogFactoryOptions.url));
		}
		if(StringUtil.isNotNull(options.get(MysqlCatalogFactoryOptions.urlparam))) {
			props.put(propPre + MysqlCatalogFactoryOptions.urlparam.key(), options.get(MysqlCatalogFactoryOptions.urlparam));
		}
		Conf.overProp(props);
	}
}
