/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.flink.catalog;

import com.alibaba.fastjson.JSONObject;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import net.wicp.tams.common.apiext.CollectionUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.apiext.json.JSONUtil;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.IExcept;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;
import net.wicp.tams.common.flink.catalog.InitSql;
import net.wicp.tams.common.flink.catalog.constant.ColsMetaCol;
import net.wicp.tams.common.flink.catalog.constant.ColsMetaDb;
import net.wicp.tams.common.flink.catalog.constant.ColsMetaFun;
import net.wicp.tams.common.flink.catalog.constant.ColsMetaTb;
import net.wicp.tams.common.flink.module.IUdfEnum;
import net.wicp.tams.common.flink.module.constant.DataTypeEnum;
import net.wicp.tams.common.flink.module.factory.IPackageEnum;
import net.wicp.tams.common.jdbc.DruidAssit;
import net.wicp.tams.common.jdbc.MySqlAssitExt;
import org.apache.commons.collections.CollectionUtils;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.TableNotExistException;
import org.apache.flink.table.catalog.AbstractCatalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogDatabase;
import org.apache.flink.table.catalog.CatalogDatabaseImpl;
import org.apache.flink.table.catalog.CatalogFunction;
import org.apache.flink.table.catalog.CatalogFunctionImpl;
import org.apache.flink.table.catalog.CatalogPartition;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.FunctionLanguage;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.catalog.exceptions.DatabaseAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.DatabaseNotEmptyException;
import org.apache.flink.table.catalog.exceptions.DatabaseNotExistException;
import org.apache.flink.table.catalog.exceptions.FunctionAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.FunctionNotExistException;
import org.apache.flink.table.catalog.exceptions.PartitionAlreadyExistsException;
import org.apache.flink.table.catalog.exceptions.PartitionNotExistException;
import org.apache.flink.table.catalog.exceptions.PartitionSpecInvalidException;
import org.apache.flink.table.catalog.exceptions.TableAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.TableNotPartitionedException;
import org.apache.flink.table.catalog.exceptions.TablePartitionedException;
import org.apache.flink.table.catalog.stats.CatalogColumnStatistics;
import org.apache.flink.table.catalog.stats.CatalogTableStatistics;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.factories.Factory;
import org.apache.flink.table.types.AbstractDataType;

public class MysqlCatalog
extends AbstractCatalog {
    private Connection connection;

    public MysqlCatalog(String catalogName, String defaultDatabase) {
        super(catalogName, defaultDatabase);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void open() throws CatalogException {
        this.connection = DruidAssit.getConnection((String)"tams");
        try {
            MySqlAssitExt.execSql((Connection)this.connection, (String)InitSql.metaColSql);
            MySqlAssitExt.execSql((Connection)this.connection, (String)InitSql.metaDbSql);
            MySqlAssitExt.execSql((Connection)this.connection, (String)InitSql.metaFunSql);
            MySqlAssitExt.execSql((Connection)this.connection, (String)InitSql.metaTbSql);
        }
        catch (Exception e1) {
            throw new ProjectExceptionRuntime((IExcept)ExceptAll.jdbc_exec_fail, "\u521d\u59cb\u5316\u76f8\u5173\u5143\u6570\u636e\u8868\u5931\u8d25", (Throwable)e1);
        }
        try {
            this.createDatabase(this.getDefaultDatabase(), null, true);
        }
        catch (CatalogException | DatabaseAlreadyExistException e1) {
            throw new ProjectExceptionRuntime((IExcept)ExceptAll.jdbc_exec_fail, "\u521d\u59cb\u5316default\u5e93\u5931\u8d25", e1);
        }
        try {
            List<String> listFunctions = this.listFunctions(super.getDefaultDatabase());
            ServiceLoader<IPackageEnum> udffats = ServiceLoader.load(IPackageEnum.class);
            for (IPackageEnum udffat : udffats) {
                try {
                    IUdfEnum[] udfs;
                    for (IUdfEnum udf : udfs = udffat.queryAll()) {
                        if (listFunctions.contains(udf.getFullName())) continue;
                        MySqlAssitExt.execSqlPre((Connection)this.connection, (String)String.format("insert into %s(%s,%s,%s,%s,%s,%s,%s) value(?,?,?,?,?,?,?)", "meta_fun", ColsMetaFun.dbName.getOriColName(), ColsMetaFun.name.getOriColName(), ColsMetaFun.kind.getOriColName(), ColsMetaFun.language.getOriColName(), ColsMetaFun.identifier.getOriColName(), ColsMetaFun.description.getOriColName(), ColsMetaFun.detailDescription.getOriColName()), (Object[])new Object[]{super.getDefaultDatabase(), udf.getFullName(), udf.getKind().name(), udf.getLanguage().name(), udf.getClassz().getName(), udf.getDescription(), udf.getDetailDescription()});
                    }
                }
                catch (Exception e) {
                    throw new ProjectExceptionRuntime((IExcept)ExceptAll.flink_udf_errorformate, "\u9700\u8981\u5b9a\u4e49\u5b9e\u73b0IUdfEnum\u63a5\u53e3\u7684\u679a\u4e3e\u7c7b", (Throwable)e);
                    return;
                }
            }
        }
        catch (DatabaseNotExistException e) {
            throw new CatalogException((Throwable)e);
        }
    }

    public void close() throws CatalogException {
        DruidAssit.close((Connection)this.connection);
    }

    public List<String> listDatabases() throws CatalogException {
        List querySqlMap = MySqlAssitExt.querySqlMap((Connection)this.connection, (String)"select name from meta_db", (boolean)false);
        List dbs = CollectionUtil.getColFromObj((List)querySqlMap, (String)"name");
        return dbs;
    }

    public CatalogDatabase getDatabase(String databaseName) throws DatabaseNotExistException, CatalogException {
        ResultSet rs = MySqlAssitExt.querySql((Connection)this.connection, (String)String.format("select * from %s where %s='%s'", "meta_db", ColsMetaDb.name.getOriColName(), databaseName));
        try {
            if (rs.next()) {
                Map properties = new HashMap();
                String propertiesStr = rs.getString(ColsMetaDb.properties.getOriColName());
                if (StringUtil.isNull((Object)rs)) {
                    properties = JSONUtil.jsonToMapStr((JSONObject)JSONObject.parseObject((String)propertiesStr));
                }
                CatalogDatabaseImpl retobj = new CatalogDatabaseImpl(properties, rs.getString(ColsMetaDb.comment.getOriColName()));
                return retobj;
            }
        }
        catch (SQLException e) {
            throw new ProjectExceptionRuntime((IExcept)ExceptAll.duckula_nodata, "\u67e5\u6570\u636e\u5e93" + databaseName + "\u5931\u8d25", (Throwable)e);
        }
        throw new DatabaseNotExistException("tams", databaseName);
    }

    public List<String> listTables(String databaseName) throws DatabaseNotExistException, CatalogException {
        List<String> colFromObj = this.queryTableOrViewByDb(databaseName, CatalogBaseTable.TableKind.TABLE);
        return colFromObj;
    }

    private List<String> queryTableOrViewByDb(String databaseName, CatalogBaseTable.TableKind kind) {
        List querySqlMap = new ArrayList();
        try {
            querySqlMap = MySqlAssitExt.querySqlMapPre((Connection)this.connection, (String)String.format("select %s from  %s where %s=? and %s=?", ColsMetaTb.name.getOriColName(), "meta_tb", ColsMetaTb.dbName.getOriColName(), ColsMetaTb.kind.getOriColName()), (boolean)false, (Object[])new Object[]{databaseName, kind});
        }
        catch (Exception e) {
            throw new CatalogException("\u901a\u8fc7\u5e93\u67e5\u8be2\u8868\u5931\u8d25", (Throwable)e);
        }
        List colFromObj = CollectionUtil.getColFromObj(querySqlMap, (String)ColsMetaTb.name.getOriColName());
        return colFromObj;
    }

    public List<String> listViews(String databaseName) throws DatabaseNotExistException, CatalogException {
        List<String> colFromObj = this.queryTableOrViewByDb(databaseName, CatalogBaseTable.TableKind.VIEW);
        return colFromObj;
    }

    public CatalogBaseTable getTable(ObjectPath tablePath) throws TableNotExistException, CatalogException {
        Map<String, String> tableinfo = this.getTableInfo(tablePath);
        Schema.Builder builder = Schema.newBuilder();
        String comment = tableinfo.get(ColsMetaTb.comment.getOriColName());
        List<String> partitionKeys = Arrays.asList(tableinfo.get(ColsMetaTb.partitionkeys.getOriColName()).split(","));
        String optionsStr = tableinfo.get(ColsMetaTb.options.getOriColName());
        Map options = null;
        if (StringUtil.isNotNull((Object)optionsStr)) {
            JSONObject jsonObject = JSONObject.parseObject((String)optionsStr);
            options = JSONUtil.jsonToMapStr((JSONObject)jsonObject);
        }
        builder.primaryKey(tableinfo.get(ColsMetaTb.keyCol.getOriColName()).split(","));
        List<Object> queryCols = new ArrayList();
        try {
            queryCols = this.queryCols(Long.parseLong(tableinfo.get(ColsMetaTb.id.getOriColName())));
        }
        catch (Exception e) {
            throw new CatalogException("\u67e5\u8be2cols\u5931\u8d25");
        }
        for (Map map : queryCols) {
            String sqlexpression;
            String colName = (String)map.get(ColsMetaCol.name.getOriColName());
            String watermarkExpression = (String)map.get(ColsMetaCol.watermarkExpression.getOriColName());
            if (StringUtil.isNotNull((Object)watermarkExpression)) {
                builder.watermark(colName, watermarkExpression);
            }
            if (StringUtil.isNotNull((Object)(sqlexpression = (String)map.get(ColsMetaCol.sqlexpression.getOriColName())))) {
                builder.columnByExpression(colName, sqlexpression);
                continue;
            }
            DataTypeEnum dataTypeEnum = DataTypeEnum.find((String)((String)map.get(ColsMetaCol.type.getOriColName())));
            if (dataTypeEnum == null || dataTypeEnum.getDataType() == null) {
                throw new CatalogException("\u6b64\u7c7b\u578b[" + (String)map.get(ColsMetaCol.type.getOriColName()) + "]\u8fd8\u4e0d\u652f\u6301\uff0c\u9700\u8981\u8fde\u63a5\u76f8\u5173\u4eba\u5458\u3002");
            }
            builder.column(colName, (AbstractDataType)dataTypeEnum.getDataType());
        }
        CatalogTable retobj = CatalogTable.of((Schema)builder.build(), (String)comment, partitionKeys, (Map)options);
        return retobj;
    }

    private Map<String, String> getTableInfo(ObjectPath tablePath) {
        Map<String, String> tableinfo = null;
        try {
            tableinfo = this.queryTable(tablePath);
        }
        catch (Exception e) {
            throw new CatalogException("\u67e5\u8be2table\u5931\u8d25");
        }
        if (tableinfo == null) {
            throw new TableNotExistException("tams", tablePath.getObjectName());
        }
        return tableinfo;
    }

    public boolean tableExists(ObjectPath tablePath) throws CatalogException {
        try {
            CatalogBaseTable baseTable = this.getTable(tablePath);
            return baseTable != null;
        }
        catch (TableNotExistException e) {
            return false;
        }
    }

    public void dropTable(ObjectPath tablePath, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException {
        Map<String, String> queryTable = null;
        try {
            queryTable = this.queryTable(tablePath);
        }
        catch (SQLException e) {
            throw new CatalogException("\u67e5\u8868\u5931\u8d25", (Throwable)e);
        }
        if (ignoreIfNotExists && queryTable == null) {
            throw new TableNotExistException("tams", tablePath.getObjectName());
        }
        if (queryTable != null) {
            long id = Long.parseLong(queryTable.get(ColsMetaTb.id.getOriColName()));
            MySqlAssitExt.execSql((Connection)this.connection, (String)String.format("delete from %s where %s=%s", "meta_tb", ColsMetaTb.id.getOriColName(), id));
            MySqlAssitExt.execSql((Connection)this.connection, (String)String.format("delete from %s where %s=%s", "meta_col", ColsMetaCol.tbId.getOriColName(), id));
        }
    }

    public void renameTable(ObjectPath tablePath, String newTableName, boolean ignoreIfNotExists) throws TableNotExistException, TableAlreadyExistException, CatalogException {
    }

    public void createTable(ObjectPath tablePath, CatalogBaseTable table, boolean ignoreIfExists) throws TableAlreadyExistException, DatabaseNotExistException, CatalogException {
        CatalogBaseTable baseTable;
        this.validDb(tablePath);
        try {
            baseTable = this.getTable(tablePath);
        }
        catch (TableNotExistException e) {
            baseTable = null;
        }
        if (!ignoreIfExists && baseTable != null) {
            throw new TableAlreadyExistException("tams", tablePath);
        }
        if (baseTable == null) {
            try {
                CatalogTable tableTrue;
                PreparedStatement insertTablePre = this.connection.prepareStatement(String.format("insert %s(%s,%s,%s,%s,%s,%s,%s) value(?,?,?,?,?,?,?)", "meta_tb", ColsMetaTb.dbName.getOriColName(), ColsMetaTb.name.getOriColName(), ColsMetaTb.kind.getOriColName(), ColsMetaTb.keyCol.getOriColName(), ColsMetaTb.comment.getOriColName(), ColsMetaTb.partitionkeys.getOriColName(), ColsMetaTb.options.getOriColName()));
                String partitionkeys = "";
                if (table.getTableKind() == CatalogBaseTable.TableKind.TABLE && CollectionUtils.isNotEmpty((Collection)(tableTrue = (CatalogTable)table).getPartitionKeys())) {
                    partitionkeys = CollectionUtil.listJoin((List)tableTrue.getPartitionKeys(), (String)",");
                }
                String keyColStr = "";
                Optional primaryKey = table.getUnresolvedSchema().getPrimaryKey();
                if (primaryKey.isPresent()) {
                    keyColStr = CollectionUtil.listJoin((List)((Schema.UnresolvedPrimaryKey)primaryKey.get()).getColumnNames(), (String)",");
                }
                String options = JSONUtil.getJsonForMap((Map)table.getOptions());
                MySqlAssitExt.setPreParam((PreparedStatement)insertTablePre, (Object[])new Object[]{tablePath.getDatabaseName(), tablePath.getObjectName(), table.getTableKind().name(), keyColStr, StringUtil.hasNull((String[])new String[]{table.getComment()}), partitionkeys, options});
                insertTablePre.execute();
                Map<String, String> queryTable = this.queryTable(tablePath);
                long tbid = Long.parseLong(queryTable.get(ColsMetaTb.id.getOriColName()));
                PreparedStatement insertColPre = this.connection.prepareStatement(String.format("insert %s(%s,%s,%s,%s,%s,%s,%s) value(?,?,?,?,?,?,?)", "meta_col", ColsMetaCol.dbName.getOriColName(), ColsMetaCol.tbId.getOriColName(), ColsMetaCol.name.getOriColName(), ColsMetaCol.type.getOriColName(), ColsMetaCol.sqlexpression.getOriColName(), ColsMetaCol.watermarkRowTimeAttribute.getOriColName(), ColsMetaCol.watermarkExpression.getOriColName()));
                List columns = table.getUnresolvedSchema().getColumns();
                for (Schema.UnresolvedColumn column : columns) {
                    String type = "";
                    String sqlexpression = "";
                    String watermarkRowTimeAttribute = "";
                    String watermarkExpression = "";
                    if (column instanceof Schema.UnresolvedPhysicalColumn) {
                        Schema.UnresolvedPhysicalColumn temp = (Schema.UnresolvedPhysicalColumn)column;
                        type = temp.getDataType().toString();
                    }
                    MySqlAssitExt.setPreParam((PreparedStatement)insertColPre, (Object[])new Object[]{tablePath.getDatabaseName(), tbid, column.getName(), type, sqlexpression, watermarkRowTimeAttribute, watermarkExpression});
                    insertColPre.execute();
                }
            }
            catch (SQLException e) {
                throw new CatalogException("\u521b\u5efa\u8868[" + tablePath.getObjectName() + "]\u65f6SQL\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    private void validDb(ObjectPath tablePath) throws DatabaseNotExistException {
        CatalogDatabase database;
        try {
            database = this.getDatabase(tablePath.getDatabaseName());
        }
        catch (DatabaseNotExistException e) {
            database = null;
        }
        if (database == null) {
            throw new DatabaseNotExistException("tams", tablePath.getDatabaseName());
        }
    }

    private Map<String, String> queryTable(ObjectPath tablePath) throws SQLException {
        List querySqlMap = MySqlAssitExt.querySqlMapPre((Connection)this.connection, (String)String.format("select * from  %s where %s=? and %s=?", "meta_tb", ColsMetaTb.dbName.getOriColName(), ColsMetaTb.name.getOriColName()), (boolean)false, (Object[])new Object[]{tablePath.getDatabaseName(), tablePath.getObjectName()});
        if (CollectionUtils.isNotEmpty((Collection)querySqlMap)) {
            return (Map)querySqlMap.get(0);
        }
        return null;
    }

    private Map<String, String> queryFun(ObjectPath functionPath) throws SQLException {
        List querySqlMap = MySqlAssitExt.querySqlMapPre((Connection)this.connection, (String)String.format("select * from %s where %s=? and  %s=?", "meta_fun", ColsMetaFun.dbName.getOriColName(), ColsMetaFun.name.getOriColName()), (boolean)false, (Object[])new Object[]{functionPath.getDatabaseName(), functionPath.getObjectName()});
        if (CollectionUtils.isNotEmpty((Collection)querySqlMap)) {
            return (Map)querySqlMap.get(0);
        }
        return null;
    }

    private List<Map<String, String>> queryCols(Long tableId) throws SQLException {
        List querySqlMap = MySqlAssitExt.querySqlMapPre((Connection)this.connection, (String)String.format("select * from  %s where %s=?", "meta_col", ColsMetaCol.tbId.getOriColName()), (boolean)false, (Object[])new Object[]{tableId});
        return querySqlMap;
    }

    public void alterTable(ObjectPath tablePath, CatalogBaseTable newTable, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException {
        this.dropTable(tablePath, true);
        try {
            this.createTable(tablePath, newTable, false);
        }
        catch (DatabaseNotExistException | TableAlreadyExistException e) {
            throw new CatalogException(e);
        }
    }

    public List<CatalogPartitionSpec> listPartitions(ObjectPath tablePath) throws TableNotExistException, TableNotPartitionedException, CatalogException {
        return null;
    }

    public List<CatalogPartitionSpec> listPartitions(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws TableNotExistException, TableNotPartitionedException, CatalogException {
        return null;
    }

    public List<CatalogPartitionSpec> listPartitionsByFilter(ObjectPath tablePath, List<Expression> filters) throws TableNotExistException, TableNotPartitionedException, CatalogException {
        return null;
    }

    public CatalogPartition getPartition(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws PartitionNotExistException, CatalogException {
        return null;
    }

    public boolean partitionExists(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws CatalogException {
        return false;
    }

    public void createPartition(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, CatalogPartition partition, boolean ignoreIfExists) throws TableNotExistException, TableNotPartitionedException, PartitionSpecInvalidException, PartitionAlreadyExistsException, CatalogException {
    }

    public void dropPartition(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, boolean ignoreIfNotExists) throws PartitionNotExistException, CatalogException {
    }

    public void alterPartition(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, CatalogPartition newPartition, boolean ignoreIfNotExists) throws PartitionNotExistException, CatalogException {
    }

    public List<String> listFunctions(String dbName) throws DatabaseNotExistException, CatalogException {
        try {
            List funs = MySqlAssitExt.querySqlMapPre((Connection)this.connection, (String)String.format("select %s from %s where %s=?", ColsMetaFun.name.getOriColName(), "meta_fun", ColsMetaFun.dbName.getOriColName()), (boolean)false, (Object[])new Object[]{dbName});
            Set cols = CollectionUtil.getColSetFromObj((List)funs, (String)ColsMetaFun.name.getOriColName());
            return new ArrayList<String>(cols);
        }
        catch (SQLException e) {
            throw new CatalogException("\u67e5\u8be2\u51fd\u6570\u5931\u8d25", (Throwable)e);
        }
    }

    public CatalogFunction getFunction(ObjectPath functionPath) throws FunctionNotExistException, CatalogException {
        Map<String, String> funinfo = null;
        try {
            funinfo = this.queryFun(functionPath);
        }
        catch (Exception e) {
            throw new CatalogException("\u67e5\u8be2fun\u5931\u8d25");
        }
        if (funinfo == null) {
            throw new FunctionNotExistException("tams", functionPath);
        }
        CatalogFunctionImpl retFun = new CatalogFunctionImpl(funinfo.get(ColsMetaFun.identifier.getOriColName()), FunctionLanguage.valueOf((String)funinfo.get(ColsMetaFun.language.getOriColName())));
        return retFun;
    }

    public boolean functionExists(ObjectPath functionPath) throws CatalogException {
        try {
            CatalogFunction function = this.getFunction(functionPath);
            return function != null;
        }
        catch (FunctionNotExistException e) {
            return false;
        }
    }

    public void createFunction(ObjectPath functionPath, CatalogFunction function, boolean ignoreIfExists) throws FunctionAlreadyExistException, DatabaseNotExistException, CatalogException {
        CatalogFunction baseFun;
        this.validDb(functionPath);
        try {
            baseFun = this.getFunction(functionPath);
        }
        catch (FunctionNotExistException e) {
            baseFun = null;
        }
        if (!ignoreIfExists && baseFun != null) {
            throw new FunctionAlreadyExistException("tams", functionPath);
        }
        if (baseFun == null) {
            try {
                String language = function.getFunctionLanguage() == null ? FunctionLanguage.JAVA.name() : function.getFunctionLanguage().name();
                String desc = function.getDescription() != null && function.getDescription().isPresent() ? (String)function.getDescription().get() : "";
                String descDetail = function.getDetailedDescription() != null && function.getDetailedDescription().isPresent() ? (String)function.getDetailedDescription().get() : "";
                MySqlAssitExt.execSqlPre((Connection)this.connection, (String)String.format("insert into %s(%s,%s,%s,%s,%s,%s) value(?,?,?,?,?,?)", "meta_fun", ColsMetaFun.dbName.getOriColName(), ColsMetaFun.name.getOriColName(), ColsMetaFun.language.getOriColName(), ColsMetaFun.identifier.getOriColName(), ColsMetaFun.description.getOriColName(), ColsMetaFun.detailDescription.getOriColName()), (Object[])new Object[]{functionPath.getDatabaseName(), functionPath.getObjectName(), language, function.getClassName(), desc, descDetail});
            }
            catch (Exception e) {
                throw new CatalogException("\u521b\u5efa\u51fd\u6570\u65f6\u5931\u8d25", (Throwable)e);
            }
        }
    }

    public void alterFunction(ObjectPath functionPath, CatalogFunction newFunction, boolean ignoreIfNotExists) throws FunctionNotExistException, CatalogException {
        this.dropFunction(functionPath, ignoreIfNotExists);
        try {
            this.createFunction(functionPath, newFunction, ignoreIfNotExists);
        }
        catch (FunctionAlreadyExistException e) {
            throw new CatalogException((Throwable)e);
        }
        catch (DatabaseNotExistException e) {
            throw new CatalogException((Throwable)e);
        }
    }

    public void dropFunction(ObjectPath functionPath, boolean ignoreIfNotExists) throws FunctionNotExistException, CatalogException {
        Map<String, String> funinfo = null;
        try {
            funinfo = this.queryFun(functionPath);
        }
        catch (Exception e) {
            throw new CatalogException("\u67e5\u8be2fun\u5931\u8d25");
        }
        if (!ignoreIfNotExists && funinfo == null) {
            throw new FunctionNotExistException("tams", functionPath);
        }
        if (funinfo != null) {
            try {
                MySqlAssitExt.execSqlPre((Connection)this.connection, (String)String.format("delete from %s where %s=? ", "meta_fun", ColsMetaFun.id.getOriColName()), (Object[])new Object[]{Long.parseLong(funinfo.get(ColsMetaFun.id.getOriColName()))});
            }
            catch (Exception e) {
                throw new CatalogException("\u5220\u9664\u51fd\u6570\u65f6\u5931\u8d25", (Throwable)e);
            }
        }
    }

    public CatalogTableStatistics getTableStatistics(ObjectPath tablePath) throws TableNotExistException, CatalogException {
        return null;
    }

    public CatalogColumnStatistics getTableColumnStatistics(ObjectPath tablePath) throws TableNotExistException, CatalogException {
        return null;
    }

    public CatalogTableStatistics getPartitionStatistics(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws PartitionNotExistException, CatalogException {
        return null;
    }

    public CatalogColumnStatistics getPartitionColumnStatistics(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws PartitionNotExistException, CatalogException {
        return null;
    }

    public void alterTableStatistics(ObjectPath tablePath, CatalogTableStatistics tableStatistics, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException {
    }

    public void alterTableColumnStatistics(ObjectPath tablePath, CatalogColumnStatistics columnStatistics, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException, TablePartitionedException {
    }

    public void alterPartitionStatistics(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, CatalogTableStatistics partitionStatistics, boolean ignoreIfNotExists) throws PartitionNotExistException, CatalogException {
    }

    public void alterPartitionColumnStatistics(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, CatalogColumnStatistics columnStatistics, boolean ignoreIfNotExists) throws PartitionNotExistException, CatalogException {
    }

    public boolean databaseExists(String databaseName) throws CatalogException {
        String sql = "select count(1) from meta_db where " + ColsMetaDb.name.getOriColName() + "=?";
        try {
            PreparedStatement ps = this.connection.prepareStatement(sql);
            ps.setString(1, databaseName);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                int count = rs.getInt(1);
                return count != 0;
            }
        }
        catch (SQLException e) {
            throw new CatalogException("\u67e5\u8be2\u8868" + databaseName + "\u5f02\u5e38");
        }
        return false;
    }

    public void createDatabase(String name, CatalogDatabase database, boolean ignoreIfExists) throws DatabaseAlreadyExistException, CatalogException {
        int count = MySqlAssitExt.querySqlCount((Connection)this.connection, (String)String.format("select count(1) from %s where %s='%s'", "meta_db", ColsMetaDb.name.getOriColName(), name));
        if (!ignoreIfExists && count > 0) {
            throw new DatabaseAlreadyExistException("tams", name);
        }
        if (count == 0) {
            String desc = database != null && database.getDescription().isPresent() ? (String)database.getDescription().get() : "";
            MySqlAssitExt.execSql((Connection)this.connection, (String)String.format("insert into %s(name,comment,description) values('%s','%s','%s')", "meta_db", name, database == null ? "" : StringUtil.hasNull((String[])new String[]{database.getComment()}), desc));
        }
    }

    public void dropDatabase(String name, boolean ignoreIfNotExists, boolean cascade) throws DatabaseNotExistException, DatabaseNotEmptyException, CatalogException {
    }

    public void alterDatabase(String name, CatalogDatabase newDatabase, boolean ignoreIfNotExists) throws DatabaseNotExistException, CatalogException {
    }

    public Optional<Factory> getFactory() {
        return Optional.empty();
    }
}

