package net.wicp.tams.common.flink.catalog;

import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;

public abstract class MysqlCatalogFactoryOptions {
	public static final String IDENTIFIER = "tams";

	public static final ConfigOption<String> host = ConfigOptions.key("host").stringType().noDefaultValue();
	public static final ConfigOption<Integer> port = ConfigOptions.key("port").intType().defaultValue(3306);
	public static final ConfigOption<String> defaultdb = ConfigOptions.key("defaultdb").stringType().noDefaultValue();

	public static final ConfigOption<String> username = ConfigOptions.key("username").stringType().noDefaultValue();
	public static final ConfigOption<String> password = ConfigOptions.key("password").stringType().noDefaultValue();

	public static final ConfigOption<String> url = ConfigOptions.key("url").stringType().noDefaultValue();
	public static final ConfigOption<String> urlparam = ConfigOptions.key("urlparam").stringType().noDefaultValue();

}
