package net.wicp.tams.common.flink.catalog;

/**
 * 初始化存放元数据的表结构
 * 
 * @author Andy
 *
 */
public abstract class InitSql {
	public static String metaColSql = "CREATE TABLE  IF NOT EXISTS `meta_col`  (  `id` bigint(0) NOT NULL AUTO_INCREMENT COMMENT 'id',  `db_name` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '库id,冗余',  `tb_id` bigint(0) NULL DEFAULT NULL COMMENT '表id',  `name` varchar(150)  NULL DEFAULT NULL COMMENT '库名',  `type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '列类型',  `sqlExpression` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,  `watermark_row_time_attribute` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,  `watermark_expression` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,  PRIMARY KEY (`id`) USING BTREE)";
	public static String metaDbSql = "CREATE TABLE IF NOT EXISTS `meta_db`  (  `name` varchar(150)  NOT NULL COMMENT '库名',  `comment` varchar(2000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',  `description` varchar(2000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '库描述',  `properties` varchar(2000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '属性，json格式',  PRIMARY KEY (`name`) USING BTREE)";
	public static String metaFunSql = "CREATE TABLE IF NOT EXISTS `meta_fun`  (  `id` bigint(0) NOT NULL AUTO_INCREMENT COMMENT 'id',  `db_name` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '库id,冗余',  `name` varchar(150)  NOT NULL COMMENT '函数名',  `kind` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'FunctionKind枚举定义',  `language` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT 'FunctionLanguage类',  `identifier` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '如果 language tag 是 JAVA 或者 SCALA ，则 identifier 是 UDF 实现类的全限定名，如果 language tag 是 PYTHON ，则 identifier 是 UDF 对象的全限定名，例如 pyflink.table.tests.test_udf.add',  `description` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '简要备注',  `detail_description` varchar(2000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '详细介绍',  PRIMARY KEY (`id`) USING BTREE,  UNIQUE INDEX `db_tb_UNIQUE`(`db_name`, `name`) USING BTREE,  INDEX `db_tb`(`db_name`, `name`) USING BTREE)";
	public static String metaTbSql = "CREATE TABLE IF NOT EXISTS `meta_tb`  (  `id` bigint(0) NOT NULL AUTO_INCREMENT COMMENT 'id',  `db_name` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '库id,冗余',  `name` varchar(150)  NOT NULL COMMENT '库名',  `kind` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT 'table或view',  `key_col` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '主键',  `comment` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',  `partitionKeys` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '分区键',  `options` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '配置项',  PRIMARY KEY (`id`) USING BTREE,  UNIQUE INDEX `db_tb_UNIQUE`(`db_name`, `name`) USING BTREE,  INDEX `db_tb`(`db_name`, `name`) USING BTREE)";
}
