/*
  自动创建catalog表
*/
-- ----------------------------
-- 字段
-- ----------------------------
CREATE TABLE IF NOT EXISTS `meta_col`  (
  `id` bigint(20)  AUTO_INCREMENT COMMENT 'id',
  `db_name` varchar(255)   COMMENT '库id,冗余',
  `tb_logic_id` bigint(20)  COMMENT '表id',
  `name` varchar(255)   COMMENT '库名',
  `type` varchar(255)   COMMENT '列类型',
  `data_precision` int(11)  COMMENT 'precision是关键字',
  `data_scale` int(11) ,
  `not_null` varchar(10)   COMMENT '是否为空，yes:不为空，no:可以为空',
  `sqlExpression` varchar(255)  ,
  `watermark_row_time_attribute` varchar(255)  ,
  `watermark_expression` varchar(255)  ,
  `create_time` datetime(0)  COMMENT '创建时间',
  `update_time` datetime(0)  ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  `create_by` bigint(20)  COMMENT '创建人id',
  `update_by` bigint(20)  COMMENT '修改人id',
  `tenant_id` bigint(20) UNSIGNED  COMMENT '租户id',
  `is_metadata` varchar(10)   COMMENT 'yes：是meta列,no或空:不是meta列',
  `metadata_name` varchar(100)   COMMENT 'metadat数据来源',
  `is_virtual` varchar(10)   COMMENT '是否为虚列，null:不是metadata列,yes:虚列 no:不为虚列',
  `comment` varchar(255) NULL COMMENT '字段备注',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `db_tb_unique`(`tenant_id`, `db_name`, `tb_logic_id`, `name`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci;

-- ----------------------------
-- 数据库
-- ----------------------------
CREATE TABLE IF NOT EXISTS `meta_db`  (
  `name` varchar(150)  NOT NULL COMMENT '库名',
  `catalog_name` varchar(20)  NOT NULL COMMENT 'mycatalog和tscatalog',
  `tenant_id` bigint(20) UNSIGNED NOT NULL COMMENT '租户id',
  `comment` varchar(2000)   COMMENT '备注',
  `description` varchar(2000)   COMMENT '库描述',
  `properties` varchar(2000)   COMMENT '属性，json格式',
  `create_time` datetime(0)  COMMENT '创建时间',
  `update_time` datetime(0)  ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  `create_by` bigint(20)  COMMENT '创建人id',
  `update_by` bigint(20)  COMMENT '修改人id',
  PRIMARY KEY (`name`, `catalog_name`, `tenant_id`) USING BTREE,
  UNIQUE INDEX `db_tb_unique`(`tenant_id`, `name`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci;

-- ----------------------------
-- 函数
-- ----------------------------
CREATE TABLE IF NOT EXISTS `meta_fun`  (
  `id` bigint(20) AUTO_INCREMENT COMMENT 'id',
  `db_name` varchar(150)  COMMENT '库id,冗余',
  `name` varchar(150)  COMMENT '函数名',
  `module_id` bigint(20) COMMENT '来自哪个模块',
  `kind` varchar(10)  COMMENT 'FunctionKind枚举定义',
  `language` varchar(255)  COMMENT 'FunctionLanguage类',
  `identifier` varchar(255)  COMMENT '如果 language tag 是 JAVA 或者 SCALA ，则 identifier 是 UDF 实现类的全限定名，如果 language tag 是 PYTHON ，则 identifier 是 UDF 对象的全限定名，例如 pyflink.table.tests.test_udf.add',
  `description` varchar(255)  COMMENT '简要备注',
  `detail_description` varchar(2000)  COMMENT '详细介绍',
  `create_time` datetime(0) COMMENT '创建时间',
  `update_time` datetime(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  `create_by` bigint(20) COMMENT '创建人id',
  `update_by` bigint(20) COMMENT '修改人id',
  `tenant_id` bigint(20) UNSIGNED COMMENT '租户id',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `db_tb_unique`(`tenant_id`, `db_name`, `name`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci;

-- ----------------------------
-- 模块
-- ----------------------------
CREATE TABLE IF NOT EXISTS `meta_module`  (
  `id` bigint(20) AUTO_INCREMENT COMMENT 'id',
  `db_name` varchar(150)  COMMENT '库id,冗余',
  `name` varchar(150)  COMMENT '模块名',
  `module_path` varchar(255)  COMMENT '模块上传的路径',
  `comment` varchar(255)  COMMENT '备注',
  `catalog_id` bigint(20) COMMENT '可以导入到哪个catalog（管理系统ops维护）',
  `create_time` datetime(0) COMMENT '创建时间',
  `update_time` datetime(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  `create_by` bigint(20) COMMENT '创建人id',
  `update_by` bigint(20) COMMENT '修改人id',
  `tenant_id` bigint(20) UNSIGNED COMMENT '租户id',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `db_tb_unique`(`tenant_id`, `db_name`, `name`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci;

-- ----------------------------
-- 物理表
-- ----------------------------
CREATE TABLE IF NOT EXISTS `meta_tb`  (
  `id` bigint(20) AUTO_INCREMENT,
  `db_name` varchar(150)  COMMENT '冗余，库id',
  `kind` varchar(10)  COMMENT '冗余，table或view',
  `name` varchar(150)  COMMENT '库名',
  `tb_logic_id` bigint(20) COMMENT '表id',
  `middleware` varchar(20)  COMMENT '中间件类型,mysql，kafka等',
  `key_col` varchar(255)   COMMENT '主键(可覆盖逻辑表)',
  `partitionKeys` varchar(255)   COMMENT '分区键(可覆盖逻辑表)',
  `opt` varchar(2000)  COMMENT 'json对象，用于存储除middleware外的其它的配置项',
  `with_options` varchar(2000)  COMMENT '配置项，json对象',
  `catalog_name` varchar(20) NULL COMMENT 'mycatalog和tscatalog',
  `tag` varchar(255)  COMMENT '标识，用于放来哪个业务系统的id，如 ops',
  `remark` varchar(2000)  COMMENT '物理表描述',
  `create_time` datetime(0) COMMENT '创建时间',
  `update_time` datetime(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  `create_by` bigint(20) COMMENT '创建人id',
  `update_by` bigint(20) COMMENT '修改人id',
  `tenant_id` bigint(20) UNSIGNED COMMENT '租户id',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `db_tb_unique`(`tenant_id`, `db_name`, `name`) USING BTREE,
  INDEX `db_tb_query`(`tenant_id`, `db_name`, `name`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci;

-- ----------------------------
-- 逻辑表
-- ----------------------------
CREATE TABLE IF NOT EXISTS `meta_tb_logic`  (
  `id` bigint(20) AUTO_INCREMENT COMMENT 'id',
  `db_name` varchar(150)  COMMENT '库id,冗余',
  `name` varchar(150)  COMMENT '库名',
  `kind` varchar(10)  COMMENT 'table或view',
  `key_col` varchar(255)  COMMENT '主键',
  `comment` varchar(255)  COMMENT '备注',
  `partitionKeys` varchar(255)  COMMENT '分区键',
  `create_time` datetime(0) COMMENT '创建时间',
  `update_time` datetime(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  `create_by` bigint(20) COMMENT '创建人id',
  `update_by` bigint(20) COMMENT '修改人id',
  `tenant_id` bigint(20) UNSIGNED COMMENT '租户id',
  `catalog_name` varchar(20)  COMMENT 'mycatalog和tscatalog',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `db_tb_unique`(`tenant_id`, `db_name`, `name`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci;

-- ----------------------------
-- 视图
-- ----------------------------
CREATE TABLE IF NOT EXISTS `meta_view`  (
  `id` bigint(20) AUTO_INCREMENT,
  `db_name` varchar(150)  COMMENT '冗余，库id',
  `kind` varchar(10)  COMMENT '冗余，table或view',
  `name` varchar(150)  COMMENT '库名',
  `original_query` varchar(5000)  COMMENT '原始query语句',
  `expanded_query` varchar(5000)  COMMENT '扩展query语句',
  `with_options` varchar(600)  COMMENT '配置项，json对象',
  `columns` varchar(5000)  COMMENT '视图的字段，json对象，key：类型、precision、scale、isNull',
  `remark` varchar(100)  COMMENT '视图备注',
  `create_time` datetime(0) COMMENT '创建时间',
  `update_time` datetime(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  `create_by` bigint(20) COMMENT '创建人id',
  `update_by` bigint(20) COMMENT '修改人id',
  `tenant_id` bigint(20) UNSIGNED COMMENT '租户id',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `db_tb_unique`(`tenant_id`, `db_name`, `name`) USING BTREE,
  INDEX `db_tb_query`(`tenant_id`, `db_name`, `name`) USING BTREE
) ENGINE = InnoDB  CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci;

-- ----------------------------
-- 血缘
-- ----------------------------
CREATE TABLE IF NOT EXISTS `meta_lineage`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT 'id',
  `source_col_id` bigint(20)  COMMENT '源字段id',
  `source_tb_id` bigint(20)  COMMENT '源表id',
  `source_tb_logic_id` bigint(20)  COMMENT '源逻辑表id',
  `source_catalog` varchar(110)   COMMENT '源catalog',
  `source_database` varchar(255)   COMMENT '源库',
  `source_table` varchar(255)   COMMENT '源表',
  `source_column` varchar(255)   COMMENT '源字段',
  `target_col_id` bigint(20)  COMMENT '目标字段id',
  `target_tb_id` bigint(20)  COMMENT '目标表id',
  `target_tb_logic_id` bigint(20)  COMMENT '目标逻辑表id',
  `target_catalog` varchar(110)   COMMENT '目标catalog',
  `target_database` varchar(255)   COMMENT '目标库',
  `target_table` varchar(255)   COMMENT '目标表',
  `target_column` varchar(255)   COMMENT '目标字段',
  `transform` varchar(255)   COMMENT '转换表达式',
  `rs_type` varchar(20)   COMMENT '关系类型，flinksql：sql任务   fun:函数  ,view：视图',
  `rs_obj_id` bigint(20)  COMMENT '关系id',
  `rs_obj_name` varchar(255)   COMMENT '关联对象名称',
  `valid_time` datetime(0) NULL COMMENT '用于验证的时间，小于当前时间的血缘是起作用的。',
  `create_time` datetime(0)  COMMENT '创建时间',
  `update_time` datetime(0)  ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  `create_by` bigint(20)  COMMENT '创建人id',
  `update_by` bigint(20)  COMMENT '修改人id',
  `tenant_id` bigint(20) UNSIGNED NOT NULL COMMENT '租户id',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `db_tb_unique`(`tenant_id`, `source_catalog`, `source_database`) USING BTREE
) ENGINE = InnoDB  CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '血缘关系';
