/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.flink.paimon;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.apiext.jdbc.MySqlColBean;
import net.wicp.tams.common.apiext.jdbc.MySqlTbBean;
import net.wicp.tams.common.constant.FieldFormart;
import net.wicp.tams.common.constant.dic.YesOrNo;
import net.wicp.tams.common.flink.common.constant.FlinkTypeEnum;
import net.wicp.tams.common.flink.common.constant.db.ColsMetaCol;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.paimon.flink.LogicalTypeConversion;
import org.apache.paimon.schema.Schema;
import org.apache.paimon.types.DataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PaimonFlinkAssit {
    private static final Logger log = LoggerFactory.getLogger(PaimonFlinkAssit.class);

    public static org.apache.paimon.schema.Schema fromCatalogTable(CatalogTable catalogTable) {
        Schema.Builder schemaBuilder = org.apache.paimon.schema.Schema.newBuilder();
        Schema schemaOri = catalogTable.getUnresolvedSchema();
        List keyNameList = ((Schema.UnresolvedPrimaryKey)schemaOri.getPrimaryKey().get()).getColumnNames();
        List partitionkeys = catalogTable.getPartitionKeys();
        List columns = schemaOri.getColumns();
        schemaBuilder = schemaBuilder.comment(catalogTable.getComment()).options(catalogTable.getOptions()).primaryKey(keyNameList.toArray(new String[keyNameList.size()])).partitionKeys(partitionkeys.toArray(new String[partitionkeys.size()]));
        for (Schema.UnresolvedColumn col : columns) {
            if (!(col instanceof Schema.UnresolvedPhysicalColumn)) continue;
            Schema.UnresolvedPhysicalColumn temp = (Schema.UnresolvedPhysicalColumn)col;
            org.apache.flink.table.types.DataType dataTypeOri = (org.apache.flink.table.types.DataType)temp.getDataType();
            DataType dataTypeTarget = LogicalTypeConversion.toDataType((LogicalType)dataTypeOri.getLogicalType());
            schemaBuilder.column(temp.getName(), dataTypeTarget, temp.getComment().orElse(""));
        }
        return schemaBuilder.build();
    }

    public static CatalogTable addCols(CatalogTable catalogTable, Map<String, org.apache.flink.table.types.DataType> addColMap) {
        Schema schemaOri = catalogTable.getUnresolvedSchema();
        Schema.Builder schemaBuildTarget = Schema.newBuilder().fromSchema(schemaOri);
        for (String key : addColMap.keySet()) {
            schemaBuildTarget.column(key, (AbstractDataType)addColMap.get(key));
        }
        CatalogTable retobj = CatalogTable.of((Schema)schemaBuildTarget.build(), (String)catalogTable.getComment(), (List)catalogTable.getPartitionKeys(), (Map)catalogTable.getOptions());
        return retobj;
    }

    public static CatalogTable toCatalogTable(MySqlTbBean catalogTbInfo, List<MySqlColBean> mysqlColList, FieldFormart fieldFormart) {
        Schema.Builder builder = Schema.newBuilder();
        HashMap<String, String> properties = new HashMap<String, String>();
        if (StringUtil.isNotNull((Object)catalogTbInfo.getWithOptions())) {
            try {
                ObjectNode optionJson = (ObjectNode)new ObjectMapper().valueToTree((Object)catalogTbInfo.getWithOptions());
                Iterator<MySqlColBean> iterator = optionJson.fieldNames();
                while (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    properties.put(key, optionJson.get(key).asText());
                }
            }
            catch (Exception e) {
                log.error("\u89e3\u6790option\u65f6\u5931\u8d25:" + catalogTbInfo.getDb() + "." + catalogTbInfo.getTb(), (Throwable)e);
            }
        }
        properties.put("write-mode", "auto");
        ArrayList<String> keyCols = new ArrayList<String>();
        for (MySqlColBean mySqlColBean : mysqlColList) {
            if (!mySqlColBean.isPri()) continue;
            keyCols.add(mySqlColBean.getColumnNameStandard(fieldFormart));
        }
        builder.primaryKey(keyCols.toArray(new String[keyCols.size()]));
        for (MySqlColBean mySqlColBean : mysqlColList) {
            String colName = mySqlColBean.getColumnNameStandard(fieldFormart);
            HashMap<String, String> col = new HashMap<String, String>();
            FlinkTypeEnum flinkTypeEnum = StringUtil.isNull((Object)mySqlColBean.getFlinkTypeEnum()) ? FlinkTypeEnum.getByDataType((String)mySqlColBean.getDataType()) : FlinkTypeEnum.valueOf((String)mySqlColBean.getFlinkTypeEnum());
            col.put(ColsMetaCol.type.getOriColName(), flinkTypeEnum.name());
            String isNUllStr = mySqlColBean.isNotNull() ? YesOrNo.yes.name() : (keyCols.contains(colName) ? YesOrNo.yes.name() : YesOrNo.no.name());
            col.put(ColsMetaCol.notNull.getOriColName(), isNUllStr);
            col.put(ColsMetaCol.dataPrecision.getOriColName(), String.valueOf(mySqlColBean.getMaxlength()));
            col.put(ColsMetaCol.dataScale.getOriColName(), String.valueOf(mySqlColBean.getNumericScale()));
            org.apache.flink.table.types.DataType dataType = PaimonFlinkAssit.findColType(col, keyCols.contains(colName));
            builder.column(colName, (AbstractDataType)dataType);
        }
        if (StringUtil.isNotNull((Object)catalogTbInfo.getTbComment())) {
            builder.withComment(catalogTbInfo.getTbComment());
        }
        ArrayList partitionKeys = StringUtil.isNull((Object)catalogTbInfo.getPartitionkeys()) ? new ArrayList() : Arrays.asList(catalogTbInfo.getPartitionkeys().split(","));
        CatalogTable retobj = CatalogTable.of((Schema)builder.build(), null, partitionKeys, properties);
        return retobj;
    }

    public static org.apache.flink.table.types.DataType findColType(Map<String, String> col, boolean iskey) {
        FlinkTypeEnum flinkTypeEnum = FlinkTypeEnum.findByFlinkRowType((String)col.get(ColsMetaCol.type.getOriColName()));
        if (flinkTypeEnum == null) {
            throw new CatalogException("\u6b64\u7c7b\u578b[" + col.get(ColsMetaCol.type.getOriColName()) + "]\u8fd8\u4e0d\u652f\u6301\uff0c\u9700\u8981\u8fde\u63a5\u76f8\u5173\u4eba\u5458\u3002");
        }
        org.apache.flink.table.types.DataType dataType = null;
        switch (flinkTypeEnum) {
            case DECIMAL: {
                String dataPrecisionStr = StringUtil.hasNull((String[])new String[]{col.get(ColsMetaCol.dataPrecision.getOriColName()), String.valueOf(FlinkTypeEnum.DECIMAL.getDefaultPrecision())});
                String scaleStr = StringUtil.hasNull((String[])new String[]{col.get(ColsMetaCol.dataScale.getOriColName()), String.valueOf(FlinkTypeEnum.DECIMAL.getDefaultScale())});
                dataType = flinkTypeEnum.getConvert().getObj(Integer.parseInt(dataPrecisionStr), Integer.parseInt(scaleStr));
                break;
            }
            default: {
                dataType = (org.apache.flink.table.types.DataType)flinkTypeEnum.getConvert().getObj();
            }
        }
        String notNullStr = col.get(ColsMetaCol.notNull.getOriColName());
        dataType = iskey || "yes".equals(StringUtil.hasNull((String[])new String[]{notNullStr, "no"})) ? (org.apache.flink.table.types.DataType)dataType.notNull() : (org.apache.flink.table.types.DataType)dataType.nullable();
        return dataType;
    }

    public static Result createTable(Catalog catalog, MySqlTbBean catalogTbInfo, List<MySqlColBean> mysqlColList, FieldFormart fieldFormart) {
        CatalogTable table = PaimonFlinkAssit.toCatalogTable(catalogTbInfo, mysqlColList, fieldFormart);
        try {
            catalog.createTable(new ObjectPath(catalogTbInfo.getDb(), catalogTbInfo.getTb()), (CatalogBaseTable)table, false);
            return Result.getSuc();
        }
        catch (Exception e) {
            log.error("\u5efa\u8868\u9519\u8bef", (Throwable)e);
            return Result.getError((String)("\u5efa\u8868\u9519\u8bef:" + e.getMessage()));
        }
    }
}

