/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.flink.paimon;

import com.fasterxml.jackson.databind.node.ArrayNode;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.CollectionUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.apiext.jdbc.MySqlColBean;
import net.wicp.tams.common.apiext.jdbc.MySqlTbBean;
import net.wicp.tams.common.apiext.json.jackson.SingleQuoteStringSerializer;
import net.wicp.tams.common.constant.Middleware;
import net.wicp.tams.common.constant.MiddlewareOption;
import net.wicp.tams.common.flink.catalog.MysqlCatalogFactoryOptions;
import net.wicp.tams.common.flink.common.CatalogAssit;
import net.wicp.tams.common.flink.common.constant.CatalogName;
import net.wicp.tams.common.flink.common.constant.DelLevel;
import net.wicp.tams.common.flink.common.constant.FlinkTypeEnum;
import net.wicp.tams.common.flink.common.constant.db.ColsMetaDb;
import net.wicp.tams.common.flink.paimon.PaimonFlinkAssit;
import net.wicp.tams.common.jdbc.DruidAssit;
import net.wicp.tams.common.jdbc.MySqlAssitExt;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.TableColumn;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.WatermarkSpec;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogDatabase;
import org.apache.flink.table.catalog.CatalogDatabaseImpl;
import org.apache.flink.table.catalog.CatalogFunction;
import org.apache.flink.table.catalog.CatalogPartition;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.CatalogTableImpl;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.TableChange;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.catalog.exceptions.DatabaseAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.DatabaseNotEmptyException;
import org.apache.flink.table.catalog.exceptions.DatabaseNotExistException;
import org.apache.flink.table.catalog.exceptions.FunctionNotExistException;
import org.apache.flink.table.catalog.exceptions.PartitionNotExistException;
import org.apache.flink.table.catalog.exceptions.TableAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.TableNotExistException;
import org.apache.flink.table.catalog.stats.CatalogColumnStatistics;
import org.apache.flink.table.catalog.stats.CatalogTableStatistics;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.factories.Factory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.AtomicDataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.catalog.AbstractCatalog;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.flink.DataCatalogTable;
import org.apache.paimon.flink.FlinkCatalogOptions;
import org.apache.paimon.flink.FlinkTableFactory;
import org.apache.paimon.flink.LogicalTypeConversion;
import org.apache.paimon.flink.SystemCatalogTable;
import org.apache.paimon.flink.log.LogStoreRegister;
import org.apache.paimon.flink.utils.FlinkCatalogPropertiesUtil;
import org.apache.paimon.options.Options;
import org.apache.paimon.schema.Schema;
import org.apache.paimon.schema.SchemaChange;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.Table;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.StringUtils;

public class FlinkCatalog
extends org.apache.flink.table.catalog.AbstractCatalog {
    private final ClassLoader classLoader;
    private final Catalog catalog;
    private final boolean logStoreAutoRegister;
    private final Duration logStoreAutoRegisterTimeout;
    private final long tenantId;
    private final long operate;
    private final String mysqlDefaultDb;
    private final String warehouse;

    public String getWarehouse() {
        return this.warehouse;
    }

    public FlinkCatalog(Catalog catalog, String name, String defaultDatabase, ClassLoader classLoader, Options options, long tenantId, long operate, String mysqlDefaultDb, String warehouse) {
        super(name, defaultDatabase);
        this.catalog = catalog;
        this.classLoader = classLoader;
        this.logStoreAutoRegister = (Boolean)options.get(FlinkCatalogOptions.LOG_SYSTEM_AUTO_REGISTER);
        this.logStoreAutoRegisterTimeout = (Duration)options.get(FlinkCatalogOptions.REGISTER_TIMEOUT);
        this.tenantId = tenantId;
        this.operate = operate;
        this.mysqlDefaultDb = mysqlDefaultDb;
        this.warehouse = warehouse;
        Properties props = new Properties();
        String propPre = String.format("common.jdbc.datasource.%s.", "tams-paimon");
        props.put(propPre + MysqlCatalogFactoryOptions.host.key(), options.get(MysqlCatalogFactoryOptions.host.key()));
        props.put(propPre + MysqlCatalogFactoryOptions.username.key(), options.get(MysqlCatalogFactoryOptions.username.key()));
        props.put(propPre + MysqlCatalogFactoryOptions.password.key(), options.get(MysqlCatalogFactoryOptions.password.key()));
        props.put(propPre + MysqlCatalogFactoryOptions.port.key(), options.get(MysqlCatalogFactoryOptions.port.key()));
        props.put(propPre + MysqlCatalogFactoryOptions.defaultdb.key(), options.get(MysqlCatalogFactoryOptions.defaultdb.key()));
        if (StringUtil.isNotNull((Object)options.get(MysqlCatalogFactoryOptions.url.key()))) {
            props.put(propPre + MysqlCatalogFactoryOptions.url.key(), options.get(MysqlCatalogFactoryOptions.url.key()));
        }
        if (StringUtil.isNotNull((Object)options.get(MysqlCatalogFactoryOptions.urlparam.key()))) {
            props.put(propPre + MysqlCatalogFactoryOptions.urlparam.key(), options.get(MysqlCatalogFactoryOptions.urlparam.key()));
        }
        props.put("flink.catalog.tenantId", options.get(MysqlCatalogFactoryOptions.tenantId.key()));
        props.put("flink.catalog.operate", options.get(MysqlCatalogFactoryOptions.operate.key()));
        Conf.overProp((Properties)props);
        try {
            this.catalog.createDatabase(defaultDatabase, true);
        }
        catch (Catalog.DatabaseAlreadyExistException databaseAlreadyExistException) {
            // empty catch block
        }
    }

    public Catalog catalog() {
        return this.catalog;
    }

    public Optional<Factory> getFactory() {
        return Optional.of(new FlinkTableFactory());
    }

    public List<String> listDatabases() throws CatalogException {
        return this.catalog.listDatabases();
    }

    public boolean databaseExists(String databaseName) throws CatalogException {
        return this.catalog.databaseExists(databaseName);
    }

    public CatalogDatabase getDatabase(String databaseName) throws CatalogException, DatabaseNotExistException {
        if (this.databaseExists(databaseName)) {
            return new CatalogDatabaseImpl(Collections.emptyMap(), null);
        }
        throw new DatabaseNotExistException(this.getName(), databaseName);
    }

    public void createDatabase(String name, CatalogDatabase database, boolean ignoreIfExists) throws DatabaseAlreadyExistException, CatalogException {
        Connection connection = DruidAssit.getConnection((String)"tams-paimon");
        try {
            connection.setAutoCommit(false);
            int count = MySqlAssitExt.querySqlCount((Connection)connection, (String)String.format("select count(1) from %s.%s where %s='%s' and %s='%s' and %s='%s'", this.mysqlDefaultDb, "meta_db", ColsMetaDb.tenantId.getOriColName(), this.tenantId, ColsMetaDb.name.getOriColName(), name, ColsMetaDb.catalogName.getOriColName(), CatalogName.tscatalog.name()));
            if (!ignoreIfExists && count > 0) {
                throw new DatabaseAlreadyExistException(this.getName(), name);
            }
            if (count == 0) {
                String comment = database != null ? (database.getComment() == null ? "" : database.getComment()) : "";
                CatalogAssit.createDb((Connection)connection, (String)this.mysqlDefaultDb, (String)name, (CatalogName)CatalogName.find((String)super.getName()), (String)comment, (String)(database == null ? "" : StringUtil.hasNull((String[])new String[]{this.warehouse})), (long)this.tenantId, (long)this.operate);
            }
            this.createDatabaseOri(name, database, ignoreIfExists);
            connection.commit();
            connection.setAutoCommit(true);
        }
        catch (Throwable e) {
            try {
                connection.rollback();
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            if (e instanceof DatabaseAlreadyExistException) {
                throw (DatabaseAlreadyExistException)e;
            }
            if (e instanceof CatalogException) {
                throw (CatalogException)e;
            }
            throw new CatalogException("\u672a\u77e5\u5f02\u5e38:" + e.getMessage());
        }
        finally {
            DruidAssit.close((Connection)connection);
        }
    }

    private void createDatabaseOri(String name, CatalogDatabase database, boolean ignoreIfExists) throws DatabaseAlreadyExistException {
        if (database != null) {
            if (database.getProperties().size() > 0) {
                throw new UnsupportedOperationException("Create database with properties is unsupported.");
            }
            if (database.getDescription().isPresent() && !((String)database.getDescription().get()).equals("")) {
                throw new UnsupportedOperationException("Create database with description is unsupported.");
            }
        }
        try {
            this.catalog.createDatabase(name, ignoreIfExists);
        }
        catch (Catalog.DatabaseAlreadyExistException e) {
            throw new DatabaseAlreadyExistException(this.getName(), e.database());
        }
    }

    public void dropDatabase(String name, boolean ignoreIfNotExists, boolean cascade) throws DatabaseNotEmptyException, DatabaseNotExistException, CatalogException {
        throw new UnsupportedOperationException();
    }

    public List<String> listTables(String databaseName) throws DatabaseNotExistException, CatalogException {
        try {
            return this.catalog.listTables(databaseName);
        }
        catch (Catalog.DatabaseNotExistException e) {
            throw new DatabaseNotExistException(this.getName(), e.database());
        }
    }

    public CatalogTable getTable(ObjectPath tablePath) throws TableNotExistException, CatalogException {
        Table table;
        try {
            table = this.catalog.getTable(FlinkCatalog.toIdentifier(tablePath));
        }
        catch (Catalog.TableNotExistException e) {
            throw new TableNotExistException(this.getName(), tablePath);
        }
        if (table instanceof FileStoreTable) {
            return this.toCatalogTable(table);
        }
        return new SystemCatalogTable(table);
    }

    public boolean tableExists(ObjectPath tablePath) throws CatalogException {
        return this.catalog.tableExists(FlinkCatalog.toIdentifier(tablePath));
    }

    public void dropTable(ObjectPath tablePath, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException {
        Connection connection = DruidAssit.getConnection((String)"tams-paimon");
        try {
            connection.setAutoCommit(false);
            if (!this.tableExists(tablePath)) {
                CatalogAssit.dropTable((Connection)connection, (String)this.mysqlDefaultDb, (String)tablePath.getDatabaseName(), (String)tablePath.getObjectName(), (DelLevel)DelLevel.delLogicForce, (long)this.tenantId, (boolean)false);
                return;
            }
            CatalogAssit.dropTable((Connection)connection, (String)this.mysqlDefaultDb, (String)tablePath.getDatabaseName(), (String)tablePath.getObjectName(), (DelLevel)DelLevel.delLogicForce, (long)this.tenantId, (boolean)false);
            this.dropTableOri(tablePath, ignoreIfNotExists);
            connection.commit();
        }
        catch (Throwable e) {
            e.printStackTrace();
            try {
                connection.rollback();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            throw new RuntimeException(e.getMessage());
        }
        finally {
            DruidAssit.close((Connection)connection);
        }
    }

    private void dropTableOri(ObjectPath tablePath, boolean ignoreIfNotExists) throws TableNotExistException {
        Identifier identifier = FlinkCatalog.toIdentifier(tablePath);
        Table table = null;
        try {
            if (this.logStoreAutoRegister && this.catalog.tableExists(identifier)) {
                table = this.catalog.getTable(identifier);
            }
            this.catalog.dropTable(FlinkCatalog.toIdentifier(tablePath), ignoreIfNotExists);
            if (this.logStoreAutoRegister && table != null) {
                LogStoreRegister.unRegisterLogSystem((Identifier)identifier, (Map)table.options(), (ClassLoader)this.classLoader);
            }
        }
        catch (Catalog.TableNotExistException e) {
            throw new TableNotExistException(this.getName(), tablePath);
        }
    }

    public void createTable(ObjectPath tablePath, CatalogBaseTable table, boolean ignoreIfExists) throws TableAlreadyExistException, DatabaseNotExistException, CatalogException {
        boolean dbexist = this.databaseExists(tablePath.getDatabaseName());
        if (!dbexist) {
            throw new DatabaseNotExistException(super.getName(), tablePath.getDatabaseName());
        }
        boolean tableExists = this.tableExists(tablePath);
        if (ignoreIfExists && tableExists) {
            return;
        }
        Connection connection = DruidAssit.getConnection((String)"tams-paimon");
        try {
            connection.setAutoCommit(false);
            Map queryTable = CatalogAssit.queryTable((Connection)connection, (String)this.mysqlDefaultDb, (String)tablePath.getDatabaseName(), (String)tablePath.getObjectName(), (long)this.tenantId);
            if (MapUtils.isNotEmpty((Map)queryTable)) {
                CatalogAssit.dropTable((Connection)connection, (String)this.mysqlDefaultDb, (String)tablePath.getDatabaseName(), (String)tablePath.getObjectName(), (DelLevel)DelLevel.delLogicForce, (long)this.tenantId, (boolean)false);
            }
            ArrayList<MySqlColBean> colList = new ArrayList<MySqlColBean>();
            HashMap allOptmap = new HashMap();
            Pair proOptStr = Middleware.proOptStr(allOptmap, (MiddlewareOption[])allOptmap.keySet().toArray(new MiddlewareOption[allOptmap.size()]));
            MySqlTbBean catalogTbInfo = MySqlTbBean.builder().db(tablePath.getDatabaseName()).tb(tablePath.getObjectName()).tbComment("tablestore\u8868").middleware(Middleware.no).partitionkeys(null).opt((String)proOptStr.getRight()).catalogName(super.getName()).withOptions((String)proOptStr.getLeft()).build();
            List columns = table.getUnresolvedSchema().getColumns();
            for (Schema.UnresolvedColumn col : columns) {
                MySqlColBean tempbean = new MySqlColBean(col.getName(), "");
                tempbean.setMetadata(false);
                tempbean.setMetadataName("");
                tempbean.setVirtual(false);
                Optional primaryKey = table.getUnresolvedSchema().getPrimaryKey();
                List primaryKeys = primaryKey.isPresent() ? ((Schema.UnresolvedPrimaryKey)primaryKey.get()).getColumnNames() : new ArrayList();
                boolean isKey = primaryKeys.contains(col.getName());
                tempbean.setPri(isKey);
                tempbean.setDataType("");
                if (col instanceof Schema.UnresolvedPhysicalColumn) {
                    Schema.UnresolvedPhysicalColumn temp = (Schema.UnresolvedPhysicalColumn)col;
                    LogicalTypeRoot typeRoot = ((AtomicDataType)temp.getDataType()).getLogicalType().getTypeRoot();
                    try {
                        FlinkTypeEnum flinkTypeEnum = FlinkTypeEnum.valueOf((String)typeRoot.name());
                        tempbean.setFlinkTypeEnum(flinkTypeEnum.name());
                    }
                    catch (Exception e) {
                        throw new CatalogException("\u521b\u5efa\u8868[" + tablePath.getFullName() + "]\u65f6\u7c7b\u578b\u68c0\u67e5\u5f02\u5e38\uff0c\u539f\u56e0\uff1a\u8fd8\u4e0d\u652f\u6301\u6b64\u7c7b\u578b[" + temp.getName() + "]" + e.getMessage(), (Throwable)e);
                    }
                } else {
                    throw new RuntimeException("\u6682\u65f6\u53ea\u652f\u6301\u7269\u7406\u5217\uff0c\u4e0d\u652f\u6301\u5143\u6570\u636e\u5217\u3001\u8ba1\u7b97\u5217\u7b49\u5176\u4ed6\u5217");
                }
                tempbean.setDataType("");
                tempbean.setSqlExpression("");
                tempbean.setWatermarkExpression("");
                colList.add(tempbean);
            }
            CatalogAssit.createTable((Connection)connection, (String)this.mysqlDefaultDb, colList, (MySqlTbBean)catalogTbInfo, (long)this.tenantId, (long)this.operate, (boolean)false);
            this.createTableOri(tablePath, table, ignoreIfExists);
            connection.commit();
        }
        catch (Throwable e) {
            e.printStackTrace();
            try {
                connection.rollback();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            throw new RuntimeException(e.getMessage());
        }
        finally {
            DruidAssit.close((Connection)connection);
        }
    }

    private void createTableOri(ObjectPath tablePath, CatalogBaseTable table, boolean ignoreIfExists) throws TableAlreadyExistException, DatabaseNotExistException {
        String specific;
        if (!(table instanceof CatalogTable)) {
            throw new UnsupportedOperationException("Only support CatalogTable, but is: " + table.getClass());
        }
        CatalogTable catalogTable = (CatalogTable)table;
        Map options = table.getOptions();
        String connector = (String)options.get(FactoryUtil.CONNECTOR.key());
        options.remove(FactoryUtil.CONNECTOR.key());
        if (!StringUtils.isNullOrWhitespaceOnly((String)connector) && !"tams-paimon".equals(connector)) {
            throw new CatalogException("Paimon Catalog only supports paimon tables, but you specify  'connector'= '" + connector + "' when using Paimon Catalog\n You can create TEMPORARY table instead if you want to create the table of other connector.");
        }
        Identifier identifier = FlinkCatalog.toIdentifier(tablePath);
        if (this.logStoreAutoRegister) {
            if (this.catalog instanceof AbstractCatalog) {
                ((AbstractCatalog)this.catalog).copyTableDefaultOptions(options);
            }
            options.put(FlinkCatalogOptions.REGISTER_TIMEOUT.key(), this.logStoreAutoRegisterTimeout.toString());
            LogStoreRegister.registerLogSystem((Catalog)this.catalog, (Identifier)identifier, (Map)options, (ClassLoader)this.classLoader);
        }
        if ((specific = (String)options.remove(CoreOptions.PATH.key())) != null || this.logStoreAutoRegister) {
            catalogTable = catalogTable.copy(options);
        }
        boolean unRegisterLogSystem = false;
        try {
            this.catalog.createTable(identifier, PaimonFlinkAssit.fromCatalogTable(catalogTable), ignoreIfExists);
        }
        catch (Catalog.TableAlreadyExistException e) {
            unRegisterLogSystem = true;
            throw new TableAlreadyExistException(this.getName(), tablePath);
        }
        catch (Catalog.DatabaseNotExistException e) {
            unRegisterLogSystem = true;
            throw new DatabaseNotExistException(this.getName(), e.database());
        }
        finally {
            if (this.logStoreAutoRegister && unRegisterLogSystem) {
                LogStoreRegister.unRegisterLogSystem((Identifier)identifier, (Map)options, (ClassLoader)this.classLoader);
            }
        }
    }

    private List<SchemaChange> toSchemaChange(TableChange change) {
        ArrayList<SchemaChange> schemaChanges = new ArrayList<SchemaChange>();
        if (change instanceof TableChange.AddColumn) {
            TableChange.AddColumn add = (TableChange.AddColumn)change;
            String comment = add.getColumn().getComment().orElse(null);
            SchemaChange.Move move = this.getMove(add.getPosition(), add.getColumn().getName());
            schemaChanges.add(SchemaChange.addColumn((String)add.getColumn().getName(), (DataType)LogicalTypeConversion.toDataType((LogicalType)add.getColumn().getDataType().getLogicalType()), (String)comment, (SchemaChange.Move)move));
            return schemaChanges;
        }
        if (change instanceof TableChange.AddWatermark) {
            TableChange.AddWatermark add = (TableChange.AddWatermark)change;
            this.setWatermarkOptions(add.getWatermark(), schemaChanges);
            return schemaChanges;
        }
        if (change instanceof TableChange.DropColumn) {
            TableChange.DropColumn drop = (TableChange.DropColumn)change;
            schemaChanges.add(SchemaChange.dropColumn((String)drop.getColumnName()));
            return schemaChanges;
        }
        if (change instanceof TableChange.DropWatermark) {
            String watermarkPrefix = FlinkCatalogPropertiesUtil.compoundKey((Object[])new Object[]{"schema", "watermark", 0});
            schemaChanges.add(SchemaChange.removeOption((String)FlinkCatalogPropertiesUtil.compoundKey((Object[])new Object[]{watermarkPrefix, "rowtime"})));
            schemaChanges.add(SchemaChange.removeOption((String)FlinkCatalogPropertiesUtil.compoundKey((Object[])new Object[]{watermarkPrefix, "strategy.expr"})));
            schemaChanges.add(SchemaChange.removeOption((String)FlinkCatalogPropertiesUtil.compoundKey((Object[])new Object[]{watermarkPrefix, "strategy.data-type"})));
            return schemaChanges;
        }
        if (change instanceof TableChange.ModifyColumnName) {
            TableChange.ModifyColumnName modify = (TableChange.ModifyColumnName)change;
            schemaChanges.add(SchemaChange.renameColumn((String)modify.getOldColumnName(), (String)modify.getNewColumnName()));
            return schemaChanges;
        }
        if (change instanceof TableChange.ModifyPhysicalColumnType) {
            TableChange.ModifyPhysicalColumnType modify = (TableChange.ModifyPhysicalColumnType)change;
            LogicalType newColumnType = modify.getNewType().getLogicalType();
            LogicalType oldColumnType = modify.getOldColumn().getDataType().getLogicalType();
            if (newColumnType.isNullable() != oldColumnType.isNullable()) {
                schemaChanges.add(SchemaChange.updateColumnNullability((String)modify.getNewColumn().getName(), (boolean)newColumnType.isNullable()));
            }
            schemaChanges.add(SchemaChange.updateColumnType((String)modify.getOldColumn().getName(), (DataType)LogicalTypeConversion.toDataType((LogicalType)newColumnType)));
            return schemaChanges;
        }
        if (change instanceof TableChange.ModifyColumnPosition) {
            TableChange.ModifyColumnPosition modify = (TableChange.ModifyColumnPosition)change;
            SchemaChange.Move move = this.getMove(modify.getNewPosition(), modify.getNewColumn().getName());
            schemaChanges.add(SchemaChange.updateColumnPosition((SchemaChange.Move)move));
            return schemaChanges;
        }
        if (change instanceof TableChange.ModifyColumnComment) {
            TableChange.ModifyColumnComment modify = (TableChange.ModifyColumnComment)change;
            schemaChanges.add(SchemaChange.updateColumnComment((String)modify.getNewColumn().getName(), (String)modify.getNewComment()));
            return schemaChanges;
        }
        if (change instanceof TableChange.ModifyWatermark) {
            TableChange.ModifyWatermark modify = (TableChange.ModifyWatermark)change;
            this.setWatermarkOptions(modify.getNewWatermark(), schemaChanges);
            return schemaChanges;
        }
        if (change instanceof TableChange.SetOption) {
            TableChange.SetOption setOption = (TableChange.SetOption)change;
            String key = setOption.getKey();
            String value = setOption.getValue();
            SchemaManager.checkAlterTablePath((String)key);
            schemaChanges.add(SchemaChange.setOption((String)key, (String)value));
            return schemaChanges;
        }
        if (change instanceof TableChange.ResetOption) {
            TableChange.ResetOption resetOption = (TableChange.ResetOption)change;
            schemaChanges.add(SchemaChange.removeOption((String)resetOption.getKey()));
            return schemaChanges;
        }
        throw new UnsupportedOperationException("Change is not supported: " + change.getClass());
    }

    public void alterTable(ObjectPath tablePath, CatalogBaseTable newTable, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException {
        Connection connection = DruidAssit.getConnection((String)"tams-paimon");
        try {
            connection.setAutoCommit(false);
            if (!this.tableExists(tablePath)) {
                CatalogAssit.dropTable((Connection)connection, (String)this.mysqlDefaultDb, (String)tablePath.getDatabaseName(), (String)tablePath.getObjectName(), (DelLevel)DelLevel.delLogicForce, (long)this.tenantId, (boolean)false);
                connection.commit();
                return;
            }
            CatalogAssit.dropTable((Connection)connection, (String)this.mysqlDefaultDb, (String)tablePath.getDatabaseName(), (String)tablePath.getObjectName(), (DelLevel)DelLevel.delLogicForce, (long)this.tenantId, (boolean)false);
            Pair<MySqlTbBean, List<MySqlColBean>> tableInfo = this.getCreateTableInfo(newTable, tablePath);
            CatalogAssit.createTable((Connection)connection, (String)this.mysqlDefaultDb, (List)((List)tableInfo.getRight()), (MySqlTbBean)((MySqlTbBean)tableInfo.getLeft()), (long)this.tenantId, (long)this.operate, (boolean)false);
            this.alterTableOri(tablePath, newTable, ignoreIfNotExists);
            connection.commit();
        }
        catch (Throwable e) {
            e.printStackTrace();
            try {
                connection.rollback();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            throw new RuntimeException(e.getMessage());
        }
        finally {
            DruidAssit.close((Connection)connection);
        }
    }

    private Pair<MySqlTbBean, List<MySqlColBean>> getCreateTableInfo(CatalogBaseTable newTable, ObjectPath tablePath) {
        List mysqlColList = CatalogAssit.packageColBeans((CatalogBaseTable)newTable, (String)tablePath.getObjectName());
        String partitionkeys = "";
        CatalogTable tableTrue = (CatalogTable)newTable;
        if (CollectionUtils.isNotEmpty((Collection)tableTrue.getPartitionKeys())) {
            partitionkeys = CollectionUtil.listJoin((Collection)tableTrue.getPartitionKeys(), (String)",");
        }
        ArrayNode valueToTree = (ArrayNode)SingleQuoteStringSerializer.getInst().valueToTree((Object)newTable.getOptions());
        String options = valueToTree.toString();
        MySqlTbBean catalogTbInfo = MySqlTbBean.builder().db(tablePath.getDatabaseName()).tb(tablePath.getObjectName()).tbComment("\u901a\u8fc7sql\u521b\u5efa").middleware(Middleware.no).partitionkeys(partitionkeys).opt(options).catalogName(super.getName()).withOptions("{'total':0,'rows':[]}").build();
        return Pair.of((Object)catalogTbInfo, (Object)mysqlColList);
    }

    private void alterTableOri(ObjectPath tablePath, CatalogBaseTable newTable, boolean ignoreIfNotExists) throws TableNotExistException {
        if (ignoreIfNotExists && !this.tableExists(tablePath)) {
            return;
        }
        CatalogTable table = this.getTable(tablePath);
        FlinkCatalog.validateAlterTable(table, (CatalogTable)newTable);
        ArrayList<SchemaChange> changes = new ArrayList<SchemaChange>();
        Map oldProperties = table.getOptions();
        for (Map.Entry entry : newTable.getOptions().entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (Objects.equals(value, oldProperties.get(key))) continue;
            if (CoreOptions.PATH.key().equalsIgnoreCase(key)) {
                throw new IllegalArgumentException("Illegal table path in table options: " + value);
            }
            changes.add(SchemaChange.setOption((String)key, (String)value));
        }
        oldProperties.keySet().forEach(k -> {
            if (!newTable.getOptions().containsKey(k)) {
                changes.add(SchemaChange.removeOption((String)k));
            }
        });
        try {
            this.catalog.alterTable(FlinkCatalog.toIdentifier(tablePath), changes, ignoreIfNotExists);
        }
        catch (Catalog.TableNotExistException e) {
            throw new TableNotExistException(this.getName(), tablePath);
        }
        catch (Catalog.ColumnAlreadyExistException | Catalog.ColumnNotExistException e) {
            throw new CatalogException(e);
        }
    }

    public void alterTable(ObjectPath tablePath, CatalogBaseTable newTable, List<TableChange> tableChanges, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException {
        Connection connection = DruidAssit.getConnection((String)"tams-paimon");
        try {
            connection.setAutoCommit(false);
            if (!this.tableExists(tablePath)) {
                CatalogAssit.dropTable((Connection)connection, (String)this.mysqlDefaultDb, (String)tablePath.getDatabaseName(), (String)tablePath.getObjectName(), (DelLevel)DelLevel.delLogicForce, (long)this.tenantId, (boolean)false);
                connection.commit();
                return;
            }
            CatalogAssit.dropTable((Connection)connection, (String)this.mysqlDefaultDb, (String)tablePath.getDatabaseName(), (String)tablePath.getObjectName(), (DelLevel)DelLevel.delLogicForce, (long)this.tenantId, (boolean)false);
            Pair<MySqlTbBean, List<MySqlColBean>> tableInfo = this.getCreateTableInfo(newTable, tablePath);
            CatalogAssit.createTable((Connection)connection, (String)this.mysqlDefaultDb, (List)((List)tableInfo.getRight()), (MySqlTbBean)((MySqlTbBean)tableInfo.getLeft()), (long)this.tenantId, (long)this.operate, (boolean)false);
            this.alterTableOri(tablePath, newTable, tableChanges, ignoreIfNotExists);
            connection.commit();
        }
        catch (Throwable e) {
            e.printStackTrace();
            try {
                connection.rollback();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            throw new RuntimeException(e.getMessage());
        }
        finally {
            DruidAssit.close((Connection)connection);
        }
    }

    private void alterTableOri(ObjectPath tablePath, CatalogBaseTable newTable, List<TableChange> tableChanges, boolean ignoreIfNotExists) throws TableNotExistException {
        if (ignoreIfNotExists && !this.tableExists(tablePath)) {
            return;
        }
        CatalogTable table = this.getTable(tablePath);
        FlinkCatalog.validateAlterTable(table, (CatalogTable)newTable);
        ArrayList changes = new ArrayList();
        if (null != tableChanges) {
            List schemaChanges = tableChanges.stream().flatMap(tableChange -> this.toSchemaChange((TableChange)tableChange).stream()).collect(Collectors.toList());
            changes.addAll(schemaChanges);
        }
        try {
            this.catalog.alterTable(FlinkCatalog.toIdentifier(tablePath), changes, ignoreIfNotExists);
        }
        catch (Catalog.ColumnAlreadyExistException | Catalog.ColumnNotExistException | Catalog.TableNotExistException e) {
            throw new TableNotExistException(this.getName(), tablePath);
        }
    }

    private SchemaChange.Move getMove(TableChange.ColumnPosition columnPosition, String fieldName) {
        SchemaChange.Move move = null;
        if (columnPosition instanceof TableChange.First) {
            move = SchemaChange.Move.first((String)fieldName);
        } else if (columnPosition instanceof TableChange.After) {
            move = SchemaChange.Move.after((String)fieldName, (String)((TableChange.After)columnPosition).column());
        }
        return move;
    }

    private String getWatermarkKeyPrefix() {
        return FlinkCatalogPropertiesUtil.compoundKey((Object[])new Object[]{"schema", "watermark", 0});
    }

    private String getWatermarkRowTimeKey(String watermarkPrefix) {
        return FlinkCatalogPropertiesUtil.compoundKey((Object[])new Object[]{watermarkPrefix, "rowtime"});
    }

    private String getWatermarkExprKey(String watermarkPrefix) {
        return FlinkCatalogPropertiesUtil.compoundKey((Object[])new Object[]{watermarkPrefix, "strategy.expr"});
    }

    private String getWatermarkExprDataTypeKey(String watermarkPrefix) {
        return FlinkCatalogPropertiesUtil.compoundKey((Object[])new Object[]{watermarkPrefix, "strategy.data-type"});
    }

    private void setWatermarkOptions(org.apache.flink.table.catalog.WatermarkSpec wms, List<SchemaChange> schemaChanges) {
        String watermarkPrefix = this.getWatermarkKeyPrefix();
        schemaChanges.add(SchemaChange.setOption((String)this.getWatermarkRowTimeKey(watermarkPrefix), (String)wms.getRowtimeAttribute()));
        schemaChanges.add(SchemaChange.setOption((String)this.getWatermarkExprKey(watermarkPrefix), (String)wms.getWatermarkExpression().asSerializableString()));
        schemaChanges.add(SchemaChange.setOption((String)this.getWatermarkExprDataTypeKey(watermarkPrefix), (String)wms.getWatermarkExpression().getOutputDataType().getLogicalType().asSerializableString()));
    }

    private static void validateAlterTable(CatalogTable ct1, CatalogTable ct2) {
        if (ct1 instanceof SystemCatalogTable) {
            throw new UnsupportedOperationException("Can't alter system table.");
        }
        org.apache.flink.table.api.Schema ts1 = ct1.getUnresolvedSchema();
        org.apache.flink.table.api.Schema ts2 = ct2.getUnresolvedSchema();
        if (ts1.getPrimaryKey().isPresent() != ts2.getPrimaryKey().isPresent()) {
            throw new UnsupportedOperationException("Altering primary key is not supported yet.");
        }
        if (ts1.getPrimaryKey().isPresent() && ts2.getPrimaryKey().isPresent()) {
            List key1s = ((Schema.UnresolvedPrimaryKey)ts1.getPrimaryKey().get()).getColumnNames();
            List key2s = ((Schema.UnresolvedPrimaryKey)ts2.getPrimaryKey().get()).getColumnNames();
            if (key1s.size() != key2s.size()) {
                throw new UnsupportedOperationException("Altering primary key is not supported yet.");
            }
            for (int i = 0; i < key1s.size(); ++i) {
                int j;
                if (!((String)key1s.get(i)).equals(key1s.get(i))) {
                    throw new UnsupportedOperationException("Altering primary key is not supported yet.");
                }
                AbstractDataType dataType1 = null;
                AbstractDataType dataType2 = null;
                for (j = 0; j < ts1.getColumns().size(); ++j) {
                    Schema.UnresolvedPhysicalColumn unresolvedColumn1 = (Schema.UnresolvedPhysicalColumn)ts1.getColumns().get(j);
                    if (!unresolvedColumn1.getName().equals(key1s.get(i))) continue;
                    dataType1 = unresolvedColumn1.getDataType();
                    break;
                }
                for (j = 0; j < ts2.getColumns().size(); ++j) {
                    Schema.UnresolvedPhysicalColumn unresolvedColumn2 = (Schema.UnresolvedPhysicalColumn)ts2.getColumns().get(j);
                    if (!unresolvedColumn2.getName().equals(key1s.get(i))) continue;
                    dataType2 = unresolvedColumn2.getDataType();
                    break;
                }
                if (Objects.equals(dataType1, dataType2)) continue;
                throw new UnsupportedOperationException("Altering primary key is not supported yet.");
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)ct1.getPartitionKeys()) != CollectionUtils.isNotEmpty((Collection)ct2.getPartitionKeys())) {
            throw new UnsupportedOperationException("Altering partition keys is not supported yet.");
        }
        if (CollectionUtils.isNotEmpty((Collection)ct1.getPartitionKeys()) && CollectionUtils.isNotEmpty((Collection)ct2.getPartitionKeys())) {
            if (ct1.getPartitionKeys().size() != ct2.getPartitionKeys().size()) {
                throw new UnsupportedOperationException("Altering partition keys is not supported yet.");
            }
            for (int i = 0; i < ct1.getPartitionKeys().size(); ++i) {
                if (((String)ct1.getPartitionKeys().get(i)).equals(ct2.getPartitionKeys().get(i))) continue;
                throw new UnsupportedOperationException("Altering partition keys is not supported yet.");
            }
        }
    }

    public final void open() throws CatalogException {
    }

    public final void close() throws CatalogException {
        try {
            this.catalog.close();
        }
        catch (Exception e) {
            throw new CatalogException("Failed to close catalog " + this.catalog.toString(), (Throwable)e);
        }
    }

    private CatalogTableImpl toCatalogTable(Table table) {
        HashMap newOptions = new HashMap(table.options());
        TableSchema.Builder builder = TableSchema.builder();
        List physicalRowFields = LogicalTypeConversion.toLogicalType((RowType)table.rowType()).getFields();
        List physicalColumns = table.rowType().getFieldNames();
        int columnCount = physicalRowFields.size() + FlinkCatalogPropertiesUtil.nonPhysicalColumnsCount(newOptions, (List)physicalColumns);
        int physicalColumnIndex = 0;
        for (int i = 0; i < columnCount; ++i) {
            String optionalName = (String)newOptions.get(FlinkCatalogPropertiesUtil.compoundKey((Object[])new Object[]{"schema", i, "name"}));
            if (optionalName == null || physicalColumns.contains(optionalName)) {
                RowType.RowField field = (RowType.RowField)physicalRowFields.get(physicalColumnIndex++);
                builder.field(field.getName(), TypeConversions.fromLogicalToDataType((LogicalType)field.getType()));
                continue;
            }
            builder.add(FlinkCatalogPropertiesUtil.deserializeNonPhysicalColumn(newOptions, (int)i));
        }
        if (newOptions.keySet().stream().anyMatch(key -> key.startsWith(FlinkCatalogPropertiesUtil.compoundKey((Object[])new Object[]{"schema", "watermark"})))) {
            builder.watermark(FlinkCatalogPropertiesUtil.deserializeWatermarkSpec(newOptions));
        }
        if (table.primaryKeys().size() > 0) {
            builder.primaryKey(table.primaryKeys().toArray(new String[0]));
        }
        TableSchema schema = builder.build();
        DescriptorProperties removeProperties = new DescriptorProperties(false);
        removeProperties.putTableSchema("schema", schema);
        removeProperties.asMap().keySet().forEach(newOptions::remove);
        return new DataCatalogTable(table, schema, table.partitionKeys(), newOptions, table.comment().orElse(""));
    }

    public static Schema fromCatalogTable(CatalogTable catalogTable) {
        TableSchema schema = catalogTable.getSchema();
        org.apache.flink.table.types.logical.RowType rowType = (org.apache.flink.table.types.logical.RowType)schema.toPhysicalRowDataType().getLogicalType();
        HashMap<String, String> options = new HashMap<String, String>(catalogTable.getOptions());
        options.putAll(FlinkCatalog.columnOptions(schema));
        Schema.Builder schemaBuilder = Schema.newBuilder().comment(catalogTable.getComment()).options(options).primaryKey(schema.getPrimaryKey().map(pk -> pk.getColumns()).orElse(Collections.emptyList())).partitionKeys(catalogTable.getPartitionKeys());
        Map<String, String> columnComments = FlinkCatalog.getColumnComments(catalogTable);
        rowType.getFields().forEach(field -> schemaBuilder.column(field.getName(), LogicalTypeConversion.toDataType((LogicalType)field.getType()), (String)columnComments.get(field.getName())));
        return schemaBuilder.build();
    }

    private static Map<String, String> getColumnComments(CatalogTable catalogTable) {
        return catalogTable.getUnresolvedSchema().getColumns().stream().filter(c -> c.getComment().isPresent()).collect(Collectors.toMap(Schema.UnresolvedColumn::getName, c -> (String)c.getComment().get()));
    }

    private static Map<String, String> columnOptions(TableSchema schema) {
        List watermarkSpecs;
        HashMap<String, String> columnOptions = new HashMap<String, String>();
        HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
        List tableColumns = schema.getTableColumns();
        for (int i = 0; i < tableColumns.size(); ++i) {
            indexMap.put(((TableColumn)tableColumns.get(i)).getName(), i);
        }
        List nonPhysicalColumns = tableColumns.stream().filter(c -> !c.isPhysical()).collect(Collectors.toList());
        if (!nonPhysicalColumns.isEmpty()) {
            columnOptions.putAll(FlinkCatalogPropertiesUtil.serializeNonPhysicalColumns(indexMap, nonPhysicalColumns));
        }
        if (!(watermarkSpecs = schema.getWatermarkSpecs()).isEmpty()) {
            Preconditions.checkArgument((watermarkSpecs.size() == 1 ? 1 : 0) != 0);
            columnOptions.putAll(FlinkCatalogPropertiesUtil.serializeWatermarkSpec((WatermarkSpec)((WatermarkSpec)watermarkSpecs.get(0))));
        }
        return columnOptions;
    }

    public static Identifier toIdentifier(ObjectPath path) {
        return new Identifier(path.getDatabaseName(), path.getObjectName());
    }

    public final void alterDatabase(String name, CatalogDatabase newDatabase, boolean ignoreIfNotExists) throws CatalogException {
        throw new UnsupportedOperationException();
    }

    public final void renameTable(ObjectPath tablePath, String newTableName, boolean ignoreIfNotExists) throws CatalogException, TableNotExistException, TableAlreadyExistException {
        ObjectPath toTable = new ObjectPath(tablePath.getDatabaseName(), newTableName);
        try {
            this.catalog.renameTable(FlinkCatalog.toIdentifier(tablePath), FlinkCatalog.toIdentifier(toTable), ignoreIfNotExists);
        }
        catch (Catalog.TableNotExistException e) {
            throw new TableNotExistException(this.getName(), tablePath);
        }
        catch (Catalog.TableAlreadyExistException e) {
            throw new TableAlreadyExistException(this.getName(), toTable);
        }
    }

    public final List<String> listViews(String databaseName) throws CatalogException {
        return Collections.emptyList();
    }

    public final List<CatalogPartitionSpec> listPartitions(ObjectPath tablePath) throws CatalogException {
        return Collections.emptyList();
    }

    public final List<CatalogPartitionSpec> listPartitions(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws CatalogException {
        return Collections.emptyList();
    }

    public final List<CatalogPartitionSpec> listPartitionsByFilter(ObjectPath tablePath, List<Expression> filters) throws CatalogException {
        return Collections.emptyList();
    }

    public final CatalogPartition getPartition(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws PartitionNotExistException, CatalogException {
        throw new PartitionNotExistException(this.getName(), tablePath, partitionSpec);
    }

    public final boolean partitionExists(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws CatalogException {
        return false;
    }

    public final void createPartition(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, CatalogPartition partition, boolean ignoreIfExists) throws CatalogException {
        throw new UnsupportedOperationException();
    }

    public final void dropPartition(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, boolean ignoreIfNotExists) throws CatalogException {
        throw new UnsupportedOperationException();
    }

    public final void alterPartition(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, CatalogPartition newPartition, boolean ignoreIfNotExists) throws CatalogException {
        throw new UnsupportedOperationException();
    }

    public final List<String> listFunctions(String dbName) throws CatalogException {
        return Collections.emptyList();
    }

    public final CatalogFunction getFunction(ObjectPath functionPath) throws FunctionNotExistException, CatalogException {
        throw new FunctionNotExistException(this.getName(), functionPath);
    }

    public final boolean functionExists(ObjectPath functionPath) throws CatalogException {
        return false;
    }

    public final void createFunction(ObjectPath functionPath, CatalogFunction function, boolean ignoreIfExists) throws CatalogException {
        throw new UnsupportedOperationException("Create function is not supported, maybe you can use 'CREATE TEMPORARY FUNCTION' instead.");
    }

    public final void alterFunction(ObjectPath functionPath, CatalogFunction newFunction, boolean ignoreIfNotExists) throws CatalogException {
        throw new UnsupportedOperationException();
    }

    public final void dropFunction(ObjectPath functionPath, boolean ignoreIfNotExists) throws CatalogException {
        throw new UnsupportedOperationException();
    }

    public final CatalogTableStatistics getTableStatistics(ObjectPath tablePath) throws CatalogException {
        return CatalogTableStatistics.UNKNOWN;
    }

    public final CatalogColumnStatistics getTableColumnStatistics(ObjectPath tablePath) throws CatalogException {
        return CatalogColumnStatistics.UNKNOWN;
    }

    public final CatalogTableStatistics getPartitionStatistics(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws CatalogException {
        return CatalogTableStatistics.UNKNOWN;
    }

    public final CatalogColumnStatistics getPartitionColumnStatistics(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws CatalogException {
        return CatalogColumnStatistics.UNKNOWN;
    }

    public final void alterTableStatistics(ObjectPath tablePath, CatalogTableStatistics tableStatistics, boolean ignoreIfNotExists) throws CatalogException {
        throw new UnsupportedOperationException();
    }

    public final void alterTableColumnStatistics(ObjectPath tablePath, CatalogColumnStatistics columnStatistics, boolean ignoreIfNotExists) throws CatalogException {
        throw new UnsupportedOperationException();
    }

    public final void alterPartitionStatistics(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, CatalogTableStatistics partitionStatistics, boolean ignoreIfNotExists) throws CatalogException {
        throw new UnsupportedOperationException();
    }

    public final void alterPartitionColumnStatistics(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, CatalogColumnStatistics columnStatistics, boolean ignoreIfNotExists) throws CatalogException {
        throw new UnsupportedOperationException();
    }
}

