package net.wicp.tams.common.flink.paimon;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.Schema.Builder;
import org.apache.flink.table.api.Schema.UnresolvedColumn;
import org.apache.flink.table.api.Schema.UnresolvedPhysicalColumn;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.types.DataType;
import org.apache.paimon.flink.LogicalTypeConversion;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;

import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.apiext.jdbc.MySqlColBean;
import net.wicp.tams.common.apiext.jdbc.MySqlTbBean;
import net.wicp.tams.common.constant.FieldFormart;
import net.wicp.tams.common.constant.dic.YesOrNo;
import net.wicp.tams.common.flink.common.constant.FlinkTypeEnum;
import net.wicp.tams.common.flink.common.constant.db.ColsMetaCol;

@Slf4j
public abstract class PaimonFlinkAssit {

	public static org.apache.paimon.schema.Schema fromCatalogTable(CatalogTable catalogTable) {
		org.apache.paimon.schema.Schema.Builder schemaBuilder = org.apache.paimon.schema.Schema.newBuilder();
		Schema schemaOri = catalogTable.getUnresolvedSchema();
		List<String> keyNameList = schemaOri.getPrimaryKey().get().getColumnNames();
		List<String> partitionkeys = catalogTable.getPartitionKeys();
		List<UnresolvedColumn> columns = schemaOri.getColumns();
		schemaBuilder = schemaBuilder.comment(catalogTable.getComment()).options(catalogTable.getOptions())
				.primaryKey(keyNameList.toArray(new String[keyNameList.size()]))
				.partitionKeys(partitionkeys.toArray(new String[partitionkeys.size()]));
		for (UnresolvedColumn col : columns) {
			if (col instanceof UnresolvedPhysicalColumn) {
				UnresolvedPhysicalColumn temp = (UnresolvedPhysicalColumn) col;
				DataType dataTypeOri = (DataType) temp.getDataType();
				org.apache.paimon.types.DataType dataTypeTarget = LogicalTypeConversion
						.toDataType(dataTypeOri.getLogicalType());
				schemaBuilder.column(temp.getName(), dataTypeTarget, temp.getComment().orElse(""));
			}
		}
		return schemaBuilder.build();
	}

	// 在原表上加字段
	public static CatalogTable addCols(CatalogTable catalogTable, Map<String, DataType> addColMap) {
		Schema schemaOri = catalogTable.getUnresolvedSchema();
		Builder schemaBuildTarget = Schema.newBuilder().fromSchema(schemaOri);
		for (String key : addColMap.keySet()) {
			schemaBuildTarget.column(key, addColMap.get(key));
		}
		CatalogTable retobj = CatalogTable.of(schemaBuildTarget.build(), catalogTable.getComment(),
				catalogTable.getPartitionKeys(), catalogTable.getOptions());
		return retobj;
	}

	public static CatalogTable toCatalogTable(MySqlTbBean catalogTbInfo, List<MySqlColBean> mysqlColList,
			FieldFormart fieldFormart) {
		Builder builder = Schema.newBuilder();
		Map<String, String> properties = new HashMap<>();
		if (StringUtil.isNotNull(catalogTbInfo.getWithOptions())) {
			try {
				ObjectNode optionJson = new ObjectMapper().valueToTree(catalogTbInfo.getWithOptions());
				for (Iterator<String> iterator = optionJson.fieldNames(); iterator.hasNext();) {
					String key = iterator.next();
					properties.put(key, optionJson.get(key).asText());
				}
			} catch (Exception e) {
				log.error("解析option时失败:" + catalogTbInfo.getDb() + "." + catalogTbInfo.getTb(), e);
			}
		}
		properties.put("write-mode", "auto");
		// file:/tmp/duckula/paimon/duckulats.db/t_word_count
//		String pathStr = IOUtil.mergeFolderAndFilePath(warehouse,
//				String.format("/%s.db/%s", catalogTbInfo.getDb(), catalogTbInfo.getTb()));
//		properties.put(PATH.key(), pathStr);// ！！！对于paimon表这属性必填
		List<String> keyCols = new ArrayList<>();
		for (MySqlColBean mySqlColBean : mysqlColList) {
			if (mySqlColBean.isPri()) {
				keyCols.add(mySqlColBean.getColumnNameStandard(fieldFormart));
			}
		}
		builder.primaryKey(keyCols.toArray(new String[keyCols.size()]));

		for (MySqlColBean mySqlColBean : mysqlColList) {
			String colName = mySqlColBean.getColumnNameStandard(fieldFormart);
			Map<String, String> col = new HashMap<>();
			FlinkTypeEnum flinkTypeEnum = StringUtil.isNull(mySqlColBean.getFlinkTypeEnum())
					? FlinkTypeEnum.getByDataType(mySqlColBean.getDataType())
					: FlinkTypeEnum.valueOf(mySqlColBean.getFlinkTypeEnum());
			col.put(ColsMetaCol.type.getOriColName(), flinkTypeEnum.name());
			String isNUllStr = mySqlColBean.isNotNull() ? YesOrNo.yes.name()
					: (keyCols.contains(colName) ? YesOrNo.yes.name() : YesOrNo.no.name());
			col.put(ColsMetaCol.notNull.getOriColName(), isNUllStr);
			col.put(ColsMetaCol.dataPrecision.getOriColName(), String.valueOf(mySqlColBean.getMaxlength()));
			col.put(ColsMetaCol.dataScale.getOriColName(), String.valueOf(mySqlColBean.getNumericScale()));
			DataType dataType = findColType(col, keyCols.contains(colName));
			builder.column(colName, dataType);
		}
		if (StringUtil.isNotNull(catalogTbInfo.getTbComment())) {// 备注
			builder.withComment(catalogTbInfo.getTbComment());
		}
		List<String> partitionKeys = StringUtil.isNull(catalogTbInfo.getPartitionkeys()) ? new ArrayList<>()
				: Arrays.asList(catalogTbInfo.getPartitionkeys().split(","));
		CatalogTable retobj = CatalogTable.of(builder.build(), null, partitionKeys, properties);
		return retobj;
	}

	// 数据库数据转为flink类型
	public static DataType findColType(Map<String, String> col, boolean iskey) {
		FlinkTypeEnum flinkTypeEnum = FlinkTypeEnum.findByFlinkRowType(col.get(ColsMetaCol.type.getOriColName()));
		if (flinkTypeEnum == null) {
			throw new CatalogException("此类型[" + col.get(ColsMetaCol.type.getOriColName()) + "]还不支持，需要连接相关人员。");
		}
		DataType dataType = null;
		switch (flinkTypeEnum) {
		case DECIMAL:
			String dataPrecisionStr = StringUtil.hasNull(col.get(ColsMetaCol.dataPrecision.getOriColName()),
					String.valueOf(FlinkTypeEnum.DECIMAL.getDefaultPrecision()));
			String scaleStr = StringUtil.hasNull(col.get(ColsMetaCol.dataScale.getOriColName()),
					String.valueOf(FlinkTypeEnum.DECIMAL.getDefaultScale()));
			dataType = flinkTypeEnum.getConvert().getObj(Integer.parseInt(dataPrecisionStr),
					Integer.parseInt(scaleStr));
			break;
		default:
			dataType = flinkTypeEnum.getConvert().getObj();
			break;
		}
		String notNullStr = col.get(ColsMetaCol.notNull.getOriColName());
		if (iskey || "yes".equals(StringUtil.hasNull(notNullStr, "no"))) {// 主键或定义为不为空。 Invalid primary key
																			// 'PK_one_uid_tenant_uid_shop_id_order_id_customer_id'.
																			// Column 'one_uid' is nullable.
			dataType = dataType.notNull();
		} else {
			dataType = dataType.nullable();
		}
		return dataType;
	}

	// 创建paimon的表
	public static Result createTable(Catalog catalog, MySqlTbBean catalogTbInfo, List<MySqlColBean> mysqlColList,
			FieldFormart fieldFormart) {
		CatalogBaseTable table = toCatalogTable(catalogTbInfo, mysqlColList, fieldFormart);
		try {
			catalog.createTable(new ObjectPath(catalogTbInfo.getDb(), catalogTbInfo.getTb()), table, false);
			return Result.getSuc();
		} catch (Exception e) {
			log.error("建表错误", e);
			return Result.getError("建表错误:" + e.getMessage());
		}
	}

	// 如何拿到列的信息，字段类型与字段信息
//	public static GenericRow convertFromMap(List<Triple<String, FlinkTypeEnum, LogicalType>> colList,
//			Map<String, String> data, boolean isAfter) {
//		Object[] values = new Object[colList.size()];
//		for (int i = 0; i < values.length; i++) {
//			values[i] = FlinkTypeEnum.getValue(colList.get(i).getMiddle(), data.get(colList.get(i).getLeft()),
//					colList.get(i).getRight());
//		}
//		GenericRow returnObj = GenericRow.ofKind(isAfter ? RowKind.INSERT : RowKind.DELETE, values);
//		return returnObj;
//	}
}
