/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.wicp.tams.common.flink.paimon;

import java.util.HashSet;
import java.util.Set;

import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.CatalogContext;
import org.apache.paimon.catalog.CatalogFactory;
import org.apache.paimon.flink.FlinkFileIOLoader;
import org.apache.paimon.options.ConfigOption;
import org.apache.paimon.options.ConfigOptions;
import org.apache.paimon.options.Options;

import net.wicp.tams.common.flink.catalog.MysqlCatalogFactoryOptions;
import net.wicp.tams.common.flink.common.CatalogAssit;

/** Factory for {@link FlinkCatalog}. */
public class FlinkCatalogFactory implements org.apache.flink.table.factories.CatalogFactory {

	public static final String IDENTIFIER = "tams-paimon";

	public static final ConfigOption<String> DEFAULT_DATABASE = ConfigOptions.key("default-database").stringType()
			.defaultValue(Catalog.DEFAULT_DATABASE);

	@Override
	public String factoryIdentifier() {
		return IDENTIFIER;
	}

	@Override
	public Set<org.apache.flink.configuration.ConfigOption<?>> requiredOptions() {
		final Set<org.apache.flink.configuration.ConfigOption<?>> options = new HashSet<>();
		options.add(MysqlCatalogFactoryOptions.warehouse);
		options.add(MysqlCatalogFactoryOptions.host);
		options.add(MysqlCatalogFactoryOptions.username);
		options.add(MysqlCatalogFactoryOptions.password);
		options.add(MysqlCatalogFactoryOptions.defaultdb);
		options.add(MysqlCatalogFactoryOptions.tenantId);
		options.add(MysqlCatalogFactoryOptions.operate);
		return options;
	}

	@Override
	public Set<org.apache.flink.configuration.ConfigOption<?>> optionalOptions() {
		final Set<org.apache.flink.configuration.ConfigOption<?>> options = new HashSet<>();
		options.add(MysqlCatalogFactoryOptions.port);
		options.add(MysqlCatalogFactoryOptions.url);
		options.add(MysqlCatalogFactoryOptions.urlparam);
		return options;
	}

	@Override
	public FlinkCatalog createCatalog(Context context) {
		// andy 20230623 增加初始化数据
//		final FactoryUtil.CatalogFactoryHelper helper = FactoryUtil.createCatalogFactoryHelper(this, context);
//		helper.validate();
//		final ReadableConfig options = helper.getOptions();
//		MysqlCatalogFactory.packageOptions(options, IDENTIFIER);
		return createCatalog(context.getName(),
				CatalogContext.create(Options.fromMap(context.getOptions()), new FlinkFileIOLoader()),
				context.getClassLoader());
	}

	public static FlinkCatalog createCatalog(String catalogName, CatalogContext context, ClassLoader classLoader) {
		return new FlinkCatalog(CatalogFactory.createCatalog(context, classLoader), catalogName,
				CatalogAssit.catalogDefaultTSDb, classLoader, context.options(),
				context.options().getLong(MysqlCatalogFactoryOptions.tenantId.key(), 0l),
				context.options().getLong(MysqlCatalogFactoryOptions.operate.key(), 1l),
				context.options().get(MysqlCatalogFactoryOptions.defaultdb.key()),
				context.options().get(MysqlCatalogFactoryOptions.warehouse.key()));

	}

	public static FlinkCatalog createCatalog(String catalogName, Catalog catalog, Options options) {
		return new FlinkCatalog(catalog, catalogName, CatalogAssit.catalogDefaultTSDb,
				FlinkCatalogFactory.class.getClassLoader(), options,
				options.getLong(MysqlCatalogFactoryOptions.tenantId.key(), 0l),
				options.getLong(MysqlCatalogFactoryOptions.operate.key(), 1l),
				options.get(MysqlCatalogFactoryOptions.defaultdb.key()),
				options.get(MysqlCatalogFactoryOptions.warehouse.key()));
	}

	public static Catalog createPaimonCatalog(Options catalogOptions) {
		return CatalogFactory.createCatalog(CatalogContext.create(catalogOptions, new FlinkFileIOLoader()));
	}

}