/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.flink.paimon;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.wicp.tams.common.flink.catalog.MysqlCatalogFactoryOptions;
import net.wicp.tams.common.flink.paimon.FlinkCatalog;
import org.apache.flink.table.factories.CatalogFactory;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.CatalogContext;
import org.apache.paimon.flink.FlinkFileIOLoader;
import org.apache.paimon.fs.FileIOLoader;
import org.apache.paimon.options.ConfigOption;
import org.apache.paimon.options.ConfigOptions;
import org.apache.paimon.options.Options;

public class FlinkCatalogFactory
implements CatalogFactory {
    public static final String IDENTIFIER = "tams-paimon";
    public static final ConfigOption<String> DEFAULT_DATABASE = ConfigOptions.key((String)"default-database").stringType().defaultValue((Object)"default");

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<org.apache.flink.configuration.ConfigOption<?>> requiredOptions() {
        HashSet options = new HashSet();
        options.add(MysqlCatalogFactoryOptions.warehouse);
        options.add(MysqlCatalogFactoryOptions.host);
        options.add(MysqlCatalogFactoryOptions.username);
        options.add(MysqlCatalogFactoryOptions.password);
        options.add(MysqlCatalogFactoryOptions.defaultdb);
        options.add(MysqlCatalogFactoryOptions.tenantId);
        options.add(MysqlCatalogFactoryOptions.operate);
        return options;
    }

    public Set<org.apache.flink.configuration.ConfigOption<?>> optionalOptions() {
        HashSet options = new HashSet();
        options.add(MysqlCatalogFactoryOptions.port);
        options.add(MysqlCatalogFactoryOptions.url);
        options.add(MysqlCatalogFactoryOptions.urlparam);
        return options;
    }

    public FlinkCatalog createCatalog(CatalogFactory.Context context) {
        return FlinkCatalogFactory.createCatalog(context.getName(), CatalogContext.create((Options)Options.fromMap((Map)context.getOptions()), (FileIOLoader)new FlinkFileIOLoader()), context.getClassLoader());
    }

    public static FlinkCatalog createCatalog(String catalogName, CatalogContext context, ClassLoader classLoader) {
        return new FlinkCatalog(org.apache.paimon.catalog.CatalogFactory.createCatalog((CatalogContext)context, (ClassLoader)classLoader), catalogName, "duckulats", classLoader, context.options(), context.options().getLong(MysqlCatalogFactoryOptions.tenantId.key(), 0L), context.options().getLong(MysqlCatalogFactoryOptions.operate.key(), 1L), context.options().get(MysqlCatalogFactoryOptions.defaultdb.key()), context.options().get(MysqlCatalogFactoryOptions.warehouse.key()));
    }

    public static FlinkCatalog createCatalog(String catalogName, Catalog catalog, Options options) {
        return new FlinkCatalog(catalog, catalogName, "duckulats", FlinkCatalogFactory.class.getClassLoader(), options, options.getLong(MysqlCatalogFactoryOptions.tenantId.key(), 0L), options.getLong(MysqlCatalogFactoryOptions.operate.key(), 1L), options.get(MysqlCatalogFactoryOptions.defaultdb.key()), options.get(MysqlCatalogFactoryOptions.warehouse.key()));
    }

    public static Catalog createPaimonCatalog(Options catalogOptions) {
        return org.apache.paimon.catalog.CatalogFactory.createCatalog((CatalogContext)CatalogContext.create((Options)catalogOptions, (FileIOLoader)new FlinkFileIOLoader()));
    }
}

