/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common
 * 项目描述：公共的工具集
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.flink.catalog;

import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.factories.CatalogFactory;
import org.apache.flink.table.factories.FactoryUtil;

import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.flink.common.CatalogAssit;

public class MysqlCatalogFactory implements CatalogFactory {

	@Override
	public String factoryIdentifier() {
		return CatalogAssit.IDENTIFIER;
	}

	@Override
	public Set<ConfigOption<?>> requiredOptions() {
		final Set<ConfigOption<?>> options = new HashSet<>();
		options.add(MysqlCatalogFactoryOptions.host);
		options.add(MysqlCatalogFactoryOptions.username);
		options.add(MysqlCatalogFactoryOptions.password);
		options.add(MysqlCatalogFactoryOptions.defaultdb);
		options.add(MysqlCatalogFactoryOptions.tenantId);
		options.add(MysqlCatalogFactoryOptions.operate);
		return options;
	}

	@Override
	public Set<ConfigOption<?>> optionalOptions() {
		final Set<ConfigOption<?>> options = new HashSet<>();
		options.add(MysqlCatalogFactoryOptions.port);
		options.add(MysqlCatalogFactoryOptions.url);
		options.add(MysqlCatalogFactoryOptions.urlparam);
		return options;
	}

	@Override
	public Catalog createCatalog(Context context) {
		final FactoryUtil.CatalogFactoryHelper helper = FactoryUtil.createCatalogFactoryHelper(this, context);
		helper.validate();
		final ReadableConfig options = helper.getOptions();
		packageOptions(options,CatalogAssit.IDENTIFIER);
		return new MysqlCatalog(context.getName(), options.get(MysqlCatalogFactoryOptions.defaultdb),
				options.get(MysqlCatalogFactoryOptions.tenantId), options.get(MysqlCatalogFactoryOptions.operate));
	}

	public static void packageOptions(ReadableConfig options,String IDENTIFIER) {
		Properties props = new Properties();
		String propPre = String.format("common.jdbc.datasource.%s.", IDENTIFIER);
		props.put(propPre + MysqlCatalogFactoryOptions.host.key(), options.get(MysqlCatalogFactoryOptions.host));
		props.put(propPre + MysqlCatalogFactoryOptions.username.key(),
				options.get(MysqlCatalogFactoryOptions.username));
		props.put(propPre + MysqlCatalogFactoryOptions.password.key(),
				options.get(MysqlCatalogFactoryOptions.password));
		props.put(propPre + MysqlCatalogFactoryOptions.port.key(), options.get(MysqlCatalogFactoryOptions.port));
		props.put(propPre + MysqlCatalogFactoryOptions.defaultdb.key(),
				options.get(MysqlCatalogFactoryOptions.defaultdb));
		if (StringUtil.isNotNull(options.get(MysqlCatalogFactoryOptions.url))) {
			props.put(propPre + MysqlCatalogFactoryOptions.url.key(), options.get(MysqlCatalogFactoryOptions.url));
		}
		if (StringUtil.isNotNull(options.get(MysqlCatalogFactoryOptions.urlparam))) {
			props.put(propPre + MysqlCatalogFactoryOptions.urlparam.key(),
					options.get(MysqlCatalogFactoryOptions.urlparam));
		}
		//函数或其它地方需要,
		props.put(CatalogAssit.keyForTenantId, options.get(MysqlCatalogFactoryOptions.tenantId));
		props.put(CatalogAssit.keyForOperate, options.get(MysqlCatalogFactoryOptions.operate));
		
		Conf.overProp(props);
	}
}
