/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common
 * 项目描述：公共的工具集
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.flink.catalog;

import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;

public abstract class MysqlCatalogFactoryOptions {
	public static final String IDENTIFIER = "tams";

	public static final ConfigOption<String> host = ConfigOptions.key("host").stringType().noDefaultValue();
	public static final ConfigOption<Integer> port = ConfigOptions.key("port").intType().defaultValue(3306);
	public static final ConfigOption<String> defaultdb = ConfigOptions.key("defaultdb").stringType().noDefaultValue();

	public static final ConfigOption<String> username = ConfigOptions.key("username").stringType().noDefaultValue();
	public static final ConfigOption<String> password = ConfigOptions.key("password").stringType().noDefaultValue();

	public static final ConfigOption<String> url = ConfigOptions.key("url").stringType().noDefaultValue();
	public static final ConfigOption<String> urlparam = ConfigOptions.key("urlparam").stringType().noDefaultValue();
	
	//租户与操作者，必填。
	public static final ConfigOption<Long> tenantId = ConfigOptions.key("tenantId").longType().noDefaultValue();
	public static final ConfigOption<Long> operate = ConfigOptions.key("operate").longType().noDefaultValue();

}
