package net.wicp.tams.common.es.plugin;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.elasticsearch.action.bulk.BulkItemResponse;

import com.alibaba.druid.util.JdbcUtils;
import com.alibaba.fastjson.JSONObject;

import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.CollectionUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.binlog.alone.Config;
import net.wicp.tams.common.binlog.alone.DuckulaAssit;
import net.wicp.tams.common.binlog.alone.ListenerConf.ColumnType;
import net.wicp.tams.common.binlog.alone.binlog.bean.RuleItem;
import net.wicp.tams.common.binlog.alone.dump.bean.Dump;
import net.wicp.tams.common.binlog.alone.dump.bean.DumpEvent;
import net.wicp.tams.common.binlog.alone.dump.listener.IBusiSender;
import net.wicp.tams.common.constant.dbType.BinlogType;
import net.wicp.tams.common.es.Action;
import net.wicp.tams.common.es.EsData;
import net.wicp.tams.common.es.EsData.Builder;
import net.wicp.tams.common.es.EsObj;
import net.wicp.tams.common.es.RelaValue;
import net.wicp.tams.common.es.UpdateSet;
import net.wicp.tams.common.es.bean.IndexParamsNoJoinBean;
import net.wicp.tams.common.es.bean.IndexSetting;
import net.wicp.tams.common.es.bean.MappingBean;
import net.wicp.tams.common.es.bean.MappingBean.DataTypes;
import net.wicp.tams.common.es.bean.MappingBean.Propertie;
import net.wicp.tams.common.es.client.ESClient;
import net.wicp.tams.common.es.client.singleton.ESClientOnlyOne;
import net.wicp.tams.common.es.client.threadlocal.EsClientThreadlocal;
import net.wicp.tams.common.jdbc.DruidAssit;

/***
 * dumps
 * 
 * @author andy.zhou
 *
 */
@Slf4j
public class DumperEs7 implements IBusiSender<DumpEvent> {

	private static final org.slf4j.Logger errorlog = org.slf4j.LoggerFactory.getLogger("errorBinlog");
	// key为db:tb value:relation
	private volatile static Map<String, JSONObject> relaObjMap = new HashMap<String, JSONObject>();

	// 存储esSetting
	private IndexParamsNoJoinBean indexParamsNoJoinBean;

	private Dump dump;

	private String index;

	private String key;

	private volatile Map<String, DataTypes> relaTomanyMapping;

	/****
	 * 要求在初始化前把ES地址给配置好
	 */
	@Override
	public void init(Dump dump) {
		this.dump = dump;
		Validate.notEmpty(dump.getBusiPluginConfig(), "需要扩展属性，它是一个json且包含有 index值。");
		Validate.notBlank(dump.getBusiPluginConfig().getString("index"), "需要扩展属性，它是一个json且包含有 index值。");
		this.index = dump.getBusiPluginConfig().getString("index");
		String db = StringUtil.isNull(dump.getDbOri()) ? dump.getDbDemo() : dump.getDbOri();
		String tb = StringUtil.isNull(dump.getTbOri()) ? dump.getTbDemo() : dump.getTbOri();
		this.key = String.format("%s:%s", db, tb);
		Connection connection = DruidAssit.getConnection(Config.globleDatasourceName);
		if (!relaObjMap.containsKey(this.key)) {
			synchronized (DumperEs7.class) {
				if (!relaObjMap.containsKey(this.key)) {
					JSONObject relaObj = null;
					Map<String, Propertie> queryMapping_tc_all = ESClientOnlyOne.getInst(connection).getESClient()
							.queryMapping_tc_all(this.index);
					if (queryMapping_tc_all.containsKey(Conf.get("common.es.assit.rela.key"))) {// 含有join
						relaObj = queryMapping_tc_all.get(Conf.get("common.es.assit.rela.key")).getRelations();
					} else {
						relaObj = null;
					}
					relaObjMap.put(this.key, relaObj);
				}
			}
		}
		try {
			connection.close();
		} catch (Exception e) {
		}

		String esSetting = dump.getBusiPluginConfig().getString("esSetting");// 业务插件配置
		if (StringUtil.isNotNull(esSetting)) {
			this.indexParamsNoJoinBean = IndexParamsNoJoinBean.buildByConf(esSetting);
			for (IndexSetting indexSetting : this.indexParamsNoJoinBean.getTableMap().values()) {
				boolean isTomany = indexSetting != null && StringUtil.isNotNull(indexSetting.getRelacol())
						&& indexSetting.isTomany();
				if (isTomany) {
					this.relaTomanyMapping = new HashMap<String, MappingBean.DataTypes>();
					for (int j = 0; j < dump.getNeedCols().length; j++) {
						DataTypes dataTypes = DataTypes.getDataTypesByMysqlType(dump.getNeedColTypes()[j]);
						String keyTrue = Conf.getBoolean("common.es.assit.colname.convert")
								? StringUtil.convertStr(dump.getNeedCols()[j])
								: dump.getNeedCols()[j];
						this.relaTomanyMapping.put(keyTrue, dataTypes);
					}
				}
			}
		}
	}

	/**
	 * 需要的参数：rules、middlewareType、middlewareInst
	 */
	@Override
	public void initParams(JSONObject params) {
	}

	List<String> filterDocIds = new ArrayList<String>();

	@Override
	public void doSend(DumpEvent dataBuilders) {
		ESClient eSClient = EsClientThreadlocal.createPerThreadEsClient();
		Builder esDataBuilder = EsData.newBuilder();
		esDataBuilder.setIndex(index);
		esDataBuilder.setAction(Action.update);
		IndexSetting indexSetting = null;
		if (this.indexParamsNoJoinBean != null) {
			indexSetting = this.indexParamsNoJoinBean.getTableMap().get(String.format(IndexSetting.formate,
					dataBuilders.getDump().getDbDemo(), dataBuilders.getDump().getTbDemo()));
		}
		if (indexSetting != null) {
			esDataBuilder.setUpdateSet(UpdateSet.newBuilder().setUpsert(true).setDoc(true).build());// 增量更新
		} else {
			esDataBuilder.setUpdateSet(UpdateSet.newBuilder().setUpsert(false).build());// 全量更新
		}

		String[] primarys = ArrayUtils.isEmpty(dataBuilders.getDump().getPrimarysLogic())
				? dataBuilders.getDump().getPrimarys()
				: dataBuilders.getDump().getPrimarysLogic();
		boolean hasprimarys = ArrayUtils.isNotEmpty(primarys);
		boolean isTomany = indexSetting != null && StringUtil.isNotNull(indexSetting.getRelacol())
				&& indexSetting.isTomany();
		for (Map<String, String> datamap : dataBuilders.getDatas()) {
			if (isTomany) {// 20201003 // 处理非join类型
				String docId = datamap.get(indexSetting.getRelacol());
				if (docId != null && this.filterDocIds.contains(docId)) {// 已处理了。
					continue;
				}
				esDataBuilder.setIndexColName(String.format(IndexSetting.formate, dataBuilders.getDump().getDbDemo(),
						dataBuilders.getDump().getTbDemo()));
				esDataBuilder.setDocId(docId);
				try {
					List<Map<String, Object>> executeQuery = JdbcUtils
							.executeQuery(DruidAssit.getDataSource(Config.globleDatasourceName),
									"select * from " + dataBuilders.getDump().getDbDemo() + "."
											+ dataBuilders.getDump().getTbDemo() + " where " + indexSetting.getRelacol()
											+ "=?",
									docId);
					for (Map<String, Object> map : executeQuery) {
						EsObj.Builder tempEsObjBuild = EsObj.newBuilder();
						for (String colname : map.keySet()) {
							tempEsObjBuild.putSource(colname, String.valueOf(map.get(colname)));
						}
						esDataBuilder.addDatas(tempEsObjBuild);
					}
				} catch (SQLException e) {
					log.error("非join类型查数据库失败", e);
				}
				this.filterDocIds.add(docId);
			} else {// 有join的模式处理
				EsObj.Builder esObjBuilder = EsObj.newBuilder();
				CollectionUtil.filterNull(datamap, 1);
				esObjBuilder.putAllSource(datamap);
				if (hasprimarys) {
					String[] values = new String[primarys.length];
					for (int j = 0; j < values.length; j++) {
						values[j] = datamap.get(primarys[j]);
					}
					String idstr = CollectionUtil.arrayJoin(values, "-");
					if (StringUtils.isEmpty(idstr)) {
						log.error("id是空值");
						continue;
					}
					// 关联关系支持 20181201
					String tableNameTrue = StringUtil.isNull(dump.getTbOri()) ? dump.getTbDemo() : dump.getTbOri();
					boolean isroot = MappingBean.isRoot(relaObjMap.get(this.key), tableNameTrue,
							tableNameTrue.length());
					if (isroot) {// 根元素或是没有关联关联的索引
						esObjBuilder.setId(idstr);
						if (relaObjMap.get(this.key) != null) {
							esObjBuilder.setRelaValue(RelaValue.newBuilder().setName(tableNameTrue));// tams_relations
						}
					} else {// 有关联关系且不是根元素
						String relaName = MappingBean.getRelaName(relaObjMap.get(this.key), tableNameTrue,
								tableNameTrue.length());
						String[] relaNameAry = relaName.split(":");
						String parentId = datamap.get(relaNameAry[1]);
						esObjBuilder.setId(String.format("%s:%s", dataBuilders.getDump().getTbOri(), idstr));// 有可能与主表id相同把主表的ID冲掉
						if (StringUtils.isBlank(parentId)) {// 关联关系没有parent
							errorlog.error(esObjBuilder.toString());// 打错误日志跳过
							continue;
						}
						esObjBuilder.setRelaValue(RelaValue.newBuilder().setName(relaName).setParent(parentId));// tams_relations
					}
				}
				if (indexSetting != null && StringUtil.isNotNull(indexSetting.getRelacol())
						&& !indexSetting.isTomany()) {// 20201003
														// nojoin
														// 一对一
					esObjBuilder.setIndexColName(String.format(IndexSetting.formate, dataBuilders.getDump().getDbDemo(),
							dataBuilders.getDump().getTbDemo()));
				}
				esDataBuilder.addDatas(esObjBuilder.build());
			}

		}
		Result ret = null;
		if (isTomany) {
			ret = eSClient.docWriteBatch_tc(this.relaTomanyMapping, esDataBuilder.build());

		} else {
			ret = eSClient.docWriteBatch_tc(esDataBuilder.build());
		}

		if (!ret.isSuc()) {
			errorlog.error("message:{}", ret.getMessage());
			BulkItemResponse[] retObjs = (BulkItemResponse[]) ret.retObjs();
			if (retObjs != null) {
				for (BulkItemResponse bulkItemResponse : retObjs) {
					if (bulkItemResponse.isFailed()) {
						log.error("send error,id:[{}],reason:[{}]", bulkItemResponse.getId(),
								bulkItemResponse.getFailure());// TODO 错误处理
					}
				}
			}
			throw new RuntimeException("发送ES失败,由sendHander重试");
		}
	}
}
