package net.wicp.tams.common.es.plugin;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;
import org.elasticsearch.action.bulk.BulkItemResponse;

import com.alibaba.fastjson.JSONObject;

import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.CollectionUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.binlog.alone.DuckulaAssit;
import net.wicp.tams.common.binlog.alone.ListenerConf.ColHis;
import net.wicp.tams.common.binlog.alone.ListenerConf.DuckulaEvent;
import net.wicp.tams.common.binlog.alone.ListenerConf.OptType;
import net.wicp.tams.common.binlog.alone.binlog.bean.Rule;
import net.wicp.tams.common.binlog.alone.binlog.bean.RuleItem;
import net.wicp.tams.common.binlog.alone.binlog.listener.AbsBinlogListener;
import net.wicp.tams.common.es.Action;
import net.wicp.tams.common.es.EsData;
import net.wicp.tams.common.es.EsData.Builder;
import net.wicp.tams.common.es.EsObj;
import net.wicp.tams.common.es.RelaValue;
import net.wicp.tams.common.es.UpdateSet;
import net.wicp.tams.common.es.bean.MappingBean;
import net.wicp.tams.common.es.bean.MappingBean.DataTypes;
import net.wicp.tams.common.es.bean.MappingBean.Propertie;
import net.wicp.tams.common.es.client.ESClient;
import net.wicp.tams.common.es.client.threadlocal.EsClientThreadlocal;
import net.wicp.tams.common.jdbc.DruidAssit;

@Slf4j
public class ListenerEs7 extends AbsBinlogListener {
	protected static final org.slf4j.Logger errorlog = org.slf4j.LoggerFactory.getLogger("errorBinlog");// 需要跳过的错误数据。

	private final String keyFormate = "%s:%s";
	// 存储rela的json对象
	private Map<String, JSONObject> relaMapToEs = new HashMap<>();

	@Override
	public void doInit(Rule rule, int index) {
		Validate.isTrue(StringUtil.isNotNull(rule.getItems().get(RuleItem.index)), "每组规则都需要配置index。");
		Connection mainConn = DruidAssit.getConnection(connConf.getConfName());
		// 自动创建索引 只做一次检查就好了
		if (index == 0) {//
			// 每个实例监听都会去偿试创建新索引
			// 初始化clinet的时个会检查索引是否创建
			EsClientThreadlocal.createPerThreadEsClient(mainConn);
		}
		try {
			mainConn.close();
		} catch (SQLException e) {
			log.error("close the conn error", e);
		}
	}

	@Override
	public void doBusiTrue(Rule rule, DuckulaEvent duckulaEvent) {
		String index = rule.getItems().get(RuleItem.index);
		String type = "_doc";
		String key = String.format(keyFormate, index, type);
		// 查看index是否有关联关系，一般有2张表肯定有关联关系
		if (!relaMapToEs.containsKey(key)) {
			ESClient esClient = EsClientThreadlocal.createPerThreadEsClient();
			Map<String, Propertie> queryMapping_tc_all = esClient.queryMapping_tc_all(index);
			String relationKey = StringUtil.hasNull(Conf.get("common.es.assit.rela.key"), "tams_relations");
			if (queryMapping_tc_all.containsKey(relationKey)) {
				JSONObject relations = queryMapping_tc_all.get(relationKey).getRelations();
				relaMapToEs.put(key, relations);
			} else {
				relaMapToEs.put(key, null);
			}
		}

		Builder esDataBuilder = EsData.newBuilder();
		esDataBuilder.setIndex(index);
		esDataBuilder.setUpdateSet(UpdateSet.newBuilder().setUpsert(true).build());
		esDataBuilder.setAction(duckulaEvent.getOptType() == OptType.delete ? Action.delete : Action.update);

		for (int i = 0; i < duckulaEvent.getItemsCount(); i++) {
			EsObj.Builder esObjBuilder = EsObj.newBuilder();
			String primaryName = StringUtil.isNull(rule.getItems().get(RuleItem.primarysLogic))
					? (StringUtil.isNull(rule.getItems().get(RuleItem.key)) ? duckulaEvent.getCols(0)
							: rule.getItems().get(RuleItem.key))
					: rule.getItems().get(RuleItem.primarysLogic);
			String idStr = DuckulaAssit.getValueStr(duckulaEvent, i, primaryName);

			Map<String, String> valueMap = DuckulaAssit.getValueMap(duckulaEvent, i);
			CollectionUtil.filterNull(valueMap, 1);
			esObjBuilder.putAllSource(valueMap);
			JSONObject relaJson = relaMapToEs.get(key);
			esObjBuilder.setVersion(duckulaEvent.getItems(i).getVersion());// 设置好版本
			boolean isroot = MappingBean.isRoot(relaJson, duckulaEvent.getTb(), rule.getTbLength());
			if (isroot) {
				if (relaJson != null) {
					String tableNameTrue = rule.getTbOri();
					esObjBuilder.setRelaValue(RelaValue.newBuilder().setName(tableNameTrue));// tams_relations
				}
				esObjBuilder.setId(idStr);
				esDataBuilder.addDatas(esObjBuilder);
			} else {// 有关联关系且不是根元素
				String relaName = MappingBean.getRelaName(relaJson, duckulaEvent.getTb(), rule.getTbLength());
				String[] relaNameAry = relaName.split(":");
				String parentId = esObjBuilder.getSourceMap().get(relaNameAry[1]);// 需考虑幂等情况
																					// DuckulaAssit.getValueStr(duckulaEvent,
				// relaNameAry[1]);
				// 202020420 Andy，如果是drds类型的，需要去除具体的随机码信息
				esObjBuilder.setId(String.format("%s:%s", rule.getTbOri(), idStr));// 有可能与主表id相同把主表的ID冲掉
				if (StringUtils.isBlank(parentId)) {// 关联关系没有parent
					log.error("===parentid is null.请确认关联的字段是否正确，需要和数据库字段名保持一致。");
					errorlog.error(esObjBuilder.toString());// 打错误日志跳过
				} else {// 记住：删除也需要parentId的信息，否则会没有效果
					esObjBuilder.setRelaValue(RelaValue.newBuilder().setName(relaName).setParent(parentId));// tams_relations
					esDataBuilder.addDatas(esObjBuilder);
				}

			}
		}
		if (esDataBuilder.getDatasCount() == 0) {// 没有数据（最有可能就是parentId为空值。）
			return;
		}
		ESClient esClient = EsClientThreadlocal.createPerThreadEsClient();
		// log.info("inputparam={}",esDataBuilder);
		Result docWriteBatch_tc = esClient.docWriteBatch_tc(esDataBuilder.build());
		//
		if (!docWriteBatch_tc.isSuc()) {// 错误处理
			BulkItemResponse[] retobj = (BulkItemResponse[]) docWriteBatch_tc.retObjs();
			for (BulkItemResponse bulkItemResponse : retobj) {
				errorlog.error(bulkItemResponse.getFailure().toString());
			}
		}
	}

	// sql如果有默认值，也不做全索引同步，代价太大了。需要手动实现全量同步
	@Override
	public Result doAlterTableCallBack(Rule rule, ColHis colHis, String sql) {
		ESClient esClient = EsClientThreadlocal.createPerThreadEsClient();
		if (rule == null) {
			return Result.getSuc();// 不是我们关心的索引
		}
		String index = rule.getItems().get(RuleItem.index);

		List<Pair<String, String>> params = new ArrayList<Pair<String, String>>();
		for (int i = 0; i < colHis.getColsCount(); i++) {
			params.add(Pair.of(colHis.getCols(i), colHis.getColTypes(i)));
		}
		Map<String, Pair<DataTypes, DataTypes>> queryDiffMapping_tc = esClient.queryDiffMapping_tc(index, params,
				false);
		MappingBean proMappingBean = esClient.proMappingBean(queryDiffMapping_tc);
		Result addFields = esClient.updateIndex(index, proMappingBean);
		log.info("add col [{}] to index:[{}],the result is:{}", queryDiffMapping_tc, index,
				addFields.isSuc() ? "sucess" : addFields.getMessage());
		return addFields;
	}

}
