/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.es.plugin;

import com.alibaba.fastjson.JSONObject;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.CollectionUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.binlog.alone.DuckulaAssit;
import net.wicp.tams.common.binlog.alone.ListenerConf;
import net.wicp.tams.common.binlog.alone.binlog.bean.Rule;
import net.wicp.tams.common.binlog.alone.binlog.bean.RuleItem;
import net.wicp.tams.common.binlog.alone.binlog.listener.AbsBinlogListener;
import net.wicp.tams.common.es.Action;
import net.wicp.tams.common.es.EsData;
import net.wicp.tams.common.es.EsObj;
import net.wicp.tams.common.es.RelaValue;
import net.wicp.tams.common.es.UpdateSet;
import net.wicp.tams.common.es.bean.MappingBean;
import net.wicp.tams.common.es.client.ESClient;
import net.wicp.tams.common.es.client.threadlocal.EsClientThreadlocal;
import net.wicp.tams.common.jdbc.DruidAssit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListenerEs6
extends AbsBinlogListener {
    private static final Logger log = LoggerFactory.getLogger(ListenerEs6.class);
    protected static final Logger errorlog = LoggerFactory.getLogger((String)"errorBinlog");
    private final String keyFormate = "%s:%s";
    private Map<String, JSONObject> relaMapToEs = new HashMap<String, JSONObject>();

    public void doInit(Rule rule, int index) {
        Validate.isTrue((boolean)StringUtil.isNotNull(rule.getItems().get(RuleItem.index)), (String)"\u6bcf\u7ec4\u89c4\u5219\u90fd\u9700\u8981\u914d\u7f6eindex\u3002", (Object[])new Object[0]);
        Connection mainConn = DruidAssit.getConnection((String)this.connConf.getConfName());
        if (index == 0) {
            EsClientThreadlocal.createPerThreadEsClient((Connection)mainConn);
        }
        try {
            mainConn.close();
        }
        catch (SQLException e) {
            log.error("close the conn error", (Throwable)e);
        }
    }

    public void doBusiTrue(Rule rule, ListenerConf.DuckulaEvent duckulaEvent) {
        String type;
        String index = (String)rule.getItems().get(RuleItem.index);
        String key = String.format("%s:%s", index, type = StringUtil.isNull(rule.getItems().get(RuleItem.type)) ? "_doc" : (String)rule.getItems().get(RuleItem.type));
        if (!this.relaMapToEs.containsKey(key)) {
            String relationKey;
            ESClient esClient = EsClientThreadlocal.createPerThreadEsClient();
            Map queryMapping_tc_all = esClient.queryMapping_tc_all(index);
            if (queryMapping_tc_all.containsKey(relationKey = StringUtil.hasNull((String[])new String[]{Conf.get((String)"common.es.assit.rela.key"), "tams_relations"}))) {
                JSONObject relations = ((MappingBean.Propertie)queryMapping_tc_all.get(relationKey)).getRelations();
                this.relaMapToEs.put(key, relations);
            } else {
                this.relaMapToEs.put(key, null);
            }
        }
        EsData.Builder esDataBuilder = EsData.newBuilder();
        esDataBuilder.setIndex(index);
        esDataBuilder.setType(type);
        esDataBuilder.setUpdateSet(UpdateSet.newBuilder().setUpsert(true).build());
        esDataBuilder.setAction(duckulaEvent.getOptType() == ListenerConf.OptType.delete ? Action.delete : Action.update);
        for (int i = 0; i < duckulaEvent.getItemsCount(); ++i) {
            EsObj.Builder esObjBuilder = EsObj.newBuilder();
            String primaryName = StringUtil.isNull(rule.getItems().get(RuleItem.primarysLogic)) ? (StringUtil.isNull(rule.getItems().get(RuleItem.key)) ? duckulaEvent.getCols(0) : (String)rule.getItems().get(RuleItem.key)) : (String)rule.getItems().get(RuleItem.primarysLogic);
            String idStr = DuckulaAssit.getValueStr((ListenerConf.DuckulaEvent)duckulaEvent, (int)i, (String)primaryName);
            Map valueMap = DuckulaAssit.getValueMap((ListenerConf.DuckulaEvent)duckulaEvent, (int)i);
            CollectionUtil.filterNull((Map)valueMap, (int)1);
            esObjBuilder.putAllSource(valueMap);
            JSONObject relaJson = this.relaMapToEs.get(key);
            boolean isroot = MappingBean.isRoot((JSONObject)relaJson, (String)duckulaEvent.getTb(), (int)rule.getTbLength());
            if (isroot) {
                if (relaJson != null) {
                    String tableNameTrue = rule.getTbOri();
                    esObjBuilder.setRelaValue(RelaValue.newBuilder().setName(tableNameTrue));
                }
                esObjBuilder.setId(idStr);
                esDataBuilder.addDatas(esObjBuilder);
                continue;
            }
            String relaName = MappingBean.getRelaName((JSONObject)relaJson, (String)duckulaEvent.getTb(), (int)rule.getTbLength());
            String[] relaNameAry = relaName.split(":");
            String parentId = (String)esObjBuilder.getSourceMap().get(relaNameAry[1]);
            esObjBuilder.setId(String.format("%s:%s", rule.getTbOri(), idStr));
            if (StringUtils.isBlank((CharSequence)parentId)) {
                log.error("===parentid is null.\u8bf7\u786e\u8ba4\u5173\u8054\u7684\u5b57\u6bb5\u662f\u5426\u6b63\u786e\uff0c\u9700\u8981\u548c\u6570\u636e\u5e93\u5b57\u6bb5\u540d\u4fdd\u6301\u4e00\u81f4\u3002");
                errorlog.error(esObjBuilder.toString());
                continue;
            }
            esObjBuilder.setRelaValue(RelaValue.newBuilder().setName(relaName).setParent(parentId));
            esDataBuilder.addDatas(esObjBuilder);
        }
        if (esDataBuilder.getDatasCount() == 0) {
            return;
        }
        ESClient esClient = EsClientThreadlocal.createPerThreadEsClient();
        Result docWriteBatch_tc = esClient.docWriteBatch_tc(new EsData[]{esDataBuilder.build()});
        if (!docWriteBatch_tc.isSuc()) {
            BulkItemResponse[] retobj;
            for (BulkItemResponse bulkItemResponse : retobj = (BulkItemResponse[])docWriteBatch_tc.retObjs()) {
                errorlog.error(bulkItemResponse.getFailure().toString());
            }
        }
    }

    public Result doAlterTableCallBack(Rule rule, ListenerConf.ColHis colHis, String sql) {
        ESClient esClient = EsClientThreadlocal.createPerThreadEsClient();
        if (rule == null) {
            return Result.getSuc();
        }
        String index = (String)rule.getItems().get(RuleItem.index);
        ArrayList<Pair> params = new ArrayList<Pair>();
        for (int i = 0; i < colHis.getColsCount(); ++i) {
            params.add(Pair.of((Object)colHis.getCols(i), (Object)colHis.getColTypes(i)));
        }
        Map queryDiffMapping_tc = esClient.queryDiffMapping_tc(index, params, false);
        MappingBean proMappingBean = esClient.proMappingBean(queryDiffMapping_tc);
        Result addFields = esClient.updateIndex(index, proMappingBean);
        return addFields;
    }
}

