/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.es.plugin;

import com.alibaba.fastjson.JSONObject;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.CollectionUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.binlog.alone.dump.bean.Dump;
import net.wicp.tams.common.binlog.alone.dump.bean.DumpEvent;
import net.wicp.tams.common.binlog.alone.dump.listener.IBusiSender;
import net.wicp.tams.common.es.Action;
import net.wicp.tams.common.es.EsData;
import net.wicp.tams.common.es.EsObj;
import net.wicp.tams.common.es.RelaValue;
import net.wicp.tams.common.es.UpdateSet;
import net.wicp.tams.common.es.bean.MappingBean;
import net.wicp.tams.common.es.client.ESClient;
import net.wicp.tams.common.es.client.singleton.ESClientOnlyOne;
import net.wicp.tams.common.es.client.threadlocal.EsClientThreadlocal;
import net.wicp.tams.common.jdbc.DruidAssit;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DumperEs6
implements IBusiSender<DumpEvent> {
    private static final Logger log = LoggerFactory.getLogger(DumperEs6.class);
    private static final Logger errorlog = LoggerFactory.getLogger((String)"errorBinlog");
    private static volatile Map<String, JSONObject> relaObjMap = new HashMap<String, JSONObject>();
    private Dump dump;
    private String index;
    private String type;
    private String key;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void init(Dump dump) {
        this.dump = dump;
        Validate.notEmpty((Map)dump.getBusiPluginConfig(), (String)"\u9700\u8981\u6269\u5c55\u5c5e\u6027\uff0c\u5b83\u662f\u4e00\u4e2ajson\u4e14\u5305\u542b\u6709 index\u503c\u3002", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dump.getBusiPluginConfig().getString("index"), (String)"\u9700\u8981\u6269\u5c55\u5c5e\u6027\uff0c\u5b83\u662f\u4e00\u4e2ajson\u4e14\u5305\u542b\u6709 index\u503c\u3002", (Object[])new Object[0]);
        this.index = dump.getBusiPluginConfig().getString("index");
        this.type = StringUtil.hasNull((String[])new String[]{dump.getBusiPluginConfig().getString("type"), "_doc"});
        String db = StringUtil.isNull((Object)dump.getDbOri()) ? dump.getDb() : dump.getDbOri();
        String tb = StringUtil.isNull((Object)dump.getTbOri()) ? dump.getTb() : dump.getTbOri();
        this.key = String.format("%s:%s", db, tb);
        Connection connection = DruidAssit.getConnection((String)"_global");
        if (!relaObjMap.containsKey(this.key)) {
            Class<DumperEs6> clazz = DumperEs6.class;
            // MONITORENTER : net.wicp.tams.common.es.plugin.DumperEs6.class
            if (!relaObjMap.containsKey(this.key)) {
                JSONObject relaObj = null;
                Map queryMapping_tc_all = ESClientOnlyOne.getInst((Connection)connection).getESClient().queryMapping_tc_all(this.index);
                relaObj = queryMapping_tc_all.containsKey(Conf.get((String)"common.es.assit.rela.key")) ? ((MappingBean.Propertie)queryMapping_tc_all.get(Conf.get((String)"common.es.assit.rela.key"))).getRelations() : null;
                relaObjMap.put(this.key, relaObj);
            }
            // MONITOREXIT : clazz
        }
        try {
            connection.close();
            return;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void initParams(JSONObject params) {
    }

    public void doSend(DumpEvent dataBuilders) {
        ESClient eSClient = EsClientThreadlocal.createPerThreadEsClient();
        EsData.Builder esDataBuilder = EsData.newBuilder();
        esDataBuilder.setIndex(this.index);
        esDataBuilder.setType(this.type);
        esDataBuilder.setAction(Action.update);
        esDataBuilder.setUpdateSet(UpdateSet.newBuilder().setUpsert(true).build());
        Object[] primarys = ArrayUtils.isEmpty((Object[])dataBuilders.getDump().getPrimarysLogic()) ? dataBuilders.getDump().getPrimarys() : dataBuilders.getDump().getPrimarysLogic();
        boolean hasprimarys = ArrayUtils.isNotEmpty((Object[])primarys);
        for (Map datamap : dataBuilders.getDatas()) {
            EsObj.Builder esObjBuilder = EsObj.newBuilder();
            CollectionUtil.filterNull((Map)datamap, (int)1);
            esObjBuilder.putAllSource(datamap);
            if (hasprimarys) {
                Object[] values = new String[primarys.length];
                for (int j = 0; j < values.length; ++j) {
                    values[j] = (String)datamap.get(primarys[j]);
                }
                String idstr = CollectionUtil.arrayJoin((Object[])values, (String)"-");
                if (StringUtils.isEmpty((CharSequence)idstr)) {
                    log.error("id\u662f\u7a7a\u503c");
                    continue;
                }
                String tableNameTrue = StringUtil.isNull((Object)this.dump.getTbOri()) ? this.dump.getTb() : this.dump.getTbOri();
                boolean isroot = MappingBean.isRoot((JSONObject)relaObjMap.get(this.key), (String)tableNameTrue, (int)tableNameTrue.length());
                if (isroot) {
                    esObjBuilder.setId(idstr);
                    if (relaObjMap.get(this.key) != null) {
                        esObjBuilder.setRelaValue(RelaValue.newBuilder().setName(tableNameTrue));
                    }
                } else {
                    String relaName = MappingBean.getRelaName((JSONObject)relaObjMap.get(this.key), (String)tableNameTrue, (int)tableNameTrue.length());
                    String[] relaNameAry = relaName.split(":");
                    String parentId = (String)datamap.get(relaNameAry[1]);
                    esObjBuilder.setId(String.format("%s:%s", dataBuilders.getDump().getTbOri(), idstr));
                    if (StringUtils.isBlank((CharSequence)parentId)) {
                        errorlog.error(esObjBuilder.toString());
                        continue;
                    }
                    esObjBuilder.setRelaValue(RelaValue.newBuilder().setName(relaName).setParent(parentId));
                }
            }
            esDataBuilder.addDatas(esObjBuilder.build());
        }
        Result ret = eSClient.docWriteBatch_tc(new EsData[]{esDataBuilder.build()});
        if (!ret.isSuc()) {
            BulkItemResponse[] retObjs;
            for (BulkItemResponse bulkItemResponse : retObjs = (BulkItemResponse[])ret.retObjs()) {
                if (!bulkItemResponse.isFailed()) continue;
                log.error("send error,id:[{}],reason:[{}]", (Object)bulkItemResponse.getId(), (Object)bulkItemResponse.getFailure());
            }
            throw new RuntimeException("\u53d1\u9001ES\u5931\u8d25,\u7531sendHander\u91cd\u8bd5");
        }
    }
}

