/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.es.plugin;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.CollectionUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.binlog.alone.DuckulaAssit;
import net.wicp.tams.common.binlog.alone.ListenerConf;
import net.wicp.tams.common.binlog.alone.binlog.bean.Rule;
import net.wicp.tams.common.binlog.alone.binlog.bean.RuleItem;
import net.wicp.tams.common.binlog.alone.binlog.listener.AbsBinlogListener;
import net.wicp.tams.common.es.Action;
import net.wicp.tams.common.es.EsData;
import net.wicp.tams.common.es.EsObj;
import net.wicp.tams.common.es.RelaValue;
import net.wicp.tams.common.es.UpdateSet;
import net.wicp.tams.common.es.bean.MappingBean;
import net.wicp.tams.common.es.client.ESClient;
import net.wicp.tams.common.es.client.threadlocal.EsClientThreadlocal;
import net.wicp.tams.common.jdbc.DruidAssit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListenerEs5
extends AbsBinlogListener {
    private static final Logger log = LoggerFactory.getLogger(ListenerEs5.class);
    protected static final Logger errorlog = LoggerFactory.getLogger((String)"errorBinlog");
    private static volatile Map<String, String> typeMap = new HashMap<String, String>();

    public void doInit(Rule rule, int index) {
        Validate.isTrue((boolean)StringUtil.isNotNull(rule.getItems().get(RuleItem.index)), (String)"\u6bcf\u7ec4\u89c4\u5219\u90fd\u9700\u8981\u914d\u7f6eindex\u3002", (Object[])new Object[0]);
        Connection mainConn = DruidAssit.getConnection((String)this.connConf.getConfName());
        if (index == 0) {
            EsClientThreadlocal.createPerThreadEsClient((Connection)mainConn);
        }
        try {
            mainConn.close();
        }
        catch (SQLException e) {
            log.error("close the conn error", (Throwable)e);
        }
    }

    public void doBusiTrue(Rule rule, ListenerConf.DuckulaEvent duckulaEvent) {
        EsData.Builder esDataBuilder = EsData.newBuilder();
        esDataBuilder.setIndex((String)rule.getItems().get(RuleItem.index));
        esDataBuilder.setType(typeMap.get(rule.getTbOri()));
        esDataBuilder.setUpdateSet(UpdateSet.newBuilder().setUpsert(true).build());
        esDataBuilder.setAction(duckulaEvent.getOptType() == ListenerConf.OptType.delete ? Action.delete : Action.update);
        for (int i = 0; i < duckulaEvent.getItemsCount(); ++i) {
            EsObj.Builder esObjBuilder = EsObj.newBuilder();
            Map<String, String> datamap = this.makeSource(duckulaEvent, i);
            CollectionUtil.filterNull(datamap, (int)1);
            esObjBuilder.putAllSource(datamap);
            String primaryName = StringUtil.isNull(rule.getItems().get(RuleItem.primarysLogic)) ? duckulaEvent.getCols(0) : (String)rule.getItems().get(RuleItem.primarysLogic);
            String idStr = DuckulaAssit.getValueStr((ListenerConf.DuckulaEvent)duckulaEvent, (int)i, (String)primaryName);
            esObjBuilder.setId(idStr);
            if (StringUtil.isNotNull(rule.getItems().get(RuleItem.relakey))) {
                String parentId = datamap.get(rule.getItems().get(RuleItem.relakey));
                if (StringUtils.isBlank((CharSequence)parentId)) {
                    log.error("===parentid is null.\u8bf7\u786e\u8ba4\u5173\u8054\u7684\u5b57\u6bb5\u662f\u5426\u6b63\u786e\uff0c\u9700\u8981\u548c\u6570\u636e\u5e93\u5b57\u6bb5\u540d\u4fdd\u6301\u4e00\u81f4\u3002");
                    errorlog.error(esObjBuilder.toString());
                    continue;
                }
                esObjBuilder.setRelaValue(RelaValue.newBuilder().setParent(parentId));
                esDataBuilder.addDatas(esObjBuilder);
                continue;
            }
            esDataBuilder.addDatas(esObjBuilder);
        }
        if (esDataBuilder.getDatasCount() == 0) {
            return;
        }
        ESClient esClient = EsClientThreadlocal.createPerThreadEsClient();
        esClient.docWriteBatch_tc(new EsData[]{esDataBuilder.build()});
    }

    private Map<String, String> makeSource(ListenerConf.DuckulaEvent duckulaEvent, int index) {
        String[] keys = new String[]{duckulaEvent.getCols(0)};
        Serializable[] keyValues = new Serializable[]{DuckulaAssit.getValue((ListenerConf.DuckulaEvent)duckulaEvent, (String)duckulaEvent.getCols(0), (int)index)};
        HashMap<String, String> datamap = new HashMap<String, String>();
        if (duckulaEvent.getOptType() == ListenerConf.OptType.delete) {
            for (int i = 0; i < keyValues.length; ++i) {
                datamap.put(keys[i], String.valueOf(keyValues[i]));
            }
        } else {
            for (String colName : duckulaEvent.getColsList()) {
                String valuestr = DuckulaAssit.getValueStr((ListenerConf.DuckulaEvent)duckulaEvent, (int)index, (String)colName);
                datamap.put(colName, valuestr);
            }
        }
        CollectionUtil.filterNull(datamap, (int)1);
        return datamap;
    }

    public Result doAlterTableCallBack(Rule rule, ListenerConf.ColHis colHis, String sql) {
        ESClient esClient = EsClientThreadlocal.createPerThreadEsClient();
        if (rule == null) {
            return Result.getSuc();
        }
        String index = (String)rule.getItems().get(RuleItem.index);
        String type = (String)rule.getItems().get(RuleItem.type);
        ArrayList<Pair> params = new ArrayList<Pair>();
        for (int i = 0; i < colHis.getColsCount(); ++i) {
            params.add(Pair.of((Object)colHis.getCols(i), (Object)colHis.getColTypes(i)));
        }
        Map queryDiffMapping_tc = esClient.queryDiffMapping_tc(index, params, false);
        MappingBean proMappingBean = esClient.proMappingBean(queryDiffMapping_tc, type);
        Result addFields = esClient.updateIndex(index, type, proMappingBean);
        return addFields;
    }
}

