/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.es.plugin;

import com.alibaba.fastjson.JSONObject;
import java.sql.Connection;
import java.util.Map;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.CollectionUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.binlog.alone.dump.bean.Dump;
import net.wicp.tams.common.binlog.alone.dump.bean.DumpEvent;
import net.wicp.tams.common.binlog.alone.dump.listener.IBusiSender;
import net.wicp.tams.common.es.Action;
import net.wicp.tams.common.es.EsData;
import net.wicp.tams.common.es.EsObj;
import net.wicp.tams.common.es.RelaValue;
import net.wicp.tams.common.es.UpdateSet;
import net.wicp.tams.common.es.client.ESClient;
import net.wicp.tams.common.es.client.threadlocal.EsClientThreadlocal;
import net.wicp.tams.common.jdbc.DruidAssit;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DumperEs5
implements IBusiSender<DumpEvent> {
    private static final Logger log = LoggerFactory.getLogger(DumperEs5.class);
    private static final Logger errorlog = LoggerFactory.getLogger((String)"errorBinlog");
    private String index;
    private String type;
    private String relaColName;
    private Connection connection;

    public void init(Dump dump) {
        Validate.notEmpty((Map)dump.getBusiPluginConfig(), (String)"\u9700\u8981\u6269\u5c55\u5c5e\u6027\uff0c\u5b83\u662f\u4e00\u4e2ajson\u4e14\u5305\u542b\u6709 index\u503c\u3002", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dump.getBusiPluginConfig().getString("index"), (String)"\u9700\u8981\u6269\u5c55\u5c5e\u6027\uff0c\u5b83\u662f\u4e00\u4e2ajson\u4e14\u5305\u542b\u6709 index\u503c\u3002", (Object[])new Object[0]);
        this.index = dump.getBusiPluginConfig().getString("index");
        if (dump.getBusiPluginConfig().containsKey((Object)"relaColName")) {
            this.relaColName = dump.getBusiPluginConfig().getString("relaColName");
        }
        if (!dump.getBusiPluginConfig().containsKey((Object)"type")) {
            String db = StringUtil.isNull((Object)dump.getDbOri()) ? dump.getDb() : dump.getDbOri();
            String tb = StringUtil.isNull((Object)dump.getTbOri()) ? dump.getTb() : dump.getTbOri();
            this.type = String.format("%s-%s", db, tb);
        } else {
            this.type = dump.getBusiPluginConfig().getString("type");
        }
        this.connection = DruidAssit.getConnection((String)"_global");
    }

    public void initParams(JSONObject params) {
    }

    public void doSend(DumpEvent dataBuilders) {
        ESClient eSClient = EsClientThreadlocal.createPerThreadEsClient((Connection)this.connection);
        EsData.Builder esDataBuilder = EsData.newBuilder();
        esDataBuilder.setIndex(this.index);
        esDataBuilder.setType(this.type);
        esDataBuilder.setAction(Action.update);
        esDataBuilder.setUpdateSet(UpdateSet.newBuilder().setUpsert(true).build());
        Object[] primarys = ArrayUtils.isEmpty((Object[])dataBuilders.getDump().getPrimarysLogic()) ? dataBuilders.getDump().getPrimarys() : dataBuilders.getDump().getPrimarysLogic();
        boolean hasprimarys = ArrayUtils.isNotEmpty((Object[])primarys);
        for (Map datamap : dataBuilders.getDatas()) {
            EsObj.Builder esObjBuilder = EsObj.newBuilder();
            CollectionUtil.filterNull((Map)datamap, (int)1);
            esObjBuilder.putAllSource(datamap);
            if (hasprimarys) {
                Object[] values = new String[primarys.length];
                for (int j = 0; j < values.length; ++j) {
                    values[j] = (String)datamap.get(primarys[j]);
                }
                String idstr = CollectionUtil.arrayJoin((Object[])values, (String)"-");
                if (StringUtils.isEmpty((CharSequence)idstr)) {
                    log.error("id\u662f\u7a7a\u503c");
                    continue;
                }
                esObjBuilder.setId(idstr);
                if (StringUtil.isNotNull((Object)this.relaColName)) {
                    String parentId = (String)datamap.get(this.relaColName);
                    esObjBuilder.setId(idstr);
                    if (StringUtils.isBlank((CharSequence)parentId)) {
                        errorlog.error(esObjBuilder.toString());
                        continue;
                    }
                    RelaValue relaValue = RelaValue.newBuilder().setName(this.relaColName).setParent(parentId).build();
                    esObjBuilder.setRelaValue(relaValue);
                }
            }
            esDataBuilder.addDatas(esObjBuilder.build());
        }
        String aaa = (String)esDataBuilder.getDatas(0).getSourceMap().get("update_time");
        Result ret = eSClient.docWriteBatch_tc(new EsData[]{esDataBuilder.build()});
        if (!ret.isSuc()) {
            BulkItemResponse[] retObjs;
            for (BulkItemResponse bulkItemResponse : retObjs = (BulkItemResponse[])ret.retObjs()) {
                if (!bulkItemResponse.isFailed()) continue;
                log.error("send error,id:[{}],reason:[{}]", (Object)bulkItemResponse.getId(), (Object)bulkItemResponse.getFailure());
            }
            throw new RuntimeException("\u53d1\u9001ES\u5931\u8d25,\u7531sendHander\u91cd\u8bd5");
        }
    }
}

