package net.wicp.tams.common.es.plugin;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;

import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.CollectionUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.binlog.alone.DuckulaAssit;
import net.wicp.tams.common.binlog.alone.ListenerConf.ColHis;
import net.wicp.tams.common.binlog.alone.ListenerConf.DuckulaEvent;
import net.wicp.tams.common.binlog.alone.ListenerConf.OptType;
import net.wicp.tams.common.binlog.alone.binlog.bean.Rule;
import net.wicp.tams.common.binlog.alone.binlog.bean.RuleItem;
import net.wicp.tams.common.binlog.alone.binlog.listener.AbsBinlogListener;
import net.wicp.tams.common.es.Action;
import net.wicp.tams.common.es.EsData;
import net.wicp.tams.common.es.EsData.Builder;
import net.wicp.tams.common.es.EsObj;
import net.wicp.tams.common.es.RelaValue;
import net.wicp.tams.common.es.UpdateSet;
import net.wicp.tams.common.es.bean.MappingBean;
import net.wicp.tams.common.es.bean.MappingBean.DataTypes;
import net.wicp.tams.common.es.client.ESClient;
import net.wicp.tams.common.es.client.threadlocal.EsClientThreadlocal;
import net.wicp.tams.common.jdbc.DruidAssit;

@Slf4j
public class ListenerEs5 extends AbsBinlogListener {
	protected static final org.slf4j.Logger errorlog = org.slf4j.LoggerFactory.getLogger("errorBinlog");// 需要跳过的错误数据。

	// key:tb value: 关联的字段名
	private volatile static Map<String, String> typeMap = new HashMap<>();

	@Override
	public void doInit(Rule rule, int index) {
		Validate.isTrue(StringUtil.isNotNull(rule.getItems().get(RuleItem.index)), "每组规则都需要配置index。");
		Connection mainConn = DruidAssit.getConnection(connConf.getConfName());
		// 自动创建索引 只做一次检查就好了
		if (index == 0) {//
			// 每个实例监听都会去偿试创建新索引
			// 初始化clinet的时个会检查索引是否创建
			EsClientThreadlocal.createPerThreadEsClient(mainConn);
		}
		try {
			mainConn.close();
		} catch (SQLException e) {
			log.error("close the conn error", e);
		}
	}

	@Override
	public void doBusiTrue(Rule rule, DuckulaEvent duckulaEvent) {
		Builder esDataBuilder = EsData.newBuilder();
		esDataBuilder.setIndex(rule.getItems().get(RuleItem.index));
		esDataBuilder.setType(typeMap.get(rule.getTbOri()));
		esDataBuilder.setUpdateSet(UpdateSet.newBuilder().setUpsert(true).build());
		esDataBuilder.setAction(duckulaEvent.getOptType() == OptType.delete ? Action.delete : Action.update);

		for (int i = 0; i < duckulaEvent.getItemsCount(); i++) {
			EsObj.Builder esObjBuilder = EsObj.newBuilder();
			Map<String, String> datamap = makeSource(duckulaEvent, i);
			CollectionUtil.filterNull(datamap, 1);
			esObjBuilder.putAllSource(datamap);
			String primaryName = StringUtil.isNull(rule.getItems().get(RuleItem.primarysLogic))
					? duckulaEvent.getCols(0)
					: rule.getItems().get(RuleItem.primarysLogic);
			String idStr = DuckulaAssit.getValueStr(duckulaEvent, i, primaryName);
			esObjBuilder.setId(idStr);
			if (StringUtil.isNotNull(rule.getItems().get(RuleItem.relakey))) {
				String parentId = datamap.get(rule.getItems().get(RuleItem.relakey));
				if (StringUtils.isBlank(parentId)) {// 关联关系没有parent
					log.error("===parentid is null.请确认关联的字段是否正确，需要和数据库字段名保持一致。");
					errorlog.error(esObjBuilder.toString());// 打错误日志跳过
				} else {
					esObjBuilder.setRelaValue(RelaValue.newBuilder().setParent(parentId));// tams_relations
					esDataBuilder.addDatas(esObjBuilder);
				}
			} else {
				esDataBuilder.addDatas(esObjBuilder);
			}
		}
		if (esDataBuilder.getDatasCount() == 0) {// 没有数据（最有可能就是parentId为空值。）
			return;
		}
		ESClient esClient = EsClientThreadlocal.createPerThreadEsClient();
		esClient.docWriteBatch_tc(esDataBuilder.build());
	}

	// 暂时只支持1个主键的
	private Map<String, String> makeSource(DuckulaEvent duckulaEvent, int index) {
		String[] keys = new String[] { duckulaEvent.getCols(0) };
		Serializable[] keyValues = new Serializable[] {
				DuckulaAssit.getValue(duckulaEvent, duckulaEvent.getCols(0), index) };
		Map<String, String> datamap = new HashMap<>();
		if (duckulaEvent.getOptType() == OptType.delete) {
			for (int i = 0; i < keyValues.length; i++) {
				datamap.put(keys[i], String.valueOf(keyValues[i]));
			}
		} else {
			for (String colName : duckulaEvent.getColsList()) {
				String valuestr = DuckulaAssit.getValueStr(duckulaEvent, index, colName);
				datamap.put(colName, valuestr);
			}
		}
		CollectionUtil.filterNull(datamap, 1);
		return datamap;
	}

	// sql如果有默认值，也不做全索引同步，代价太大了。需要手动实现全量同步
	@Override
	public Result doAlterTableCallBack(Rule rule, ColHis colHis, String sql) {
		ESClient esClient = EsClientThreadlocal.createPerThreadEsClient();
		if (rule == null) {
			return Result.getSuc();// 不是我们关心的索引
		}
		String index = rule.getItems().get(RuleItem.index);
		String type = rule.getItems().get(RuleItem.type);

		List<Pair<String, String>> params = new ArrayList<Pair<String, String>>();
		for (int i = 0; i < colHis.getColsCount(); i++) {
			params.add(Pair.of(colHis.getCols(i), colHis.getColTypes(i)));
		}
		Map<String, Pair<DataTypes, DataTypes>> queryDiffMapping_tc = esClient.queryDiffMapping_tc(index, params,
				false);
		MappingBean proMappingBean = esClient.proMappingBean(queryDiffMapping_tc, type);
		Result addFields = esClient.updateIndex(index, type, proMappingBean);
		return addFields;
	}
}
